/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.editors;

import es.uma.gisum.tjtplugin.model.LiteralType;
import es.uma.gisum.tjtplugin.util.ConfigurationContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TjtInstanceJob
extends Job {
    private IProject project;
    private String fileName;
    protected static int numberOfExecutions = 1;
    private ConfigurationContainer configuration;
    protected static String ltl;
    private String mainClass;
    private String projection;
    private String objective;
    protected static String analysis;
    static boolean secondCall;

    static {
        secondCall = false;
    }

    public TjtInstanceJob(IProject project, String fileName, boolean secondCall) {
        super("TJT Instantiation");
        this.project = project;
        this.fileName = fileName;
        TjtInstanceJob.setSecondCall(secondCall);
    }

    public static void setSecondCall(boolean secondCall_) {
        secondCall = secondCall_;
    }

    public static boolean getSecondCall() {
        return secondCall;
    }

    public static int getNumberOfExecutions() {
        return numberOfExecutions;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Preparing analysis", 5);
        monitor.subTask("Loading configuration");
        try {
            this.configuration = this.loadConfiguration();
            try {
                ltl = this.configuration.getConfiguration().getProperty().getLtl();
            }
            catch (NullPointerException nullPointerException) {
                ltl = "";
            }
            try {
                this.mainClass = this.configuration.getConfiguration().getClazz().getName();
            }
            catch (NullPointerException e) {
                return new Status(4, "es.uma.gisum.TJTPlugin", "Error loading configuration file, make sure you indicate the main class of your program and set the rest of not-null parameters", (Throwable)e);
            }
            try {
                this.projection = this.configuration.getConfiguration().getProjection().getType();
            }
            catch (NullPointerException nullPointerException) {
                this.projection = "hashing";
            }
            try {
                this.objective = this.configuration.getConfiguration().getObjective().getType();
            }
            catch (NullPointerException nullPointerException) {
                this.objective = "all";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error loading configuration file, make sure you indicate the main class of your program and set the rest of not-null parameters", (Throwable)e);
        }
        monitor.worked(1);
        monitor.subTask("Instantiating template");
        try {
            this.instance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error instantiating template", (Throwable)e);
        }
        monitor.worked(1);
        monitor.subTask("Generating pan files");
        try {
            String[] opcs = this.isWindows() ? new String[]{"cmd", "/c", "spin", "-a", "instance.pml"} : new String[]{"spin", "-a", "instance.pml"};
            ProcessBuilder pb = new ProcessBuilder(opcs);
            File directory = new File(System.getProperty("user.dir").toString());
            pb.directory(directory);
            Process p = pb.start();
            InputStream es = p.getErrorStream();
            BufferedReader bre = new BufferedReader(new InputStreamReader(es));
            String aux = bre.readLine();
            while (aux != null) {
                System.out.println(aux);
                aux = bre.readLine();
            }
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error generating pan files", (Throwable)e);
        }
        monitor.worked(1);
        monitor.subTask("Compiling pan files");
        try {
            ProcessBuilder pb = new ProcessBuilder("bash");
            File directory = new File(System.getProperty("user.dir").toString());
            pb.directory(directory);
            Process p = pb.start();
            OutputStream os = p.getOutputStream();
            InputStream es = p.getErrorStream();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
            bw.write("gcc -o pan -DCLEANUP=\"killer()\" -DVECTORSZ=2048 pan.c");
            bw.flush();
            p.getOutputStream().close();
            BufferedReader bre = new BufferedReader(new InputStreamReader(es));
            String aux = bre.readLine();
            while (aux != null) {
                System.out.println(aux);
                aux = bre.readLine();
            }
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error compiling pan files", (Throwable)e);
        }
        monitor.worked(1);
        monitor.subTask("Creating JAR file");
        try {
            File mfest = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "mfest.txt");
            FileWriter fw = null;
            PrintWriter pw = null;
            fw = new FileWriter(mfest);
            pw = new PrintWriter(fw);
            if (this.mainClass == null || this.mainClass.equals("")) {
                System.err.println("empty main-class");
                return new Status(4, "es.uma.gisum.TJTPlugin", "No main class set");
            }
            pw.println("Main-Class: " + this.mainClass);
            pw.println();
            pw.close();
            fw.close();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath location = root.getLocation();
            String line = "jar -cfm " + System.getProperty("user.dir") + File.separatorChar + "test.jar " + System.getProperty("user.dir") + File.separatorChar + "mfest.txt" + " -C " + this.project.getName() + File.separatorChar + "bin" + File.separatorChar + " .";
            String[] opcs = line.split(" ");
            ProcessBuilder pb = new ProcessBuilder(opcs);
            File directory = new File(location.toString());
            pb.directory(directory);
            Process p = pb.start();
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "es.uma.gisum.TJTPlugin", "Error creating JAR file", (Throwable)e);
        }
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    private ConfigurationContainer loadConfiguration() throws FileNotFoundException, JAXBException {
        ConfigurationContainer configuration = new ConfigurationContainer();
        String filePath = String.valueOf(this.project.getLocation().toFile().toString()) + File.separator + this.fileName;
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        configuration.fromXML(reader);
        return configuration;
    }

    private void instance() throws IOException, ParserConfigurationException, SAXException, InterruptedException {
        File plantilla = this.projection.equals("counter") ? new File(String.valueOf(System.getProperty("user.dir").toString()) + File.separatorChar + "templatec.pml") : new File(String.valueOf(System.getProperty("user.dir").toString()) + File.separatorChar + "templateh.pml");
        FileReader fr = null;
        BufferedReader br = null;
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        FileReader fr2 = null;
        BufferedReader br2 = null;
        try {
            NamedNodeMap nm;
            NodeList listGrado;
            NamedNodeMap nm2;
            Node v;
            String formulaMod;
            fr = new FileReader(plantilla);
            br = new BufferedReader(fr);
            fw = new FileWriter(String.valueOf(System.getProperty("user.dir").toString()) + File.separatorChar + "instance.pml");
            pw = new PrintWriter(fw);
            int len = 0;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath location = root.getLocation();
            String projectPath = String.valueOf(location.toString()) + "/" + this.project.getName();
            String xmlPath = String.valueOf(projectPath) + "/" + this.fileName;
            Document document = builder.parse(new File(xmlPath));
            this.calculateNumberOfExecutions(document);
            NodeList listAnalysis = document.getElementsByTagName("analysis");
            if (listAnalysis.getLength() > 0) {
                Node g = listAnalysis.item(0);
                NamedNodeMap nm3 = g.getAttributes();
                Node atrib = nm3.getNamedItem("option");
                analysis = atrib.getNodeValue().toString();
            } else {
                analysis = "LTL";
            }
            String line = br.readLine();
            while (!line.contains("/*[c_state]*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            NodeList variableList = document.getElementsByTagName("variable");
            ArrayList<String> varList = new ArrayList<String>();
            ArrayList<String> typeList = new ArrayList<String>();
            ArrayList<String> objVarList = new ArrayList<String>();
            ArrayList<String> objTypeList = new ArrayList<String>();
            ArrayList<Integer> maxObjVarList = new ArrayList<Integer>();
            int i = 0;
            while (i < variableList.getLength()) {
                Node v2 = variableList.item(i);
                NamedNodeMap nm4 = v2.getAttributes();
                Node variableName = nm4.getNamedItem("name");
                Node variabletype = nm4.getNamedItem("type");
                Node variableAsObject = nm4.getNamedItem("asObject");
                Node variableMaxObjects = nm4.getNamedItem("maxObjects");
                String cType = TjtInstanceJob.convertoToCType(variabletype.getNodeValue().toString());
                String name = variableName.getNodeValue().toString().replace('.', '_');
                name = name.replace('$', '_');
                String asObject = variableAsObject.getNodeValue().toString();
                if (asObject.equals("true")) {
                    String maxObjects = variableMaxObjects.getNodeValue().toString().trim();
                    try {
                        Integer.parseInt(maxObjects);
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openWarning((Shell)new Shell(), (String)"Tracked variable error", (String)"\"MaxObjects parameter must be a number.\"");
                    }
                    int mO = Integer.parseInt(maxObjects);
                    int j = 0;
                    while (j < mO) {
                        maxObjVarList.add(mO);
                        ++j;
                    }
                    j = 0;
                    while (j < mO) {
                        if (cType.equals("char *")) {
                            if (analysis.equals("LTL")) {
                                pw.println("c_decl { char " + name + j + "[50]; };");
                                pw.println("c_track \"&" + name + j + "\" \"sizeof(char)*50\" \"UnMatched\"");
                            } else {
                                pw.println("c_state \"char " + name + j + "[50]\" \"Global\" ");
                            }
                        } else if (analysis.equals("LTL")) {
                            pw.println("c_decl { " + cType + " " + name + j + "=0; };");
                            pw.println("c_track \"&" + name + j + "\" \"sizeof(int)\" \"UnMatched\"");
                        } else {
                            pw.println("c_state \"" + cType + " " + name + j + "\" \"Global\" \"0\"");
                        }
                        objVarList.add(String.valueOf(name) + j);
                        objTypeList.add(cType);
                        ++j;
                    }
                } else {
                    varList.add(name);
                    typeList.add(cType);
                    if (cType.equals("char *")) {
                        if (analysis.equals("LTL")) {
                            pw.println("c_decl { char " + name + "[50]; };");
                            pw.println("c_track \"&" + name + "\" \"sizeof(char)*50\" \"UnMatched\"");
                        } else {
                            pw.println("c_state \"char " + name + "[50]\" \"Global\" ");
                        }
                    } else if (analysis.equals("LTL")) {
                        pw.println("c_decl { " + cType + " " + name + "=0; };");
                        pw.println("c_track \"&" + name + "\" \"sizeof(int)\" \"UnMatched\"");
                    } else {
                        pw.println("c_state \"" + cType + " " + name + "\" \"Global\" \"0\"");
                    }
                }
                ++i;
            }
            if (analysis.equals("LTL")) {
                pw.println("c_decl { char location[150]; char method[150]; char exception[150]; int threadID=1;};");
                pw.println("c_track \"&threadID\" \"sizeof(int)\" \"UnMatched\"");
                pw.println("c_track \"&method\" \"sizeof(char)*150\" \"UnMatched\"");
                pw.println("c_track \"&exception\" \"sizeof(char)*150\" \"UnMatched\"");
                pw.println("c_track \"&location\" \"sizeof(char)*150\" \"UnMatched\"");
            } else {
                pw.println("c_state \"char location[150]\" \"Global\"");
                pw.println("c_state \"char method[150]\" \"Global\"");
                pw.println("c_state \"char exception[150]\" \"Global\"");
                pw.println("c_state \"int threadID\" \"Global\" \"1\"");
            }
            pw.println();
            int maxThreadsLocation = 1;
            if (!analysis.equals("LTL")) {
                NodeList threadsLoc = document.getElementsByTagName("maxThreads");
                if (threadsLoc.getLength() > 0) {
                    Node v3 = threadsLoc.item(0);
                    NamedNodeMap nm5 = v3.getAttributes();
                    Node maxThreads = nm5.getNamedItem("maxThreads");
                    if (maxThreads != null) {
                        try {
                            maxThreadsLocation = Integer.parseInt(maxThreads.getNodeValue().toString());
                            if (maxThreadsLocation < 1) {
                                maxThreadsLocation = 1;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            MessageDialog.openWarning((Shell)new Shell(), (String)"Max threads number error", (String)"\"MaxThreads parameter must be a number.\"");
                        }
                    }
                    pw.println("c_state \"int ThreadsLoc[" + maxThreadsLocation + "] \" \"Global\" ");
                } else {
                    pw.println("c_state \"int ThreadsLoc[1] \" \"Global\" ");
                }
            }
            NodeList argList = document.getElementsByTagName("argument");
            StringBuffer serieArgs = new StringBuffer();
            ArrayList<String> generatedArgs = new ArrayList<String>();
            serieArgs.append("");
            int i2 = 0;
            while (i2 < argList.getLength()) {
                Node v4 = argList.item(i2);
                NamedNodeMap nm6 = v4.getAttributes();
                Node nom_arg = nm6.getNamedItem("name");
                serieArgs.append("Args[" + i2 + "], ");
                if (nom_arg != null) {
                    generatedArgs.add(nom_arg.getNodeValue().toString());
                } else {
                    generatedArgs.add("arg" + i2);
                }
                ++i2;
            }
            len = generatedArgs.size();
            int auxLen = len * 20;
            if (len > 0) {
                pw.println("c_decl{\n\tchar Args[" + len + "][20];\n};");
            } else {
                pw.println("c_decl{\n\tchar Args[1][20];\n};");
            }
            pw.println("c_track \"&Args\" \"sizeof(char)*" + auxLen + "\" \"UnMatched\"");
            line = br.readLine();
            while (!line.contains("/*[defines]*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            NodeList listDef = document.getElementsByTagName("literal");
            int maxObjLTL = 0;
            ArrayList<String> specialLiterals = new ArrayList<String>();
            String syntaxLiterals = "";
            if (analysis.equals("LTL")) {
                int i3 = 0;
                while (i3 < listDef.getLength()) {
                    Node g = listDef.item(i3);
                    NamedNodeMap nm7 = g.getAttributes();
                    Node atrib = nm7.getNamedItem("name");
                    String lit = atrib.getNodeValue().toString();
                    Node atrib2 = nm7.getNamedItem("expression");
                    String expr = this.prepareExpression(atrib2.getNodeValue().toString());
                    if (expr.contains("?") || expr.contains("@")) {
                        System.out.println(expr);
                        specialLiterals.add(lit);
                        syntaxLiterals = expr.contains("@") ? "@" : "?";
                        boolean found = false;
                        int j = 0;
                        while (j < objVarList.size() && !found) {
                            if (expr.contains(((String)objVarList.get(j)).substring(0, ((String)objVarList.get(j)).length() - 1))) {
                                found = true;
                                maxObjLTL = (Integer)maxObjVarList.get(j);
                                continue;
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < maxObjLTL) {
                            pw.println("#define " + atrib.getNodeValue().toString() + j + " c_expr{" + this.indexExpression(j, expr) + "}");
                            ++j;
                        }
                    } else {
                        pw.println("#define " + atrib.getNodeValue().toString() + " c_expr{" + expr + "}");
                    }
                    ++i3;
                }
            }
            if (maxObjLTL == 0) {
                formulaMod = ltl;
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                int i4 = 0;
                while (i4 < maxObjLTL) {
                    StringBuffer sbAux = new StringBuffer();
                    StringTokenizer st = new StringTokenizer(ltl, ",&|()<>[]-\" ", true);
                    sbAux.append("(");
                    while (st.hasMoreTokens()) {
                        String str = st.nextToken();
                        if (specialLiterals.contains(str)) {
                            sbAux.append(String.valueOf(str) + i4);
                            continue;
                        }
                        sbAux.append(str);
                    }
                    sbAux.append(")");
                    if (i4 == maxObjLTL - 1) {
                        sb.append(sbAux.toString());
                    } else if (syntaxLiterals.equals("@")) {
                        sb.append(String.valueOf(sbAux.toString()) + " && ");
                    } else {
                        sb.append(String.valueOf(sbAux.toString()) + " || ");
                    }
                    ++i4;
                }
                sb.append(")");
                formulaMod = sb.toString();
            }
            pw.println();
            line = br.readLine();
            while (!line.contains("/*[never_claim]*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            System.out.println(">>>>> " + formulaMod);
            if (analysis.equalsIgnoreCase("NP") || analysis.equalsIgnoreCase("Both") && !secondCall) {
                ltl = formulaMod = "<>[]np_";
            }
            if (this.objective.equals("all") || this.objective.equals("some")) {
                formulaMod = "!(" + formulaMod + ")";
                System.out.println("formula (negated <all>): " + formulaMod + " " + secondCall);
            } else {
                System.out.println("formula: " + formulaMod + " " + secondCall);
            }
            String[] opcs = this.isWindows() ? new String[]{"cmd", "/c", "spin", "-f", "\"" + formulaMod + "\"", ">", "formula.txt"} : new String[]{"bash", "-c", "spin -f '" + formulaMod + "' > formula.txt"};
            ProcessBuilder pb = new ProcessBuilder(opcs);
            File directory = new File(System.getProperty("user.dir").toString());
            pb.directory(directory);
            Process p = pb.start();
            p.waitFor();
            File formula = new File(String.valueOf(System.getProperty("user.dir").toString()) + File.separatorChar + "formula.txt");
            fr2 = new FileReader(formula);
            br2 = new BufferedReader(fr2);
            line = br2.readLine();
            if (line != null && !line.contains("never")) {
                line = null;
            } else {
                String str = ltl;
                StringTokenizer st = new StringTokenizer(str, "!<>[]->U()&| ");
                ArrayList<String> addedLiterals = new ArrayList<String>();
                boolean error = false;
                LiteralType lt2 = null;
                for (LiteralType lt2 : this.configuration.getConfiguration().getLiteral()) {
                    addedLiterals.add(lt2.getName());
                }
                while (st.hasMoreTokens() && !error) {
                    String tok = st.nextToken();
                    System.out.println("token: " + tok);
                    if (addedLiterals.contains(tok) || tok.equals("np_")) continue;
                    error = true;
                }
                if (error) {
                    System.err.println("undefined literals at formula.");
                    MessageDialog.openWarning((Shell)new Shell(), (String)"Formula error", (String)"undefined literals at formula.");
                }
                while (line != null) {
                    if (line.contains("never")) {
                        pw.println(line);
                        pw.println("Inicio:");
                        pw.println("\tif");
                        pw.println("\t:: (! guard)-> goto Inicio");
                        pw.println("\t:: (guard) -> true;goto T0_init");
                        pw.println("\tfi;");
                        line = br2.readLine();
                        continue;
                    }
                    pw.println(line);
                    line = br2.readLine();
                }
            }
            line = br.readLine();
            while (!line.contains("c_code {") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            if (varList.size() != 0) {
                pw.println("\tvoid * Variables[" + varList.size() + "];");
                pw.println("\tchar Types[" + typeList.size() + "][10];");
                pw.println("\tchar Names[" + varList.size() + "][50];");
            } else {
                pw.println("\tvoid * Variables[0];");
                pw.println("\tchar Types[0][10];");
                pw.println("\tchar Names[0][50];");
            }
            if (objVarList.size() != 0) {
                pw.println("\tvoid * VariablesO[" + objVarList.size() + "];");
                pw.println("\tchar TypesO[" + objTypeList.size() + "][10];");
                pw.println("\tchar NamesO[" + objVarList.size() + "][50];");
            } else {
                pw.println("\tvoid * VariablesO[0];");
                pw.println("\tchar TypesO[0][10];");
                pw.println("\tchar NamesO[0][50];");
            }
            pw.println();
            pw.println("\tint nArgs =" + generatedArgs.size() + ";");
            int k = 0;
            while (k < argList.getLength()) {
                v = argList.item(k);
                NodeList valores = v.getChildNodes();
                Node nt = valores.item(0);
                String[] positions = nt.getNodeValue().toString().split(", ");
                pw.println("\tchar args" + k + "[" + positions.length + "][20];");
                ++k;
            }
            if (analysis.equals("LTL")) {
                NodeList threadsLoc = document.getElementsByTagName("maxThreads");
                if (threadsLoc.getLength() > 0) {
                    v = threadsLoc.item(0);
                    nm2 = v.getAttributes();
                    Node maxThreads = nm2.getNamedItem("maxThreads");
                    if (maxThreads != null) {
                        try {
                            maxThreadsLocation = Integer.parseInt(maxThreads.getNodeValue().toString());
                            if (maxThreadsLocation < 1) {
                                maxThreadsLocation = 1;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            MessageDialog.openWarning((Shell)new Shell(), (String)"Max threads number error", (String)"\"MaxThreads parameter must be a number.\"");
                        }
                    }
                    pw.println("\tint ThreadsLoc[" + maxThreadsLocation + "];");
                } else {
                    pw.println("\tint ThreadsLoc[1];");
                }
            }
            pw.println();
            NodeList listProg = document.getElementsByTagName("class");
            if (listProg.getLength() > 0) {
                Node g = listProg.item(0);
                nm2 = g.getAttributes();
                Node atrib = nm2.getNamedItem("name");
                pw.println("\tchar progName[40]=\"" + atrib.getNodeValue().toString() + "\";");
                this.mainClass = atrib.getNodeValue().toString();
            }
            if ((listGrado = document.getElementsByTagName("update")).getLength() > 0) {
                Node g = listGrado.item(0);
                NamedNodeMap nm8 = g.getAttributes();
                Node atrib = nm8.getNamedItem("degree");
                if (atrib.getNodeValue().toString().equalsIgnoreCase("Method")) {
                    pw.println("\tint several=1;");
                } else if (atrib.getNodeValue().toString().equalsIgnoreCase("Modification")) {
                    pw.println("\tint several=0;");
                } else {
                    pw.println("\tint several=0;");
                }
            } else {
                pw.println("\tint several=0;");
            }
            if (this.objective.equals("all")) {
                pw.println("\tint objective=-1;");
            } else if (this.objective.equals("some")) {
                pw.println("\tint objective=0;");
            } else if (this.objective.equals("none")) {
                pw.println("\tint objective=1;");
            } else {
                pw.println("\tint objective=-1;");
            }
            if (analysis.equalsIgnoreCase("LTL") || analysis.equalsIgnoreCase("Both") && TjtInstanceJob.getSecondCall()) {
                NodeList listCounterLimit = document.getElementsByTagName("limit");
                if (listCounterLimit.getLength() > 0) {
                    Node g = listCounterLimit.item(0);
                    NamedNodeMap nm9 = g.getAttributes();
                    Node atrib = nm9.getNamedItem("counterLimit");
                    String counterLimitValue = atrib.getNodeValue().toString();
                    if (counterLimitValue != null) {
                        if (!counterLimitValue.equals("0") && Integer.parseInt(counterLimitValue) > 0) {
                            pw.println("\tint counterLimit=" + counterLimitValue + ";");
                        } else {
                            pw.println("\tint counterLimit=0;");
                        }
                    } else {
                        pw.println("\tint counterLimit=10000;");
                    }
                } else {
                    pw.println("\tint counterLimit=10000;");
                }
                pw.println("\tint isNPS=0;");
            } else {
                pw.println("\tint counterLimit=0;");
                pw.println("\tint isNPS=1;");
            }
            if (numberOfExecutions <= 0) {
                numberOfExecutions = 1;
            }
            pw.println("\tint verdicts[" + numberOfExecutions + "];");
            pw.println("\tint numberOfExecutions=" + numberOfExecutions + ";");
            pw.println();
            line = br.readLine();
            while (!line.contains("/*java fields required*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            int i5 = 0;
            while (i5 < varList.size()) {
                if (((String)typeList.get(i5)).equals("char *")) {
                    pw.println("\t\tchar v" + i5 + "[50];");
                } else {
                    pw.println("\t\t" + (String)typeList.get(i5) + " v" + i5 + ";");
                }
                ++i5;
            }
            i5 = 0;
            while (i5 < objVarList.size()) {
                if (((String)objTypeList.get(i5)).equals("char *")) {
                    pw.println("\t\tchar o" + i5 + "[50];");
                } else {
                    pw.println("\t\t" + (String)objTypeList.get(i5) + " o" + i5 + ";");
                }
                ++i5;
            }
            pw.println("\t\tint thl[" + maxThreadsLocation + "];");
            pw.println();
            line = br.readLine();
            while (!line.contains("/*initialize*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\texception[i]=c;");
                pw.println("\t\tlocation[i]=c;");
                pw.println("\t\tmethod[i]=c;");
            } else {
                pw.println("\t\tnow.exception[i]=c;");
                pw.println("\t\tnow.location[i]=c;");
                pw.println("\t\tnow.method[i]=c;");
            }
            line = br.readLine();
            while (!line.contains("/*link variables*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            if (this.projection.equals("hashing")) {
                pw.println("\t\tresetHashCode();");
            }
            i5 = 0;
            while (i5 < varList.size()) {
                if (((String)typeList.get(i5)).equals("char *")) {
                    pw.println("\t\tfor(i=0;i<50;i++){");
                    if (analysis.equals("LTL")) {
                        pw.println("\t\t\t" + (String)varList.get(i5) + "[i]=c;");
                    } else {
                        pw.println("\t\t\tnow." + (String)varList.get(i5) + "[i]=c;");
                    }
                    pw.println("\t\t}");
                }
                if (analysis.equals("LTL")) {
                    pw.println("\t\tVariables[" + i5 + "]=&" + (String)varList.get(i5) + ";");
                } else {
                    pw.println("\t\tVariables[" + i5 + "]=&now." + (String)varList.get(i5) + ";");
                }
                pw.println("\t\tstrcpy(Types[" + i5 + "],\"" + (String)typeList.get(i5) + "\");");
                pw.println("\t\tstrcpy(Names[" + i5 + "],\"" + (String)varList.get(i5) + "\");");
                ++i5;
            }
            i5 = 0;
            while (i5 < objVarList.size()) {
                if (((String)objTypeList.get(i5)).equals("char *")) {
                    pw.println("\t\tfor(i=0;i<50;i++){");
                    if (analysis.equals("LTL")) {
                        pw.println("\t\t\t" + (String)objVarList.get(i5) + "[i]=c;");
                    } else {
                        pw.println("\t\t\tnow." + (String)objVarList.get(i5) + "[i]=c;");
                    }
                    pw.println("\t\t}");
                }
                if (analysis.equals("LTL")) {
                    pw.println("\t\tVariablesO[" + i5 + "]=&" + (String)objVarList.get(i5) + ";");
                } else {
                    pw.println("\t\tVariablesO[" + i5 + "]=&now." + (String)objVarList.get(i5) + ";");
                }
                pw.println("\t\tstrcpy(TypesO[" + i5 + "],\"" + (String)objTypeList.get(i5) + "\");");
                pw.println("\t\tstrcpy(NamesO[" + i5 + "],\"" + (String)objVarList.get(i5) + "\");");
                ++i5;
            }
            pw.println();
            int z = 0;
            while (z < typeList.size()) {
                if (((String)typeList.get(z)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(" + (String)varList.get(z) + ",\" \");");
                    } else {
                        pw.println("\t\tstrcpy(now." + (String)varList.get(z) + ",\" \");");
                    }
                }
                ++z;
            }
            z = 0;
            while (z < objTypeList.size()) {
                if (((String)objTypeList.get(z)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(" + (String)objVarList.get(z) + ",\" \");");
                    } else {
                        pw.println("\t\tstrcpy(now." + (String)objVarList.get(z) + ",\" \");");
                    }
                }
                ++z;
            }
            if (argList.getLength() > 0) {
                pw.println("\n\t\tgenerateArgs();");
            }
            line = br.readLine();
            while (!line.contains("/*generate arguments*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (argList.getLength() > 0) {
                pw.println("\tgenerateArgs(){\n");
                int k2 = 0;
                while (k2 < argList.getLength()) {
                    Node v5 = argList.item(k2);
                    NodeList valores = v5.getChildNodes();
                    Node nt = valores.item(0);
                    nm = v5.getAttributes();
                    Node range_arg = nm.getNamedItem("range");
                    if (range_arg != null && range_arg.getNodeValue().toString().equals("false")) {
                        String[] argValues = nt.getNodeValue().toString().split(", ");
                        int n = 0;
                        while (n < argValues.length) {
                            pw.println("\t\t strcpy(args" + k2 + "[" + n + "],\"" + argValues[n] + "\");");
                            ++n;
                        }
                    }
                    pw.println();
                    ++k2;
                }
                pw.println("\t}");
            }
            pw.println();
            line = br.readLine();
            while (!line.contains("/*edit execlp*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            String traceHeader = "";
            traceHeader = analysis.equalsIgnoreCase("LTL") || analysis.equalsIgnoreCase("NP") ? analysis : (analysis.equalsIgnoreCase("Both") && secondCall ? "LTL" : "NP");
            if (this.projection.equals("counter")) {
                pw.println("\t\t\tif (execlp(\"java\",\"java\",\"-jar\",\"jdic.jar\",\"-analysis\",\"" + analysis + "\",\"-output\",\"" + projectPath + "/" + traceHeader + "trace.tjttrace\",\"-conf\",\"" + xmlPath + "\",\"test.jar\", " + serieArgs.toString() + "NULL) == -1) {");
            } else {
                pw.println("\t\t\tif (execlp(\"java\",\"java\",\"-jar\",\"jdih.jar\",\"-analysis\",\"" + analysis + "\",\"-output\",\"" + projectPath + "/" + traceHeader + "trace.tjttrace\",\"-conf\",\"" + xmlPath + "\",\"test.jar\", " + serieArgs.toString() + "NULL) == -1) {");
            }
            line = br.readLine();
            while (!line.contains("/*array of characters assignment*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                z = 0;
                boolean atLeastOneArray = false;
                while (z < typeList.size()) {
                    if (((String)typeList.get(z)).equals("char *")) {
                        if (!atLeastOneArray) {
                            atLeastOneArray = true;
                            pw.println("\t\t\tint i=0;");
                            pw.println("\t\t\tchar c=' ';");
                            pw.println("\t\t\tswitch(ind){");
                        }
                        pw.println("\t\t\t  case " + z + ":");
                        pw.println("\t\t\t\tfor(i=0;i<50;i++){");
                        if (analysis.equals("LTL")) {
                            pw.println("\t\t\t\t\t" + (String)varList.get(z) + "[i]=c;");
                            pw.println("\t\t\t\t}");
                            pw.println("\t\t\t\tstrcpy(" + (String)varList.get(z) + ",pt);");
                            pw.println("\t\t\t\tprintf(\"%s = %s\\n\",Names[ind]," + (String)varList.get(z) + ");break;");
                        } else {
                            pw.println("\t\t\t\t\tnow." + (String)varList.get(z) + "[i]=c;");
                            pw.println("\t\t\t\t}");
                            pw.println("\t\t\t\tstrcpy(now." + (String)varList.get(z) + ",pt);");
                            pw.println("\t\t\t\tprintf(\"%s = %s\\n\",Names[ind],now." + (String)varList.get(z) + ");break;");
                        }
                    }
                    ++z;
                }
                if (atLeastOneArray) {
                    pw.println("\t\t\t}");
                }
            }
            line = br.readLine();
            while (!line.contains("/*array of characters assignment at objects*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                z = 0;
                boolean atLeastOneArray = false;
                while (z < objTypeList.size()) {
                    if (((String)objTypeList.get(z)).equals("char *")) {
                        if (!atLeastOneArray) {
                            atLeastOneArray = true;
                            pw.println("\t\t\tint i=0;");
                            pw.println("\t\t\tchar c=' ';");
                            pw.println("\t\t\tswitch(ind){");
                        }
                        pw.println("\t\t\t  case " + z + ":");
                        pw.println("\t\t\t\tfor(i=0;i<50;i++){");
                        if (analysis.equals("LTL")) {
                            pw.println("\t\t\t\t\t" + (String)objVarList.get(z) + "[i]=c;");
                            pw.println("\t\t\t\t}");
                            pw.println("\t\t\t\tstrcpy(" + (String)objVarList.get(z) + ",pt);");
                            pw.println("\t\t\t\tprintf(\"%s = %s\\n\",NamesO[ind]," + (String)objVarList.get(z) + ");break;");
                        } else {
                            pw.println("\t\t\t\t\tnow." + (String)objVarList.get(z) + "[i]=c;");
                            pw.println("\t\t\t\t}");
                            pw.println("\t\t\t\tstrcpy(now." + (String)objVarList.get(z) + ",pt);");
                            pw.println("\t\t\t\tprintf(\"%s = %s\\n\",NamesO[ind],now." + (String)objVarList.get(z) + ");break;");
                        }
                    }
                    ++z;
                }
                if (atLeastOneArray) {
                    pw.println("\t\t\t}");
                }
            }
            line = br.readLine();
            while (!line.contains("/*read method*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\tmethod[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(method,ptraux);");
                pw.println("printf(\"Method= %s\\n\",method);");
            } else {
                pw.println("\t\t\tnow.method[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(now.method,ptraux);");
                pw.println("printf(\"Method= %s\\n\",now.method);");
            }
            line = br.readLine();
            while (!line.contains("/*read location*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\tlocation[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(location,ptraux);");
                pw.println("printf(\"Location= %s\\n\",location);");
                pw.println("\t\tstrcpy(exception,\" \");");
            } else {
                pw.println("\t\t\tnow.location[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(now.location,ptraux);");
                pw.println("printf(\"Location= %s\\n\",now.location);");
                pw.println("\t\tstrcpy(now.exception,\" \");");
            }
            if (this.projection.equals("hashing")) {
                line = br.readLine();
                while (!line.contains("/*read hashCode*/") && line != null) {
                    pw.println(line);
                    line = br.readLine();
                }
                pw.println("\t\t\tnow.hashCode[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(now.hashCode,ptraux);");
                pw.println("printf(\"HashCode= %s\\n\",now.hashCode);");
            }
            line = br.readLine();
            while (!line.contains("/*read location exception*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\tlocation[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(location,ptraux);");
                pw.println("printf(\"Location= %s\\n\",location);");
            } else {
                pw.println("\t\t\tnow.location[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(now.location,ptraux);");
                pw.println("printf(\"Location= %s\\n\",now.location);");
            }
            line = br.readLine();
            while (!line.contains("/*read exception*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\texception[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(exception,ptraux);");
                pw.println("printf(\"Exception= %s\\n\",exception);");
            } else {
                pw.println("\t\t\tnow.exception[i]=c;");
                pw.println("\t\t}");
                pw.println("\t\tptraux[reading]='\\0';");
                pw.println("\t\tstrcpy(now.exception,ptraux);");
                pw.println("printf(\"Exception= %s\\n\",now.exception);");
            }
            line = br.readLine();
            while (!line.contains("/*thread location*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("ThreadsLoc[ind]=reading;");
            } else {
                pw.println("now.ThreadsLoc[ind]=reading;");
            }
            line = br.readLine();
            while (!line.contains("/*read thid*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\tthreadID=reading;");
                pw.println("\t\t\tprintf(\"Thread id= %d\\n\",threadID);");
            } else {
                pw.println("\t\t\tnow.threadID=reading;");
                pw.println("\t\t\tprintf(\"Thread id= %d\\n\",now.threadID);");
            }
            line = br.readLine();
            while (!line.contains("/*rest strings*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            int i6 = 0;
            while (i6 < typeList.size()) {
                if (((String)typeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(" + (String)varList.get(i6) + ", \" \");");
                    } else {
                        pw.println("\t\tstrcpy(" + (String)varList.get(i6) + ", \" \");");
                    }
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < objTypeList.size()) {
                if (((String)objTypeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(" + (String)objVarList.get(i6) + ", \" \");");
                    } else {
                        pw.println("\t\tstrcpy(now." + (String)objVarList.get(i6) + ", \" \");");
                    }
                }
                ++i6;
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\tstrcpy(method, \" \");");
                pw.println("\t\tstrcpy(location, \" \");");
            } else {
                pw.println("\t\tstrcpy(now.method, \" \");");
                pw.println("\t\tstrcpy(now.location, \" \");");
            }
            line = br.readLine();
            while (!line.contains("/*asignations to list fields*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            i6 = 0;
            while (i6 < varList.size()) {
                if (((String)typeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(newElement->v" + i6 + "," + (String)varList.get(i6) + ");");
                    } else {
                        pw.println("\t\tstrcpy(newElement->v" + i6 + ",now." + (String)varList.get(i6) + ");");
                    }
                } else if (analysis.equals("LTL")) {
                    pw.println("\t\tnewElement->v" + i6 + "=" + (String)varList.get(i6) + ";");
                } else {
                    pw.println("\t\tnewElement->v" + i6 + "=now." + (String)varList.get(i6) + ";");
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < objVarList.size()) {
                if (((String)objTypeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\tstrcpy(newElement->o" + i6 + "," + (String)objVarList.get(i6) + ");");
                    } else {
                        pw.println("\t\tstrcpy(newElement->o" + i6 + ",now." + (String)objVarList.get(i6) + ");");
                    }
                } else if (analysis.equals("LTL")) {
                    pw.println("\t\tnewElement->o" + i6 + "=" + (String)objVarList.get(i6) + ";");
                } else {
                    pw.println("\t\tnewElement->o" + i6 + "=now." + (String)objVarList.get(i6) + ";");
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < maxThreadsLocation) {
                if (analysis.equals("LTL")) {
                    pw.println("\t\tnewElement->thl[" + i6 + "]=ThreadsLoc[" + i6 + "];");
                } else {
                    pw.println("\t\tnewElement->thl[" + i6 + "]=now.ThreadsLoc[" + i6 + "];");
                }
                pw.println("\t\t\tprintf(\"ThreadsLoc[" + i6 + "]=%d;\",newElement->thl[" + i6 + "]);");
                ++i6;
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\tstrcpy(newElement->loc,location);\n\t\tstrcpy(newElement->met,method);\n\t\tstrcpy(newElement->exc,exception);\n\t\tnewElement->thid=threadID;");
            } else {
                pw.println("\t\tstrcpy(newElement->loc,now.location);\n\t\tstrcpy(newElement->met,now.method);\n\t\tstrcpy(newElement->exc,now.exception);\n\t\tnewElement->thid=now.threadID;");
            }
            line = br.readLine();
            while (!line.contains("/*get fields and print*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\tstrcpy(location,ptr->loc);\n\t\tstrcpy(method,ptr->met);\n\t\tstrcpy(exception,ptr->exc);\n\t\tthreadID=ptr->thid;");
            } else {
                pw.println("\t\tstrcpy(now.location,ptr->loc);\n\t\tstrcpy(now.method,ptr->met);\n\t\tstrcpy(now.exception,ptr->exc);\n\t\tnow.threadID=ptr->thid;");
            }
            i6 = 0;
            while (i6 < varList.size()) {
                if (((String)typeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\t\tstrcpy(" + (String)varList.get(i6) + ",ptr->v" + i6 + ");");
                    } else {
                        pw.println("\t\t\tstrcpy(now." + (String)varList.get(i6) + ",ptr->v" + i6 + ");");
                    }
                } else if (analysis.equals("LTL")) {
                    pw.println("\t\t\t" + (String)varList.get(i6) + "=ptr->v" + i6 + ";");
                } else {
                    pw.println("\t\t\tnow." + (String)varList.get(i6) + "=ptr->v" + i6 + ";");
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < varList.size()) {
                pw.println("\t\t\tprintf(\"" + (String)varList.get(i6) + ": " + TjtInstanceJob.typeToPrint((String)typeList.get(i6)) + "\\n\",ptr->v" + i6 + ");");
                ++i6;
            }
            i6 = 0;
            while (i6 < objVarList.size()) {
                if (((String)objTypeList.get(i6)).equals("char *")) {
                    if (analysis.equals("LTL")) {
                        pw.println("\t\t\tstrcpy(" + (String)objVarList.get(i6) + ",ptr->o" + i6 + ");");
                    } else {
                        pw.println("\t\t\tstrcpy(now." + (String)objVarList.get(i6) + ",ptr->o" + i6 + ");");
                    }
                } else if (analysis.equals("LTL")) {
                    pw.println("\t\t\t" + (String)objVarList.get(i6) + "=ptr->o" + i6 + ";");
                } else {
                    pw.println("\t\t\tnow." + (String)objVarList.get(i6) + "=ptr->o" + i6 + ";");
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < objVarList.size()) {
                pw.println("\t\t\tprintf(\"" + (String)objVarList.get(i6) + ": " + TjtInstanceJob.typeToPrint((String)objTypeList.get(i6)) + "\\n\",ptr->o" + i6 + ");");
                ++i6;
            }
            i6 = 0;
            while (i6 < maxThreadsLocation) {
                if (analysis.equals("LTL")) {
                    pw.println("\t\t\tThreadsLoc[" + i6 + "]=ptr->thl[" + i6 + "];");
                } else {
                    pw.println("\t\t\tnow.ThreadsLoc[" + i6 + "]=ptr->thl[" + i6 + "];");
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < maxThreadsLocation) {
                pw.println("\t\t\tprintf(\"ThreadsLoc[" + i6 + "]=%d;\",ptr->thl[" + i6 + "]);");
                ++i6;
            }
            line = br.readLine();
            while (!line.contains("/*catched or uncatched*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            if (analysis.equals("LTL")) {
                pw.println("\t\t\tif(strcmp(location,\"null\")!=0){\n\t\t\t\tprintf(\"Catched at: %s\\n\",location);");
            } else {
                pw.println("\t\t\tif(strcmp(now.location,\"null\")!=0){\n\t\t\t\tprintf(\"Catched at: %s\\n\",now.location);");
            }
            line = br.readLine();
            while (!line.contains("/*generators*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            i6 = 0;
            while (i6 < argList.getLength()) {
                Node nt;
                NodeList valores;
                boolean hasRange = false;
                Node v6 = argList.item(i6);
                nm = v6.getAttributes();
                Node nom_arg = nm.getNamedItem("name");
                Node range_arg = nm.getNamedItem("range");
                if (range_arg != null && range_arg.getNodeValue().toString().equals("true")) {
                    hasRange = true;
                }
                String argu = "arg_" + nom_arg.getNodeValue().toString();
                if (hasRange) {
                    valores = v6.getChildNodes();
                    nt = valores.item(0);
                    String ran = nt.getNodeValue().toString();
                    int h = 0;
                    int startRange = 0;
                    int endRange = 0;
                    if (ran.contains("..")) {
                        h = ran.indexOf("..");
                        startRange = Integer.parseInt(ran.substring(0, h));
                        endRange = Integer.parseInt(ran.substring(h + 2, ran.length()));
                        if (endRange < startRange) {
                            startRange = 0;
                            endRange = 1;
                        }
                    }
                    int numComb = endRange - startRange + 1;
                    pw.println("inline set_" + argu + "() {");
                    pw.println();
                    pw.println("\tint argC" + i6 + "=0;");
                    pw.println("\tint numComb" + i6 + "=" + numComb + ";");
                    pw.println("\tint startRange" + i6 + "=" + startRange + ";");
                    pw.println("\tc_code{");
                    pw.println("\t\tsprintf(intToStr,\"%d\",Pinit->startRange" + i6 + ");");
                    pw.println("\t\tstrcpy(Args[" + i6 + "], intToStr);");
                    pw.println("\t\tPinit->argC" + i6 + "++;");
                    pw.println("\t};");
                    pw.println("\n\tdo");
                    pw.println("\t:: (argC" + i6 + " <numComb" + i6 + ") -> c_code {");
                    pw.println("\t\t\t\tint valor=Pinit->startRange" + i6 + "+Pinit->argC" + i6 + ";");
                    pw.println("\t\t\t\tsprintf(intToStr,\"%d\",valor);");
                    pw.println("\t\t\t\tstrcpy(Args[" + i6 + "], intToStr);");
                    pw.println("\t\t\t\tPinit->argC" + i6 + "++;");
                    pw.println("\t\t\t\t};");
                    pw.println("\t:: 1 -> break;");
                    pw.println("\tod;");
                    pw.println("}");
                    pw.println();
                } else {
                    valores = v6.getChildNodes();
                    nt = valores.item(0);
                    String[] argValues = nt.getNodeValue().toString().split(", ");
                    int maxArgs = argValues.length;
                    pw.println("inline set_" + argu + "() {");
                    pw.println();
                    pw.println("\tint argC" + i6 + "=0;");
                    pw.println("\tint maxArg" + i6 + "=" + maxArgs + ";");
                    pw.println("\tc_code{");
                    pw.println("\t\tstrcpy(Args[" + i6 + "], args" + i6 + "[Pinit->argC" + i6 + "]);");
                    pw.println("\t\tPinit->argC" + i6 + "++;");
                    pw.println("\t};");
                    pw.println("\n\tdo");
                    pw.println("\t:: (argC" + i6 + " <maxArg" + i6 + ") -> c_code {");
                    pw.println("\t\t\t\tstrcpy(Args[" + i6 + "], args" + i6 + "[Pinit->argC" + i6 + "]);");
                    pw.println("\t\t\t\tPinit->argC" + i6 + "++;");
                    pw.println("\t\t\t\t};");
                    pw.println("\t:: 1 -> break;");
                    pw.println("\tod;");
                    pw.println("}");
                    pw.println();
                }
                ++i6;
            }
            pw.println("inline generateConfig(){");
            i6 = 0;
            while (i6 < generatedArgs.size()) {
                pw.println("\tset_arg_" + (String)generatedArgs.get(i6) + "();");
                ++i6;
            }
            line = br.readLine();
            while (!line.contains("/*number of executions*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println(line);
                pw.println();
            }
            NodeList listNumber = document.getElementsByTagName("repeat");
            int auxNum = 1;
            int num = 1;
            if (listNumber.getLength() > 0) {
                Node g = listNumber.item(0);
                NamedNodeMap nm10 = g.getAttributes();
                Node atrib = nm10.getNamedItem("times");
                try {
                    num = Integer.parseInt(atrib.getNodeValue().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    num = 1;
                    MessageDialog.openWarning((Shell)new Shell(), (String)"\"Repeat\" parameter error", (String)"It must be a number.");
                }
                auxNum = num;
                if (auxNum == 0) {
                    auxNum = 1;
                }
                num = num > 0 ? --num : 0;
                pw.println("\tdo");
                pw.println("\t::(c<" + num + ")->");
                pw.println("\t  c_code{Pinit->c++;now.count=n_exec;");
                if (this.projection.equals("hashing")) {
                    pw.println("\t  resetHashCode();");
                } else {
                    pw.println("\t  now.progCount=0;");
                }
                pw.println("\t};");
            } else {
                pw.println("\tdo");
                pw.println("\t::(c<0)->c++;");
                pw.println("\t   c_code{now.count=n_exec;};");
            }
            line = br.readLine();
            while (!line.contains("/*print args*/") && line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (line != null) {
                pw.println();
            }
            int l = 0;
            while (l < generatedArgs.size()) {
                if (l == 0) {
                    pw.println("\t\t\tprintf(\"Arguments: \");");
                }
                if (l == generatedArgs.size() - 1) {
                    pw.println("\t\t\tprintf(\"" + (String)generatedArgs.get(l) + " = %s;\\n\", Args[" + l + "]);");
                } else {
                    pw.println("\t\t\tprintf(\"" + (String)generatedArgs.get(l) + " = %s, \", Args[" + l + "]);");
                }
                ++l;
            }
            if (analysis.equalsIgnoreCase("NP") || analysis.equalsIgnoreCase("Both") && !TjtInstanceJob.getSecondCall()) {
                while (!line.contains("/*Progress evaluation*/") && line != null) {
                    pw.println(line);
                    line = br.readLine();
                }
                if (line != null) {
                    pw.println();
                }
                pw.println("\t\tif");
                pw.println("\t\t:: (pro == 1) ->");
                pw.println("progress:\t\t\tpro=0");
                pw.println("\t\t:: else ->");
                pw.println("\t\t skip");
                pw.println("\t\tfi");
            }
            line = br.readLine();
            while (line != null) {
                pw.println(line);
                line = br.readLine();
            }
            if (analysis.equalsIgnoreCase("Both")) {
                TjtInstanceJob.setSecondCall(true);
            }
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void calculateNumberOfExecutions(Document document) {
        NodeList argList = document.getElementsByTagName("argument");
        int i = 0;
        while (i < argList.getLength()) {
            Node nt;
            NodeList valores;
            boolean hasRange = false;
            Node v = argList.item(i);
            NamedNodeMap nm = v.getAttributes();
            Node range_arg = nm.getNamedItem("range");
            if (range_arg != null && range_arg.getNodeValue().toString().equals("true")) {
                hasRange = true;
            }
            if (hasRange) {
                valores = v.getChildNodes();
                nt = valores.item(0);
                String ran = nt.getNodeValue().toString();
                int h = 0;
                int startRange = 0;
                int endRange = 0;
                if (ran.contains("..")) {
                    h = ran.indexOf("..");
                    startRange = Integer.parseInt(ran.substring(0, h));
                    endRange = Integer.parseInt(ran.substring(h + 2, ran.length()));
                    if (endRange < startRange) {
                        startRange = 0;
                        endRange = 1;
                    }
                }
                int numComb = endRange - startRange + 1;
                numberOfExecutions *= numComb;
            } else {
                valores = v.getChildNodes();
                nt = valores.item(0);
                String[] argValues = nt.getNodeValue().toString().split(", ");
                int maxArgs = argValues.length;
                numberOfExecutions *= maxArgs;
            }
            ++i;
        }
        NodeList listNumber = document.getElementsByTagName("repeat");
        int auxNum = 1;
        int num = 1;
        if (listNumber.getLength() > 0) {
            Node g = listNumber.item(0);
            NamedNodeMap nm = g.getAttributes();
            Node atrib = nm.getNamedItem("times");
            try {
                num = Integer.parseInt(atrib.getNodeValue().toString());
            }
            catch (NumberFormatException numberFormatException) {
                num = 1;
                MessageDialog.openWarning((Shell)new Shell(), (String)"\"Repeat\" parameter error", (String)"It must be a number.");
            }
            auxNum = num;
            if (auxNum == 0) {
                auxNum = 1;
            }
            numberOfExecutions *= auxNum;
        }
    }

    private static String convertoToCType(String string) {
        if (string.equals("int")) {
            return "int";
        }
        if (string.equals("double")) {
            return "double";
        }
        if (string.equals("float")) {
            return "float";
        }
        if (string.equals("short")) {
            return "int";
        }
        if (string.equals("long")) {
            return "int";
        }
        if (string.equals("String")) {
            return "char *";
        }
        if (string.equals("char")) {
            return "char";
        }
        if (string.equals("boolean")) {
            return "int";
        }
        if (string.equals("Object")) {
            return "int";
        }
        return "int";
    }

    private String prepareExpression(String strData) {
        StringTokenizer tokens = new StringTokenizer(strData, ",&|()<>[]\" ", true);
        StringBuffer sb = new StringBuffer();
        String prev = "";
        while (tokens.hasMoreTokens()) {
            String str = tokens.nextToken();
            if (str.equals("location") || str.equals("method")) {
                if (analysis.equals("LTL")) {
                    sb.append(str);
                } else {
                    sb.append("now." + str);
                }
            } else if (str.contains(".") && !prev.equals("\"")) {
                if (analysis.equals("LTL")) {
                    sb.append(str.replace(".", "_"));
                } else {
                    sb.append("now." + str.replace(".", "_"));
                }
            } else {
                sb.append(str);
            }
            prev = str;
        }
        return sb.toString();
    }

    private String indexExpression(int k, String expr) {
        StringTokenizer tokens = new StringTokenizer(expr, ".,&|()<>[]=\" ", true);
        StringBuffer sb = new StringBuffer();
        String prev = "";
        boolean found = false;
        while (tokens.hasMoreTokens() && !found) {
            String str = tokens.nextToken();
            if (str.contains("_") && !prev.equals("\"")) {
                sb.append(String.valueOf(str.substring(0, str.length() - 1)) + k);
            } else {
                sb.append(str);
            }
            prev = str;
        }
        return sb.toString();
    }

    private static String typeToPrint(String string) {
        if (string.equals("int")) {
            return "%d";
        }
        if (string.equals("double")) {
            return "%lf";
        }
        if (string.equals("float")) {
            return "%f";
        }
        if (string.equals("long")) {
            return "%d";
        }
        if (string.equals("String")) {
            return "%s";
        }
        if (string.equals("char *")) {
            return "%s";
        }
        if (string.equals("char")) {
            return "%c";
        }
        if (string.equals("boolean")) {
            return "%d";
        }
        if (string.equals("Object")) {
            return "%d";
        }
        return "%d";
    }

    private boolean isWindows() {
        return System.getProperty("os.name").contains("Win");
    }
}

