/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.traces;

import es.uma.gisum.tjtplugin.traces.ITreeNode;
import es.uma.gisum.tjtplugin.traces.TraceLocation;
import es.uma.gisum.tjtplugin.traces.TracesProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TraceFile
implements ITreeNode {
    private static final Pattern TRACE_LINE = Pattern.compile("^(.+):(\\d+) -");
    private TracesProject project;
    private File file;
    private List<TraceLocation> locations;
    private boolean parsed;

    public TraceFile(File file) {
        this.file = file;
        this.locations = new LinkedList<TraceLocation>();
    }

    public TracesProject getProject() {
        return this.project;
    }

    public void setProject(TracesProject project) {
        this.project = project;
    }

    public File getFile() {
        return this.file;
    }

    public List<TraceLocation> getTraceLocations() {
        return this.locations;
    }

    @Override
    public ITreeNode getParent() {
        return this.project;
    }

    @Override
    public boolean hasChildren() {
        return !this.parsed || !this.locations.isEmpty();
    }

    @Override
    public ITreeNode[] getChildren() {
        if (!this.parsed) {
            try {
                this.parse();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.locations.toArray(new ITreeNode[this.locations.size()]);
    }

    public void parse() throws IOException {
        this.locations.clear();
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = TRACE_LINE.matcher(line);
            if (matcher.find()) {
                String className = matcher.group(1);
                int lineNumber = Integer.parseInt(matcher.group(2));
                TraceLocation location = new TraceLocation(this, className, lineNumber);
                this.locations.add(location);
            }
            line = reader.readLine();
        }
        this.parsed = true;
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TraceFile && this.file.equals(((TraceFile)obj).file);
    }

    public String toString() {
        return this.file.getName();
    }
}

