/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.traces;

import es.uma.gisum.tjtplugin.traces.ITreeNode;
import es.uma.gisum.tjtplugin.traces.TraceFile;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;

public class TracesProject
implements ITreeNode {
    private ITreeNode parent;
    private IJavaProject project;
    private List<TraceFile> traceFiles;

    public TracesProject(IJavaProject project) {
        this.project = project;
        this.traceFiles = new LinkedList<TraceFile>();
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    public void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public List<TraceFile> getTraceFiles() {
        return this.traceFiles;
    }

    public void addTraceFile(TraceFile child) {
        this.traceFiles.add(child);
        child.setProject(this);
    }

    public void removeTraceFile(TraceFile child) {
        this.traceFiles.remove(child);
        child.setProject(null);
    }

    public void clearTraceFiles() {
        this.traceFiles.clear();
    }

    @Override
    public boolean hasChildren() {
        return !this.traceFiles.isEmpty();
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.traceFiles.toArray(new ITreeNode[this.traceFiles.size()]);
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TracesProject && this.project.equals(((TracesProject)obj).project);
    }

    public String toString() {
        return this.project.getProject().getName();
    }
}

