/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.traces;

import es.uma.gisum.tjtplugin.traces.ITreeNode;
import es.uma.gisum.tjtplugin.traces.TraceFile;
import es.uma.gisum.tjtplugin.traces.TracesProject;
import es.uma.gisum.tjtplugin.traces.TracesProviderListener;
import es.uma.gisum.tjtplugin.traces.TracesRoot;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;

public class TracesProvider {
    private static final TracesProvider singleton = new TracesProvider();
    private static final String TRACE_FILE_EXTENSION = ".tjttrace";
    private Set<TracesProviderListener> listeners;
    private TracesRoot root = new TracesRoot();

    public static final TracesProvider getInstance() {
        return singleton;
    }

    public TracesProvider() {
        this.listeners = new HashSet<TracesProviderListener>();
    }

    public TracesRoot getRoot() {
        return this.root;
    }

    public void clearTraces() {
        ITreeNode[] iTreeNodeArray = this.root.getChildren();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode project = iTreeNodeArray[n2];
            if (project instanceof TracesProject) {
                ((TracesProject)project).clearTraceFiles();
            }
            ++n2;
        }
    }

    public void addTraceFile(File file, IJavaProject project) throws IOException {
        TracesProject tracesProject = this.findProject(project);
        if (tracesProject != null) {
            tracesProject.addTraceFile(new TraceFile(file));
            this.notifyTracesChanged();
        }
    }

    public Collection<File> findTraceFiles(String root, boolean recursive) {
        return this.findTraceFiles(new File(root), recursive);
    }

    public Collection<File> findTraceFiles(File root, boolean recursive) {
        LinkedList<File> traceFiles = new LinkedList<File>();
        if (root.isDirectory()) {
            File[] files;
            File[] fileArray = files = root.listFiles(new TraceFileFilter(recursive));
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    traceFiles.add(file);
                } else if (file.isDirectory()) {
                    traceFiles.addAll(this.findTraceFiles(file, recursive));
                }
                ++n2;
            }
        }
        return traceFiles;
    }

    public void findAndSetTraceFiles(IJavaProject project) throws IOException {
        File projectRoot = project.getProject().getLocation().toFile();
        Collection<File> traceFiles = this.findTraceFiles(projectRoot, true);
        TracesProject tracesProject = this.findProject(project);
        if (tracesProject == null) {
            tracesProject = new TracesProject(project);
            this.getRoot().addProject(tracesProject);
        } else {
            tracesProject.clearTraceFiles();
        }
        for (File traceFile : traceFiles) {
            this.addTraceFile(traceFile, project);
        }
    }

    public TracesProject findProject(IJavaProject project) {
        TracesProject tracesProject = null;
        ITreeNode[] iTreeNodeArray = this.root.getChildren();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode child = iTreeNodeArray[n2];
            if (child instanceof TracesProject && ((TracesProject)child).getProject().equals(project)) {
                tracesProject = (TracesProject)child;
                break;
            }
            ++n2;
        }
        return tracesProject;
    }

    public TracesProject findProject(String projectName) {
        TracesProject tracesProject = null;
        ITreeNode[] iTreeNodeArray = this.root.getChildren();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode child = iTreeNodeArray[n2];
            if (child instanceof TracesProject && ((TracesProject)child).getProject().getProject().getName().equals(projectName)) {
                tracesProject = (TracesProject)child;
                break;
            }
            ++n2;
        }
        return tracesProject;
    }

    public void removeProject(IJavaProject project) {
        TracesProject tracesProject = this.findProject(project);
        if (tracesProject != null) {
            this.root.removeProject(tracesProject);
            this.notifyTracesChanged();
        }
    }

    public void removeProject(String projectName) {
        TracesProject tracesProject = this.findProject(projectName);
        if (tracesProject != null) {
            this.root.removeProject(tracesProject);
            this.notifyTracesChanged();
        }
    }

    public void addListener(TracesProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TracesProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyTracesChanged() {
        for (TracesProviderListener listener : this.listeners) {
            listener.tracesChanged(this);
        }
    }

    private static class TraceFileFilter
    implements FileFilter {
        private boolean acceptDirectories;

        public TraceFileFilter(boolean acceptDirectories) {
            this.acceptDirectories = acceptDirectories;
        }

        @Override
        public boolean accept(File file) {
            return this.acceptDirectories && file.isDirectory() || file.getName().endsWith(TracesProvider.TRACE_FILE_EXTENSION);
        }
    }
}

