/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.util;

import es.uma.gisum.tjtplugin.model.AnalysisType;
import es.uma.gisum.tjtplugin.model.AndroidType;
import es.uma.gisum.tjtplugin.model.ArgumentListType;
import es.uma.gisum.tjtplugin.model.ArgumentType;
import es.uma.gisum.tjtplugin.model.AssertListType;
import es.uma.gisum.tjtplugin.model.AssertType;
import es.uma.gisum.tjtplugin.model.ClassType;
import es.uma.gisum.tjtplugin.model.LimitType;
import es.uma.gisum.tjtplugin.model.LiteralType;
import es.uma.gisum.tjtplugin.model.LocationListType;
import es.uma.gisum.tjtplugin.model.LocationType;
import es.uma.gisum.tjtplugin.model.MaxThreadsType;
import es.uma.gisum.tjtplugin.model.ObjectFactory;
import es.uma.gisum.tjtplugin.model.ObjectiveType;
import es.uma.gisum.tjtplugin.model.ProgressLocationListType;
import es.uma.gisum.tjtplugin.model.ProgressLocationType;
import es.uma.gisum.tjtplugin.model.ProjectionType;
import es.uma.gisum.tjtplugin.model.PropertyType;
import es.uma.gisum.tjtplugin.model.RepeatType;
import es.uma.gisum.tjtplugin.model.SafeLocationListType;
import es.uma.gisum.tjtplugin.model.SafeLocationType;
import es.uma.gisum.tjtplugin.model.TimerType;
import es.uma.gisum.tjtplugin.model.TjtConfigurationType;
import es.uma.gisum.tjtplugin.model.UpdateType;
import es.uma.gisum.tjtplugin.model.VariableListType;
import es.uma.gisum.tjtplugin.model.VariableType;
import es.uma.gisum.tjtplugin.util.AnalysisPolicy;
import es.uma.gisum.tjtplugin.util.AndroidPolicy;
import es.uma.gisum.tjtplugin.util.ConfigurationEvent;
import es.uma.gisum.tjtplugin.util.ConfigurationListener;
import es.uma.gisum.tjtplugin.util.ObjectivePolicy;
import es.uma.gisum.tjtplugin.util.ProjectionPolicy;
import es.uma.gisum.tjtplugin.util.UpdatePolicy;
import es.uma.gisum.tjtplugin.util.Variable;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import org.eclipse.core.runtime.ListenerList;

public class ConfigurationContainer {
    private static final String JAXB_MODEL_PACKAGE = "es.uma.gisum.tjtplugin.model";
    private TjtConfigurationType configuration;
    private ListenerList listeners;

    public ConfigurationContainer() {
        this(new TjtConfigurationType());
    }

    public ConfigurationContainer(TjtConfigurationType configuration) {
        this.setConfiguration(configuration);
        this.listeners = new ListenerList();
    }

    public TjtConfigurationType getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TjtConfigurationType configuration) {
        this.configuration = configuration;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConfigurationListener(ConfigurationListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setClass(String className) {
        ClassType clazz = this.getClazz();
        if (!className.equals(clazz.getName())) {
            clazz.setName(className);
            this.fireClassChangedEvent();
        }
    }

    public void setProperty(String ltl) {
        PropertyType property = this.getProperty();
        if (!ltl.equals(property.getLtl())) {
            property.setLtl(ltl);
            this.firePropertyChangedEvent();
        }
    }

    public void setUpdate(UpdatePolicy updatePolicy) {
        UpdateType update = this.getUpdate();
        if (!updatePolicy.getName().equals(update.getDegree())) {
            update.setDegree(updatePolicy.getName());
            this.fireUpdateChangedEvent();
        }
    }

    public void setObjective(ObjectivePolicy objectivePolicy) {
        ObjectiveType objective = this.getObjective();
        if (!objectivePolicy.getName().equals(objective.getType())) {
            objective.setType(objectivePolicy.getName());
            this.fireObjectiveChangedEvent();
        }
    }

    public void setProjection(ProjectionPolicy projectionPolicy) {
        ProjectionType projection = this.getProjection();
        if (!projectionPolicy.getName().equals(projection.getType())) {
            projection.setType(projectionPolicy.getName());
            this.fireProjectionChangedEvent();
        }
    }

    public void setAnalysis(AnalysisPolicy counterPolicy) {
        AnalysisType anl = this.getAnalysis();
        if (!counterPolicy.getName().equals(anl.getOption())) {
            anl.setOption(counterPolicy.getName());
            this.fireAnalysisChangedEvent();
        }
    }

    public void setAndroid(AndroidPolicy android) {
        AndroidType anl = this.getAndroid();
        if (!android.getName().equals(anl.getAndroid())) {
            anl.setAndroid(android.getName());
            this.fireAndroidChangedEvent();
        }
    }

    public void setRepeat(int times) {
        RepeatType repeat = this.getRepeat();
        if (repeat.getTimes() == null || repeat.getTimes() != times) {
            repeat.setTimes(times);
            this.fireRepeatChangedEvent();
        }
    }

    public void setCounterLimit(int times) {
        LimitType limit = this.getCounterLimit();
        if (limit.getCounterLimit() == null || limit.getCounterLimit() != times) {
            limit.setCounterLimit(times);
            this.fireCounterLimitChangedEvent();
        }
    }

    public void setTimer(int time) {
        TimerType timer = this.getTimer();
        if (timer.getTimer() == null || timer.getTimer() != time) {
            timer.setTimer(time);
            this.fireTimerChangedEvent();
        }
    }

    public void setMaxThreads(int maxThreads) {
        MaxThreadsType mt = this.getMaxThreads();
        if (mt.getMaxThreads() == null || mt.getMaxThreads() != maxThreads) {
            mt.setMaxThreads(maxThreads);
            this.fireMaxThreadsChangedEvent();
        }
    }

    public void addLiteral(LiteralType literal) {
        List<LiteralType> literals = this.configuration.getLiteral();
        boolean added = literals.add(literal);
        if (added) {
            this.fireLiteralsChangedEvent();
        }
    }

    public void removeLiteral(LiteralType literal) {
        boolean removed = this.configuration.getLiteral().remove(literal);
        if (removed) {
            this.fireLiteralsChangedEvent();
        }
    }

    public void removeLiteral(int index) {
        this.configuration.getLiteral().remove(index);
        this.fireLiteralsChangedEvent();
    }

    public void literalsChanged() {
        this.fireLiteralsChangedEvent();
    }

    public void addVariable(Variable variable) {
        Iterator<VariableType> it = this.findVariable(variable);
        if (it == null) {
            VariableType variableType = variable.toVariableType();
            this.getVariables().add(variableType);
            this.fireVariablesChangedEvent();
        }
    }

    public void updateVariable(Variable variable) {
        Iterator<VariableType> it = this.findVariable(variable);
        if (it != null) {
            it.remove();
            VariableType variableType = variable.toVariableType();
            this.getVariables().add(variableType);
            this.fireVariablesChangedEvent();
        }
    }

    public void removeVariable(Variable variable) {
        Iterator<VariableType> it = this.findVariable(variable);
        if (it != null) {
            it.remove();
            this.fireVariablesChangedEvent();
        }
    }

    public void addLocation(LocationType location) {
        List<LocationType> locations = this.getLocations();
        boolean added = locations.add(location);
        if (added) {
            this.fireLocationsChangedEvent();
        }
    }

    public void removeLocation(LocationType location) {
        boolean removed = this.getLocations().remove(location);
        if (removed) {
            this.fireLocationsChangedEvent();
        }
    }

    public void addSafeLocation(SafeLocationType location) {
        List<SafeLocationType> locations = this.getSafeLocations();
        boolean added = locations.add(location);
        if (added) {
            this.fireSafeLocationsChangedEvent();
        }
    }

    public void removeSafeLocation(SafeLocationType location) {
        boolean removed = this.getSafeLocations().remove(location);
        if (removed) {
            this.fireSafeLocationsChangedEvent();
        }
    }

    public void addProgressLocation(ProgressLocationType location) {
        List<ProgressLocationType> locations = this.getProgressLocations();
        boolean added = locations.add(location);
        if (added) {
            this.fireProgressLocationsChangedEvent();
        }
    }

    public void addAssert(AssertType assert_) {
        List<AssertType> asserts = this.getAsserts();
        boolean added = asserts.add(assert_);
        if (added) {
            this.fireAssertsChangedEvent();
        }
    }

    public void removeProgressLocation(ProgressLocationType location) {
        boolean removed = this.getProgressLocations().remove(location);
        if (removed) {
            this.fireProgressLocationsChangedEvent();
        }
    }

    public void removeAssert(AssertType assert_) {
        boolean removed = this.getAsserts().remove(assert_);
        if (removed) {
            this.fireAssertsChangedEvent();
        }
    }

    public void addArgument(ArgumentType argument) {
        List<ArgumentType> arguments = this.getArguments();
        boolean added = arguments.add(argument);
        if (added) {
            this.fireArgumentsChangedEvent();
        }
    }

    public void removeArgument(ArgumentType argument) {
        boolean removed = this.getArguments().remove(argument);
        if (removed) {
            this.fireArgumentsChangedEvent();
        }
    }

    public void argumentsChanged() {
        this.fireArgumentsChangedEvent();
    }

    public void locationsChanged() {
        this.fireLocationsChangedEvent();
    }

    public void safeLocationsChanged() {
        this.fireSafeLocationsChangedEvent();
    }

    public void progressLocationsChanged() {
        this.fireProgressLocationsChangedEvent();
    }

    public void assertsChanged() {
        this.fireAssertsChangedEvent();
    }

    public void toXML(Writer writer) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_MODEL_PACKAGE);
        Marshaller marshaller = jaxbContext.createMarshaller();
        ObjectFactory factory = new ObjectFactory();
        JAXBElement<TjtConfigurationType> configurationElement = factory.createTjtConfiguration(this.configuration);
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(configurationElement, writer);
    }

    public void fromXML(Reader reader) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_MODEL_PACKAGE);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new ConfigurationValidationEventHandler());
        JAXBElement configurationElement = (JAXBElement)unmarshaller.unmarshal(reader);
        this.configuration = (TjtConfigurationType)configurationElement.getValue();
    }

    private ClassType getClazz() {
        ClassType clazz = this.configuration.getClazz();
        if (clazz == null) {
            clazz = new ClassType();
            this.configuration.setClazz(clazz);
        }
        return clazz;
    }

    private PropertyType getProperty() {
        PropertyType property = this.configuration.getProperty();
        if (property == null) {
            property = new PropertyType();
            this.configuration.setProperty(property);
        }
        return property;
    }

    private UpdateType getUpdate() {
        UpdateType update = this.configuration.getUpdate();
        if (update == null) {
            update = new UpdateType();
            this.configuration.setUpdate(update);
        }
        return update;
    }

    private ObjectiveType getObjective() {
        ObjectiveType objective = this.configuration.getObjective();
        if (objective == null) {
            objective = new ObjectiveType();
            this.configuration.setObjective(objective);
        }
        return objective;
    }

    private ProjectionType getProjection() {
        ProjectionType projection = this.configuration.getProjection();
        if (projection == null) {
            projection = new ProjectionType();
            this.configuration.setProjection(projection);
        }
        return projection;
    }

    private AndroidType getAndroid() {
        AndroidType android = this.configuration.getAndroid();
        if (android == null) {
            android = new AndroidType();
            this.configuration.setAndroid(android);
        }
        return android;
    }

    private AnalysisType getAnalysis() {
        AnalysisType anl = this.configuration.getAnalysis();
        if (anl == null) {
            anl = new AnalysisType();
            this.configuration.setAnalysis(anl);
        }
        return anl;
    }

    private RepeatType getRepeat() {
        RepeatType repeat = this.configuration.getRepeat();
        if (repeat == null) {
            repeat = new RepeatType();
            this.configuration.setRepeat(repeat);
        }
        return repeat;
    }

    private TimerType getTimer() {
        TimerType timer = this.configuration.getTimer();
        if (timer == null) {
            timer = new TimerType();
            this.configuration.setTimer(timer);
        }
        return timer;
    }

    private LimitType getCounterLimit() {
        LimitType counterLimit = this.configuration.getLimit();
        if (counterLimit == null) {
            counterLimit = new LimitType();
            this.configuration.setLimit(counterLimit);
        }
        return counterLimit;
    }

    private MaxThreadsType getMaxThreads() {
        MaxThreadsType mt = this.configuration.getMaxThreads();
        if (mt == null) {
            mt = new MaxThreadsType();
            this.configuration.setMaxThreads(mt);
        }
        return mt;
    }

    private Iterator<LiteralType> findLiteral(LiteralType literal) {
        List<LiteralType> literals = this.configuration.getLiteral();
        Iterator<LiteralType> it = literals.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            LiteralType literalType = it.next();
            if (!literalType.getName().equals(literal.getName())) continue;
            found = true;
        }
        return found ? it : null;
    }

    public List<VariableType> getVariables() {
        VariableListType variableList = this.configuration.getVariableList();
        if (variableList == null) {
            variableList = new VariableListType();
            this.configuration.setVariableList(variableList);
        }
        return variableList.getVariable();
    }

    private Iterator<VariableType> findVariable(Variable variable) {
        List<VariableType> variables = this.getVariables();
        Iterator<VariableType> it = variables.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            VariableType variableType = it.next();
            if (!variableType.getName().equals(variable.getFullName())) continue;
            found = true;
        }
        return found ? it : null;
    }

    public List<ArgumentType> getArguments() {
        ArgumentListType argumentList = this.configuration.getArgumentList();
        if (argumentList == null) {
            argumentList = new ArgumentListType();
            this.configuration.setArgumentList(argumentList);
        }
        List<ArgumentType> arguments = argumentList.getArgument();
        return arguments;
    }

    private Iterator<ArgumentType> findArgument(ArgumentType argument) {
        List<ArgumentType> arguments = this.getArguments();
        Iterator<ArgumentType> it = arguments.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            ArgumentType argumentType = it.next();
            if (!argumentType.getName().equals(argument.getName()) || argument.isRange() != argument.isRange()) continue;
            found = true;
        }
        return found ? it : null;
    }

    public List<LocationType> getLocations() {
        LocationListType locationList = this.configuration.getLocationList();
        if (locationList == null) {
            locationList = new LocationListType();
            this.configuration.setLocationList(locationList);
        }
        List<LocationType> locations = locationList.getLocation();
        return locations;
    }

    public List<SafeLocationType> getSafeLocations() {
        SafeLocationListType locationList = this.configuration.getSafeLocationList();
        if (locationList == null) {
            locationList = new SafeLocationListType();
            this.configuration.setSafeLocationList(locationList);
        }
        List<SafeLocationType> locations = locationList.getSafeLocation();
        return locations;
    }

    public List<ProgressLocationType> getProgressLocations() {
        ProgressLocationListType locationList = this.configuration.getProgressLocationList();
        if (locationList == null) {
            locationList = new ProgressLocationListType();
            this.configuration.setProgressLocationList(locationList);
        }
        List<ProgressLocationType> locations = locationList.getProgressLocation();
        return locations;
    }

    public List<AssertType> getAsserts() {
        AssertListType asserts = this.configuration.getAssertList();
        if (asserts == null) {
            asserts = new AssertListType();
            this.configuration.setAssertList(asserts);
        }
        List<AssertType> assert_ = asserts.getAssert();
        return assert_;
    }

    private void fireClassChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).classChanged(event);
            ++n2;
        }
    }

    private void firePropertyChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).propertyChanged(event);
            ++n2;
        }
    }

    private void fireUpdateChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).updateChanged(event);
            ++n2;
        }
    }

    private void fireObjectiveChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).objectiveChanged(event);
            ++n2;
        }
    }

    private void fireProjectionChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).projectionChanged(event);
            ++n2;
        }
    }

    private void fireAnalysisChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).analysisChanged(event);
            ++n2;
        }
    }

    private void fireAndroidChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).androidChanged(event);
            ++n2;
        }
    }

    private void fireRepeatChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).repeatChanged(event);
            ++n2;
        }
    }

    private void fireCounterLimitChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).counterLimitChanged(event);
            ++n2;
        }
    }

    private void fireTimerChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).timerChanged(event);
            ++n2;
        }
    }

    private void fireMaxThreadsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).maxThreadsChanged(event);
            ++n2;
        }
    }

    private void fireLiteralsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).literalsChanged(event);
            ++n2;
        }
    }

    public void fireVariablesChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).variablesChanged(event);
            ++n2;
        }
    }

    private void fireArgumentsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).argumentsChanged(event);
            ++n2;
        }
    }

    private void fireAssertsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).assertsChanged(event);
            ++n2;
        }
    }

    private void fireLocationsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).locationsChanged(event);
            ++n2;
        }
    }

    private void fireSafeLocationsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).safeLocationsChanged(event);
            ++n2;
        }
    }

    private void fireProgressLocationsChangedEvent() {
        ConfigurationEvent event = new ConfigurationEvent(this);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ConfigurationListener)listener).progressLocationsChanged(event);
            ++n2;
        }
    }

    private class ConfigurationValidationEventHandler
    implements ValidationEventHandler {
        private ConfigurationValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent event) {
            if (event.getSeverity() == 2 || event.getSeverity() == 1) {
                ValidationEventLocator locator = event.getLocator();
                System.err.println("Invalid document: " + locator.getURL());
                System.err.println("Error: " + event.getMessage());
                System.err.println("Error at column " + locator.getColumnNumber() + ", line " + locator.getLineNumber());
            }
            return true;
        }
    }
}

