/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.util;

import es.uma.gisum.tjtplugin.util.Variable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaParser {
    public static List<Variable> getVariables(IProject project) throws CoreException {
        LinkedList<Variable> variables = new LinkedList<Variable>();
        if (project != null && project.isNatureEnabled("org.eclipse.jdt.core.javanature")) {
            IPackageFragment[] packages;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IPackageFragment[] iPackageFragmentArray = packages = javaProject.getPackageFragments();
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment aPackage = iPackageFragmentArray[n2];
                List<Variable> packageVariables = JavaParser.getVariables(aPackage);
                if (packageVariables != null) {
                    variables.addAll(packageVariables);
                }
                ++n2;
            }
        }
        return variables;
    }

    public static List<Variable> getVariables(IPackageFragment aPackage) throws JavaModelException {
        LinkedList<Variable> variables = new LinkedList<Variable>();
        if (aPackage.getKind() == 1) {
            ICompilationUnit[] compilationUnits;
            ICompilationUnit[] iCompilationUnitArray = compilationUnits = aPackage.getCompilationUnits();
            int n = compilationUnits.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit compilationUnit = iCompilationUnitArray[n2];
                List<Variable> moreVariables = JavaParser.getVariables(compilationUnit);
                if (moreVariables != null) {
                    variables.addAll(moreVariables);
                }
                ++n2;
            }
        }
        return variables;
    }

    public static List<Variable> getVariables(ICompilationUnit compilationUnit) throws JavaModelException {
        LinkedList<Variable> variables = new LinkedList<Variable>();
        IType[] iTypeArray = compilationUnit.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            String className = type.getFullyQualifiedName();
            IField[] iFieldArray = type.getFields();
            int n3 = iFieldArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IField field = iFieldArray[n4];
                String variableName = field.getElementName();
                String typeName = Signature.getSignatureSimpleName((String)field.getTypeSignature());
                Variable variable = new Variable(className, typeName, variableName);
                variables.add(variable);
                ++n4;
            }
            ++n2;
        }
        return variables;
    }
}

