/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenEditorAction
extends Action {
    private ViewPart viewPart;
    private IJavaProject project;
    private String className;
    private int lineNumber;

    public OpenEditorAction(IJavaProject project, ViewPart viewPart, String className, int lineNumber) {
        super("Show in editor");
        this.project = project;
        this.viewPart = viewPart;
        this.className = className;
        this.lineNumber = lineNumber;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IType element = this.project.findType(this.className);
            if (element != null) {
                IWorkbenchPage page = this.viewPart.getSite().getWorkbenchWindow().getActivePage();
                IResource resource = element.getCompilationUnit().getCorrespondingResource();
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    textEditor = (ITextEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                }
            }
        }
        catch (CoreException coreException) {}
        if (textEditor == null) {
            this.showErrorMessage("Couldn't open" + this.className);
        } else {
            this.reveal(textEditor);
        }
    }

    public boolean isEnabled() {
        try {
            return this.project.findType(this.className) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void reveal(ITextEditor textEditor) {
        if (this.lineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.lineNumber - 1), document.getLineLength(this.lineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void showErrorMessage(String message) {
        MessageDialog.openError((Shell)this.viewPart.getSite().getShell(), (String)"Error", (String)message);
    }
}

