/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.util;

import es.uma.gisum.tjtplugin.model.VariableType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Variable {
    private String className;
    private String type;
    private String name;
    private boolean tracked;
    private boolean asObject;
    private String maxObjects;
    private static Set<String> KNOWN_TYPES = new HashSet<String>(Arrays.asList("boolean", "char", "short", "int", "long", "float", "double", "String", "Object"));
    private static Pattern namePattern = Pattern.compile("^((.*)\\.)?([^\\.]+)$");

    public Variable() {
    }

    public Variable(String className, String type, String name) {
        this.setClassName(className);
        this.setType(type);
        this.setName(name);
        this.setAsObject(false);
        this.setMaxObjects(" ");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAsObject(boolean name) {
        this.asObject = name;
    }

    public void setMaxObjects(String name) {
        this.maxObjects = name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTracked() {
        return this.tracked;
    }

    public boolean isAsObject() {
        return this.asObject;
    }

    public String getMaxObjects() {
        return this.maxObjects;
    }

    public void setTracked(boolean tracked) {
        this.tracked = tracked;
    }

    public String getFullName() {
        return String.valueOf(this.className) + "." + this.name;
    }

    public VariableType toVariableType() {
        VariableType variableType = new VariableType();
        variableType.setName(this.getFullName());
        variableType.setType(Variable.normalizeType(this.getType()));
        variableType.setAsObject(this.asObject);
        variableType.setMaxObjects(this.maxObjects);
        return variableType;
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Variable) {
            Variable variable = (Variable)obj;
            equals = this.name.equals(variable.name) && this.className.equals(variable.className) && this.type.equals(variable.type);
        }
        return equals;
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.getFullName();
    }

    public static String normalizeType(String type) {
        String normalized = null;
        normalized = KNOWN_TYPES.contains(type) ? type : "Object";
        return normalized;
    }

    public static Variable fromVariableType(VariableType variableType) {
        String[] name = Variable.splitVariableName(variableType.getName());
        if (name == null) {
            throw new IllegalArgumentException("Name not recognized");
        }
        Variable variable = new Variable();
        variable.setName(name[0]);
        variable.setType(variable.getType());
        variable.setClassName(name[1]);
        variable.setAsObject(variable.isAsObject());
        variable.setMaxObjects(variable.getMaxObjects());
        return variable;
    }

    private static String[] splitVariableName(String fullName) {
        Matcher matcher = namePattern.matcher(fullName);
        String[] splitName = null;
        if (matcher.matches()) {
            splitName = new String[]{matcher.group(2), matcher.group(3)};
        }
        return splitName;
    }
}

