/*
 * Decompiled with CFR 0.152.
 */
package es.uma.gisum.tjtplugin.views;

import es.uma.gisum.tjtplugin.traces.ITreeNode;
import es.uma.gisum.tjtplugin.traces.TraceFile;
import es.uma.gisum.tjtplugin.traces.TraceLocation;
import es.uma.gisum.tjtplugin.traces.TracesProject;
import es.uma.gisum.tjtplugin.traces.TracesProvider;
import es.uma.gisum.tjtplugin.traces.TracesProviderListener;
import es.uma.gisum.tjtplugin.util.OpenEditorAction;
import es.uma.gisum.tjtplugin.views.TracesTreeContentProvider;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class TracesView
extends ViewPart {
    public static final String ID = "es.uma.gisum.tjtplugin.views.TracesView";
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action actionRescan;
    private Action actionRefresh;
    private Action singleClickAction;
    private TracesProvider tracesProvider = TracesProvider.getInstance();

    public TracesView() {
        this.tracesProvider.addListener(new TracesProviderListener(){

            @Override
            public void tracesChanged(TracesProvider provider) {
                TracesView.this.viewer.setInput((Object)provider.getRoot());
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new TracesTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new TraceSorter());
        this.viewer.setInput((Object)this.tracesProvider.getRoot());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "es.uma.gisum.tjtplugin.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.hookSingleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TracesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRescan);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.actionRescan = new RescanAction();
        this.actionRefresh = new RefreshAction();
        this.singleClickAction = new OpenLocationAction();
    }

    private void hookSingleClickAction() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TracesView.this.singleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private final class OpenLocationAction
    extends Action {
        private OpenLocationAction() {
        }

        public void run() {
            ISelection selection = TracesView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof TraceLocation) {
                TraceLocation location = (TraceLocation)obj;
                String className = location.getShortClassName();
                int line = location.getLine();
                IJavaProject project = location.getTraceFile().getProject().getProject();
                OpenEditorAction action = new OpenEditorAction(project, TracesView.this, className, line);
                action.run();
            }
        }
    }

    private final class RefreshAction
    extends Action {
        public RefreshAction() {
            this.setText("Refresh");
            this.setToolTipText("Refresh traces of selected resource");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        }

        public void run() {
            ISelection selection = TracesView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            TracesProvider tracesProvider = TracesProvider.getInstance();
            try {
                if (obj instanceof TracesProject) {
                    TracesProject tracesProject = (TracesProject)obj;
                    tracesProvider.findAndSetTraceFiles(tracesProject.getProject());
                } else if (obj instanceof TraceFile) {
                    TraceFile traceFile = (TraceFile)obj;
                    traceFile.parse();
                    tracesProvider.notifyTracesChanged();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isEnabled() {
            ISelection selection = TracesView.this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            return obj instanceof TracesProject || obj instanceof TraceFile;
        }
    }

    private final class RescanAction
    extends Action {
        public RescanAction() {
            this.setText("Rescan");
            this.setToolTipText("Rescan workspace for trace files");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
        }

        public void run() {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            TracesProvider tracesProvider = TracesProvider.getInstance();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                        tracesProvider.findAndSetTraceFiles(jProject);
                    } else {
                        tracesProvider.removeProject(project.getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    class TraceSorter
    extends ViewerSorter {
        TraceSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TraceLocation && e1 instanceof TraceLocation) {
                TraceFile traceFile = (TraceFile)((TraceLocation)e1).getParent();
                int index1 = traceFile.getTraceLocations().indexOf(e1);
                int index2 = traceFile.getTraceLocations().indexOf(e2);
                return index1 - index2;
            }
            if (e1 instanceof TraceFile && e2 instanceof TraceFile) {
                int index1 = ((TraceFile)e1).toString().length();
                int index2 = ((TraceFile)e2).toString().length();
                return index1 - index2;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (((ITreeNode)obj).hasChildren()) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

