/*Promela template*/

c_code {
	\#include <time.h>
	\#include <stdlib.h>
	\#include <stdio.h>
	\#include <rpc/types.h>
	\#include <rpc/xdr.h>
	\#include <sys/types.h>
	\#include <sys/socket.h>
	\#include <fcntl.h>
	\#include <netinet/in.h>
	\#include <arpa/inet.h>
	\#include <netdb.h>
	\#include <ctype.h>
	\#include <string.h>
	\#define END_OF_SEQUENCE -1
	\#define END_OF_PROGRAM -2
	\#define EXCEPTION_EVENT -3
	\#define DEADLOCK_EVENT -4
	\#define BREAKPOINT_EVENT -5
	\#define OBJECT_FIELD_EVENT -6
	\#define THREADS_LOCATIONS_EVENT -7
	\#define SAFE_DEADLOCK_EVENT -8
	\#define TIMEOUT_EVENT -9
	\#define SAFE_TIMEOUT_EVENT -10
	\#define PROGRESS_EVENT -11
	\#define JAVA_ASSERT_VIOLATION -12
	\#define LTL_ERROR_EVENT -13
}


/*[c_state]*/
c_state "int count" "Global" "0"
c_state "int progCount" "Global" "0"


c_decl{
	int step=0;
	int startProgram=0;
	int ip=0;
};

c_track "&step" "sizeof(int)" "UnMatched"
c_track "&startProgram" "sizeof(int)" "UnMatched"
c_track "&ip" "sizeof(int)" "UnMatched"

/*[defines]*/
#define guard c_expr{(startProgram==1)}

/*[never_claim]*/



bool running = false;
c_code {



	struct vStep{
		int thid;
		char loc[150];
		char exc[150];
		char met[150];
		int ip;
		int cnt;
		int pc;
		/*java fields required*/
		
		struct vStep *ntx;
	};

	struct vStep *first=NULL;
	struct vStep *last=NULL;

	int pid;
	int pidh;
	int indice=0;
	int sock=0;
	int sock2=0;
	int n_exec=0;
	int javaCounter=0;
	int fileNumber=0;
	int endExec=-1;
	int deadlocks=0;
	int safedeadlocks=0;
	int assertViolations=0;
	int timeouts=0;
	int safetimeouts=0;
	int isProgress=0;
	XDR xdrsRead;
   	XDR xdrsWrite;
	char intToStr[20];
   	FILE *fRead;
   	FILE *fWrite;
	struct sockaddr_in server;
	struct sockaddr_in client;

	void initialization(){
		int i=0;
		char c=' ';
		for(i=0;i<150;i++){
			/*initialize*/
			
		}
		for(i=0;i<numberOfExecutions;i++) verdicts[i]=0;
		
		/*link variables*/
		
		
	}

	/*generate arguments*/
		
	void createSocket(){
		//Socket initialization
		int yes=1;
   		sock=socket(AF_INET,SOCK_STREAM,0);
		if (sock < 0) {
                	  perror ("can't create socket");
                	  exit (EXIT_FAILURE);
		}
		bzero(&server, sizeof(server));
   		server.sin_family = AF_INET;
   		server.sin_addr.s_addr = INADDR_ANY;
   		server.sin_port = htons(65000);

		//force reuse
		if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,&yes, sizeof(int)) == -1) {
			perror("setsockopt");
			exit (EXIT_FAILURE);
		}

 		//bind
   		if (bind(sock,(struct  sockaddr *)&server, sizeof(server))==-1){
      			close(sock);
      			perror("can't bind socket");
    			exit (EXIT_FAILURE);
   		}

   		//listen
   		if (listen(sock,1)==-1)
   		{
      			perror("listen\n");
    			exit (EXIT_FAILURE);
   		}
	}

	void connectSocket(){
	     int adrl=sizeof(server);

   	     sock2=accept(sock,(struct  sockaddr *)&client, &adrl);
	     if(sock2==-1){
		perror("accept");
		exit(EXIT_FAILURE);
	     }

             	    fRead=fdopen(sock2,"r");
             	    fWrite=fdopen(sock2,"w+");
                    xdrstdio_create(&xdrsRead, fRead, XDR_DECODE);
                    xdrstdio_create(&xdrsWrite, fWrite, XDR_ENCODE);
	     
   	}


	void launchJava(){

		int reading=0;
		int v=0;
		char * str=(char*)malloc(250*sizeof(char));
		indice=0;
		n_exec=n_exec+1;
	
		printf("\n\n-------EXECUTION %d-------\n",n_exec);
		if(n_exec>1){
			close(sock2);
			//sends new arguments
			connectSocket();

			strcpy(str,"test.jar");
			//reading=strlen(progName);

			for(v=0 ;(v < nArgs) ;v++){
				
				strcat(str," ");
				reading=strlen(str);
				
				strcat(str,Args[v]);
				reading=strlen(str);
				
			}
			reading=strlen(str);
			
			if(!xdr_bytes(&xdrsWrite,&str,&reading,reading)){
				perror("xdr_bytes");
			}
			fflush(fWrite);
			//aqui envio el fileNumber
			if(!xdr_int(&xdrsWrite,&fileNumber)){
				perror("writing int error\n");
				exit (EXIT_FAILURE);
			}
			fflush(fWrite);
			fileNumber=0;

			

			
		}else{
			pid=fork();

			if (pid == -1) {
				// Error creating child process
				perror("fork");
				exit(EXIT_FAILURE);
			}
			if (pid == 0) {//launches JDI with a program configuration to test
				/*edit execlp*/
					perror("execlp");
					exit(EXIT_FAILURE);
					}
			}
			else {	
			    pidh=getpid();	
			}
		}
		free(str);
	}

	
	


	void readValue(int ind){
		int reading=0;
		char *pt;

		if(strcmp((char *)Types[ind],"int")==0){
			if(!xdr_int(&xdrsRead,&(*(int *)Variables[ind]))){
				perror("reading int errorrv\n");
				exit (EXIT_FAILURE);
			}
			
			printf("%s = %d\n",Names[ind],(*(int *)Variables[ind]));
			
		}else if(strcmp((char *)Types[ind],"char")==0){
			if(!xdr_char(&xdrsRead,&*(char *)Variables[ind])){
				perror("reading char error\n");
				exit (EXIT_FAILURE);
			}

		}else if(strcmp((char *)Types[ind],"double")==0){
			if(!xdr_double(&xdrsRead,&*(double *)Variables[ind])){
				perror("reading float error\n");
				exit (EXIT_FAILURE);
			}
		}else if(strcmp((char *)Types[ind],"char *")==0){
			pt=(char*)malloc(50*sizeof(char));
			if(!xdr_bytes(&xdrsRead, &pt, &reading, 50)){
			    perror("reading string! error\n");
			    exit (EXIT_FAILURE);
			 }
			 pt[reading]='\0';
			 /*array of characters assignment*/	
			 free(pt);

		}else if(strcmp((char *)Types[ind],"float")==0){
			if(!xdr_float(&xdrsRead,&*(float *)Variables[ind])){
				perror("reading float error\n");
				exit (EXIT_FAILURE);
			}
		}
	}

	void readObjectValue(int ind){
		int reading=0;
		char *pt;

		if(strcmp((char *)TypesO[ind],"int")==0){
			if(!xdr_int(&xdrsRead,&(*(int *)VariablesO[ind]))){
				perror("reading int errorro\n");
				exit (EXIT_FAILURE);
			} 
			printf("%s = %d\n",NamesO[ind],(*(int *)VariablesO[ind]));
			
		}else if(strcmp((char *)TypesO[ind],"char")==0){
			if(!xdr_char(&xdrsRead,&*(char *)VariablesO[ind])){
				perror("reading char error\n");
				exit (EXIT_FAILURE);
			}

		}else if(strcmp((char *)TypesO[ind],"double")==0){
			if(!xdr_double(&xdrsRead,&*(double *)VariablesO[ind])){
				perror("reading float error\n");
				exit (EXIT_FAILURE);
			}
		}else if(strcmp((char *)TypesO[ind],"char *")==0){
			pt=(char*)malloc(50*sizeof(char));
			if(!xdr_bytes(&xdrsRead, &pt, &reading, 50)){
			    perror("reading string error\n");
			    exit (EXIT_FAILURE);
			 }
			 pt[reading]='\0';
			 /*array of characters assignment at objects*/	
			 free(pt);

		}else if(strcmp((char *)TypesO[ind],"float")==0){
			if(!xdr_float(&xdrsRead,&*(float *)VariablesO[ind])){
				perror("reading float error\n");
				exit (EXIT_FAILURE);
			}
		}
	}


	void readMethod(){
		int reading=0;
		int i=0;
		char c=' ';
		char * ptraux=(char*)malloc(150*sizeof(char));
		if(!xdr_bytes(&xdrsRead, &ptraux, &reading, 150)){
			    perror("reading method error\n");
			    exit (EXIT_FAILURE);
		}
		for(i=0;i<150;i++){
			/*read method*/
			
		free(ptraux);
		
		
	}

	void readLocation(){
		int reading=0;
		int i=0;
		char c=' ';
		char * ptraux=(char*)malloc(150*sizeof(char));
		if(!xdr_bytes(&xdrsRead, &ptraux, &reading, 150)){
			    	perror("reading location error\n");
			    	exit (EXIT_FAILURE);
		}
		
		for(i=0;i<150;i++){
			/*read location*/

		free(ptraux);
		
	}

	void readLocationException(){
		int reading=0;
		int i=0;
		char c=' ';
		char * ptraux=(char*)malloc(150*sizeof(char));
		if(!xdr_bytes(&xdrsRead, &ptraux, &reading, 150)){
			    	perror("reading location exception error\n");
			    	exit (EXIT_FAILURE);
		}
		
		ptraux[reading]='\0';
		for(i=0;i<150;i++){
			/*read location exception*/

		free(ptraux);
		
		
	}

	void readException(){
		int i=0;
		int reading=0;
		char c=' ';
		char * ptraux=(char*)malloc(150*sizeof(char));
		if(!xdr_bytes(&xdrsRead, &ptraux, &reading, 150)){
			    	perror("reading exception error\n");
			    	exit (EXIT_FAILURE);
		}
		
		ptraux[reading]='\0';
		for(i=0;i<150;i++){
			/*read exception*/
		free(ptraux);
		
	}

	void readThreadLocation(int ind){
		int reading=0;
		
		if(!xdr_int(&xdrsRead,&reading)){
			perror("reading thl value error\n");
			exit (EXIT_FAILURE);
		}
		/*thread location*/

	}


	void sendConfirmationToJdi(){
		//send confirmation to JDI
		if(!xdr_int(&xdrsWrite,&fileNumber)){
			perror("writing int error\n");
			exit (EXIT_FAILURE);
		}
		fflush(fWrite);
	}

	void readThreadId(){
		int reading=0;
		if(!xdr_int(&xdrsRead, &reading)){
			perror("reading int errorvarios\n");
			exit (EXIT_FAILURE);
		}
		/*read thid*/
	}

	void readIndex(){
		if(!xdr_int(&xdrsRead,&indice)){
			perror("reading index error\n");
			exit (EXIT_FAILURE);
		}
	}


	void startSimulation() {

		/* Fork and execute*/
		launchJava();

		/* Connect to java-jdi*/
		if(n_exec==1){
			connectSocket();
		}

	}
	
	void clearStrings(){

		/*rest strings*/
	}

	void addNew(){
		struct vStep *newElement;
		newElement=(struct vStep *)malloc(sizeof(struct vStep));
		
		if(isProgress==1){
			newElement->ip=1;
		}else{
			newElement->ip=0;
		}	
		 
		newElement->ntx=NULL;
		newElement->cnt=now.count;
		
		
		if((step+1<=counterLimit) || (isProgress>0)){
			newElement->pc=step+1;
		}else{
			newElement->pc=now.progCount;
		}
		
		
		/*asignations to list fields*/
		

		if(first==NULL){
			first=newElement;
			last=newElement;
		} else{
			last->ntx=newElement;
			last=newElement;
		}		

	}

	void get(int x){

		struct vStep *ptr;
		int i=0;
		
		ptr=first;

		while ((ptr!=NULL)&&(i<x)){
			ptr=ptr->ntx;
			i++;
		}
		if(ptr!=NULL){
			i=x+1;
			printf("\n---------------\n");
			printf("\nGetting state %d\n",i);
			
            		/*get fields and print*/
			printf("Thread id: %d\n", ptr->thid);
			printf("Location: %s\n",ptr->loc);
                    	printf("Method: %s\n",ptr->met);
			now.count=ptr->cnt;
			printf("COUNT= %d\n", now.count);
			ip=ptr->ip;
			printf("pro= %d\n",ip);
			if(ptr->ip) isProgress=1;
			now.progCount=ptr->pc;
			printf("PROGCOUNT= %d\n",now.progCount);
			
		}else{
			//debo devolver el ltimo almacenado si lo hay
			ptr=first;
			if((ptr!=NULL)&&(!isNPS)){
				i=1;
				while (ptr->ntx!=NULL){
					ptr=ptr->ntx;
					i++;
				}
				
			}
			else{
				now.running=0;	
			}
			
			
		}

	}

	void receiveThreadsLocations(){
		//receive threads' locations
		if(!xdr_int(&xdrsRead,&indice)){
			perror("reading index error\n");
			exit (EXIT_FAILURE);
		}
						
		while(indice != -1){
						 	
			if(indice!=-7){
				perror("reading index error\n");
				exit (EXIT_FAILURE);
			}else{
				if(!xdr_int(&xdrsRead,&indice)){
					perror("reading index error\n");
					exit (EXIT_FAILURE);
			 	}
							
				readThreadLocation(indice);
			}
			if(!xdr_int(&xdrsRead,&indice)){
				perror("reading index error\n");
				exit (EXIT_FAILURE);
			 }									
				
		}
		indice=0;

		//add a new node to the structure 
		addNew();

	}


	void freeList()
	{
		struct vStep *aux, *prev;
		prev = first;
		if(first!=NULL){
			aux=first->ntx;
			while(aux!=NULL){
				free(prev);
				prev=aux;
				aux=aux->ntx;
			}

		}
		
		first=NULL;
		last=NULL;
		
	}

	void getNewState(){
		if(indice!=END_OF_PROGRAM){	
			  	     
                                     if(step<javaCounter){//Spin is performing backtracking

					
						get(step);
						step++;
					
			
				     }else if ((step==javaCounter)&&(step!=endExec)){//Continue parallel execution, unless program had finished

					
					printf("\n***************\n");
					printf("step %d , javaCounter %d\n", step+1, javaCounter+1);
					readIndex();

					if(several>0){

						while((indice!=END_OF_SEQUENCE)&&(indice!=END_OF_PROGRAM)&&(indice!=EXCEPTION_EVENT)&&(indice!=DEADLOCK_EVENT)&&(indice!=BREAKPOINT_EVENT)&&(indice!=SAFE_DEADLOCK_EVENT)&&(indice!=SAFE_TIMEOUT_EVENT)&&(indice!=TIMEOUT_EVENT)&&(indice!=PROGRESS_EVENT)&&(indice!=JAVA_ASSERT_VIOLATION)){
						
							if(indice==OBJECT_FIELD_EVENT){
						   		readIndex();
						   		readObjectValue(indice);	
							}else if(indice==THREADS_LOCATIONS_EVENT){
								readIndex();
                                                   		readThreadLocation(indice);
							}else{
                                                   		readValue(indice);
							}
				
							readIndex();
						}

					}else if((indice!=END_OF_SEQUENCE)&&(indice!=END_OF_PROGRAM)&&(indice!=EXCEPTION_EVENT)&&(indice!=DEADLOCK_EVENT)&&(indice!=BREAKPOINT_EVENT)&&(indice!=OBJECT_FIELD_EVENT)&&(indice!=SAFE_DEADLOCK_EVENT)&&(indice!=SAFE_TIMEOUT_EVENT)&&(indice!=TIMEOUT_EVENT)&&(indice!=PROGRESS_EVENT)&&(indice!=JAVA_ASSERT_VIOLATION)){
						
						readValue(indice);
						readThreadId();
						readLocation();	
						readMethod();
						receiveThreadsLocations();
						sendConfirmationToJdi();

					}

					if(indice==END_OF_PROGRAM){//Program finished
						
						if(isNPS){
							now.running=0;
						}
						endExec=javaCounter+1;
						close(sock2);
						verdicts[n_exec-1]=END_OF_PROGRAM;
						printf("end of execution\n");

					}else if(indice==JAVA_ASSERT_VIOLATION){//Java assert is false, so we stop the program and store trace
						
						
						if(isNPS){
							now.running=0;
						}
						endExec=javaCounter+1;
						assertViolations++;
						fileNumber=1;
						close(sock2);
						verdicts[n_exec-1]=JAVA_ASSERT_VIOLATION;
						printf("ASSERT VIOLATION DETECTED IN JAVA\n");
						
					}else if (indice==END_OF_SEQUENCE){//Finish 'as method' mode state

						readThreadId();
						readLocation();
						readMethod();
						//add a new node to the structure 
						addNew();					
						sendConfirmationToJdi();					
						
					
					}else if(indice==EXCEPTION_EVENT){//Exception found

						readException();
						readLocationException();
						receiveThreadsLocations();
						/*catched or uncatched*/
			
						}else{			
							printf("Uncatched\n");
						} 

						sendConfirmationToJdi();
						
							
					}else if(indice==DEADLOCK_EVENT){//Deadlock
						
						now.running=0;
						endExec=javaCounter+1;
						deadlocks++;
						fileNumber=1;
						close(sock2);
						verdicts[n_exec-1]=DEADLOCK_EVENT;
						printf("POSSIBLE DEADLOCK DETECTED\n");
						
					}else if(indice==SAFE_DEADLOCK_EVENT){//Safe blocking location (or inactivity)
						
						now.running=0;
						endExec=javaCounter+1;
						safedeadlocks++;
						close(sock2);
						verdicts[n_exec-1]=SAFE_DEADLOCK_EVENT;
						printf("SAFE DEADLOCK DETECTED\n");
						
					}else if(indice==SAFE_TIMEOUT_EVENT){//Safe inactivity
						
						now.running=0;
						endExec=javaCounter+1;
						safetimeouts++;
						verdicts[n_exec-1]=SAFE_TIMEOUT_EVENT;
						close(sock2);
						printf("SAFE TIMEOUT DETECTED\n");
						
					}else if(indice==TIMEOUT_EVENT){//Not safe inactivity
						
						now.running=0;
						endExec=javaCounter+1;
						timeouts++;
						fileNumber=1;
						close(sock2);
						verdicts[n_exec-1]=TIMEOUT_EVENT;
						printf("TIMEOUT DETECTED\n");
						
					}else if(indice==BREAKPOINT_EVENT){//Only location
						
						readLocation();
						readMethod();
						receiveThreadsLocations();
						sendConfirmationToJdi();
							
					}else if(indice==PROGRESS_EVENT){//Progress location
						readLocation();
						ip=1;
						isProgress=1;
						addNew();
						printf("Progress event received!\n");
						sendConfirmationToJdi();
							
					}else if(indice==OBJECT_FIELD_EVENT){//Read object field
						readIndex();
						readObjectValue(indice);
						readThreadId();
						readLocation();	
						readMethod();
						receiveThreadsLocations();
						sendConfirmationToJdi();
							
					} 

					step++;//this value provides the step SPIN is performing currently
					javaCounter++;//if SPIN performs backtracking this value does not increment
					if(step<=counterLimit){
						now.progCount=step;
					}else{
						now.progCount=0;
					}
					if(!isProgress){
						ip=0;
					}
					
					
					
				       } else now.running=0;

					indice=0;

				     }else{//indice -2
					printf("\nprogram stopped due to violation!!\n");
					verdicts[n_exec-1]=LTL_ERROR_EVENT;
					fileNumber=1;
					if(isNPS>0) now.running=0;
					endExec=javaCounter;
					indice=0;
				     }				
				      fflush(stdout);

	}

	void killer(){
		char * ending=(char*)malloc(20*sizeof(char));
		int reading=0, i=0,n_errors=0,aux=0; 
		int other_errors=0;
	
		if(deadlocks>0){
			printf("%d deadlocks detected at traces: ",deadlocks);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==DEADLOCK_EVENT) {
					printf("%d, ",i+1);
					other_errors++;
				}
			}
			printf("\n");
		}
		if(safedeadlocks>0){
			printf("%d safe deadlocks detected at traces: ",safedeadlocks);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==SAFE_DEADLOCK_EVENT) printf("%d, ",i+1);
			}
			printf("\n");
		}
		if(timeouts>0){
			printf("%d timeouts detected at traces: ",timeouts);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==TIMEOUT_EVENT) printf("%d, ",i+1);
			}
			printf("\n");
		}
		if(safetimeouts>0){
			printf("%d safe timeouts detected at traces: ",safetimeouts);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==SAFE_TIMEOUT_EVENT) printf("%d, ",i+1);
			}
			printf("\n");
		}
		if(assertViolations>0){
			printf("%d assert violations detected at traces: ",assertViolations);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==JAVA_ASSERT_VIOLATION) {
					printf("%d, ",i+1);
					other_errors++;
				}
			}
			printf("\n");
		}
		for(i=0; i<numberOfExecutions; i++){
			if(verdicts[i]==LTL_ERROR_EVENT) n_errors++;
		}
		if(n_errors==0){
			printf("No LTL errors found\n");
			if(other_errors>0){
				printf("TEST FAILED!\n");
			}else{
				printf("TEST PASSED!\n");
			}
			
		}else {
			printf("%d LTL errors at traces: ",n_errors);
			for(i=0; i<numberOfExecutions; i++){
				if(verdicts[i]==LTL_ERROR_EVENT) printf("%d, ",i+1);
			}
			printf("\n");
			aux=n_errors+other_errors;
			if((objective==0)&&(aux<numberOfExecutions)){
				printf("TEST PASSED!\n");
			}else{
				printf("TEST FAILED!\n");
			}
		}
		

		//send end signal to JDI
		
		strcpy(ending,"end");
		reading=strlen(ending);

		close(sock2);
		connectSocket();
		if(!xdr_bytes(&xdrsWrite,&ending,&reading,255)){
			perror("xdr_bytes");
		}
		fflush(fWrite);
		printf("Sending end signal!!!");

		// send if was error or not
		if(!xdr_int(&xdrsWrite,&fileNumber)){
			perror("writing int error\n");
			exit (EXIT_FAILURE);
		}
		fflush(fWrite);
		fileNumber=0;//reset value
		
		if (waitpid(pid, 0, 0) == -1) {
			perror("waitpid");
			exit (EXIT_FAILURE);
		}

		free(ending);
		freeList();
		close(sock2);
			
	}


}

/*generators*/

	int c=0;
	/*number of executions*/
	:: 1->break;
	od;
	c_code{javaCounter=0;now.count=n_exec;};
	running=0;
}


inline execute() {
	int pro=0;
	/* simulation starts */
	c_code {
	
			startSimulation();
			/*print args*/
			now.running = 1;
			freeList();
			endExec=-1;
			startProgram=1;		
	};
	
	/* get values*/
	do
	:: (running) -> c_code {			
				getNewState();
				
				if(isProgress > 0){
					Pinit->pro=1;
					ip=1;
				}else{
					Pinit->pro=0;
					ip=0;
				}
				isProgress=0;
				
			};
/*Progress evaluation*/


		
   	:: (!running) -> break
	od;
			
	
}

init {
	c_code {
		/* launch server */
		initialization();
		createSocket();
	};
	generateConfig();
	execute()
}

