

#include <iostream>
#include <cstdlib>
#include <fstream>

using namespace std;

char Menu();
bool Confirmar(); 
void generarFicheroLPLPSolve(int n);
void generarFicheroLPXPressMP(int n);
void generarFicheroMPSXPressMP(int n);

int main ()
{
    
    bool salir;
    char op;
    int num;
    
    salir=false;
    
    while (!salir){
          
          op = Menu();
          
          switch (op){
                 case 'A' : cout<<"Introduzca n : ";
                            cin >> num;
                            generarFicheroLPLPSolve(num);
                            cout<<endl;
                            cout<<"Fichero .LP para LPSolve creado"<<endl<<endl;
                            break;
                 case 'B' : cout<<"Introduzca n : ";
                            cin >> num;
                            cout<<endl;
                            generarFicheroLPXPressMP(num);
                            cout<<"Fichero .LP para XPressMP creado"<<endl<<endl;
                            break;
                                
                 case 'C' : cout<<"Introduzca n : ";
                            cin >> num;
                            cout<<endl;
                            generarFicheroMPSXPressMP(num);
                            cout<<"Fichero .MPS para XPressMP creado"<<endl<<endl;
                            break;   
                                                     
                 case 'X' : salir = Confirmar();
                            break;
                 default : cout<<"Opcion incorrecta"<<endl<<endl;
                            break;
          }
    }
    
    system("Pause"); // Hacer una pausa
    system("cls");   // Borrar Pantalla
    return 0;	 
}

char Menu()
{
     char op;
     cout << "Menu"<<endl;
     cout << "------"<<endl;
    cout << "A.- Generar el fichero en formato LP para LP_Solve" << endl;
    cout << "B.- Generar el fichero en formato LP para XPressMP" << endl;
    cout << "C.- Generar el fichero en formato MPS" << endl;
    cout << "X.- Salir" << endl;
    cout << endl << "Seleccione una Opcion: ";
    cin>>op;
    op = toupper(op);
    
    return op;
}

bool Confirmar()
{
     char si_no;
     
     cout << endl << endl;
     cout << "Esta seguro (S/N)?";
     cin>> si_no; 
     si_no = toupper(si_no);
     return (si_no=='S');
     
}

void generarFicheroLPLPSolve(int n){
         
    ofstream out;
    string saltos;
    string saltos2;
    char buffer [33];
    string array[2*(n+1)];
    float I[2*(n+1)];
    float F[2*(n+1)];
    float final[2*(n+1)];
    string dr[n+1];
    string dv[n+1];
    string sumas;
    
    //Rellenamos el vector inicio
    for(int i=0;i<=n/2;i++){
       I[i]=0;
    }
    for(int i=(n/2)+1;i<=(n+(n/2));i++){
       I[i]=1;
    }
    for(int i=(n+(n/2)+1);i<2*(n+1);i++){
       I[i]=0;
    }

    //Rellenamos el vector final
    int aux=(2*(n+1)-1);
    int aux2=aux-(n/2);
    for(int i=0;i<n/2;i++){
       F[i]=1;
    }
    for(int i=(n/2);i<=aux2;i++){
       F[i]=0;
    }
    for(int i=aux2+1;i<=aux;i++){
       F[i]=1;
    }
      
      
    
   //RESTAMOS VECTOR FINAL - INICIAL
   for(int i=0;i<2*(n+1);i++){
      final[i]=F[i]-I[i];
   }
   
   
   //RELLENAMOS DESPLAZAMIENTOS DE ROJAS    
   
   dr[0]=dr[0]+"S" + itoa(n+1,buffer,10) + " + S" ;
   dr[0]=dr[0]+ itoa(3*n,buffer,10);
   dr[1]=dr[1] + "- S" + itoa(n+1,buffer,10) + " + S";
   dr[1]=dr[1] + itoa((n+2),buffer,10);   
   
       if(((3*n)+1)<((3*n)+(n-2))){
            dr[1]=dr[1] + " + S" + itoa((3*n)+1,buffer,10);   
       }      
    
     for(int i=2;i<n;i++){
        dr[i]=dr[i] + "- S" + itoa(n+i,buffer,10) + " + S";
        dr[i]=dr[i] + itoa((n+i+1),buffer,10);   
        dr[i]=dr[i] + "- S" + itoa((3*n+(i-2)),buffer,10);   
           if(((3*n)+i)<=((3*n)+(n-2))){
             dr[i]=dr[i] + " + S" + itoa((3*n)+i,buffer,10);   
           }
     }
     dr[n]=dr[n]+ "- S"+ itoa(n+n,buffer,10);
     dr[n]=dr[n]+ "- S"+ itoa((3*n)+(n-2),buffer,10);
   
  
  //RELLENAMOS DESPLAZAMIENTOS DE VERDES
  
   dv[0]=dv[0]+"- S1" + " - S" ;
   dv[0]=dv[0]+ itoa((2*n)+1,buffer,10);
   dv[1]=dv[1] + "S1 - S2";   
   if(n>2){
          dv[1]=dv[1] + " - S" + itoa((2*n)+2,buffer,10);   
          for(int i=2;i<n-1;i++){
             dv[i]=dv[i] + "S" + itoa(i,buffer,10) + " - S";
             dv[i]=dv[i] + itoa((i+1),buffer,10);         
             dv[i]=dv[i] + " + S" + itoa((2*n+(i-1)),buffer,10);   
             dv[i]=dv[i] + " - S" + itoa((2*n)+(i+1),buffer,10);   
          }
          dv[n-1]=dv[n-1]+ "S"+ itoa(n-1,buffer,10);
          dv[n-1]=dv[n-1]+ " - S"+ itoa(n,buffer,10);
          dv[n-1]=dv[n-1]+ " + S"+ itoa((3*n)-2,buffer,10);
   }
   dv[n]=dv[n]+ "S"+ itoa(n,buffer,10);
   dv[n]=dv[n]+ " + S"+ itoa((3*n)-1,buffer,10);
  
  
    out.open("NRanas(LPSolve).lp");
    int val=(4*n)-2;
    saltos="S1 ";
    for (int i=0;i<val-1;i++){
        saltos=saltos+"+ S"+ itoa (i+2,buffer,10) + " ";    
    }
    out<<"Min: "; out<< saltos <<";" <<endl<<endl;
    
    out << "S0:  S"<<itoa (n/2,buffer,10) <<" >= 1;"<<endl;
      for (int i=3*n;i<=val;i++){
       sumas = sumas + " + S" + itoa (i,buffer,10);
    }
    
    for (int i=(2*n)+1;i<3*n;i++){
       sumas = sumas + " - S" + itoa (i,buffer,10);
    }
   
    
    if ((n/2)% 2 == 0){
      sumas=sumas + " = 0;" ;
    }else{
      sumas=sumas + " = 1;" ;
    }                                            
    
    
    out << "ST:  " <<sumas <<endl;
 
    for (int i=0;i<=n;i++){
        out << "R" <<itoa (i+1,buffer,10) <<":  " <<dr[i] <<"   = " << final[i] <<";"<<endl; 
    }
    for (int i=0;i<=n;i++){
        out << "V" <<itoa (i+1,buffer,10) <<":  " <<dv[i] <<"   = " << final[i+(n+1)] <<";" <<endl; 
    }
    
 out  <<endl<<endl;
    
    for (int i=0;i<val;i++){
        out <<"S" <<itoa (i+1,buffer,10) <<" <= 20;" <<endl;    
    }
    
    out <<endl<<endl; 
     
     
     
    int val2=(4*n)-2;
    saltos2="S1";
    for (int i=0;i<val2-1;i++){
        saltos2=saltos2+", S"+ itoa (i+2,buffer,10);    
    }
     
    
    out <<"int"<<endl;
    out << saltos2 <<";";
    out <<endl;  
    out.close();
}

void generarFicheroLPXPressMP(int n){
         
    ofstream out;
    string saltos;
    string saltos2;
    char buffer [33];
    string array[2*(n+1)];
    float I[2*(n+1)];
    float F[2*(n+1)];
    float final[2*(n+1)];
    string dr[n+1];
    string dv[n+1];
    string sumas;
    
    //Rellenamos el vector inicio
    for(int i=0;i<=n/2;i++){
       I[i]=0;
    }
    for(int i=(n/2)+1;i<=(n+(n/2));i++){
       I[i]=1;
    }
    for(int i=(n+(n/2)+1);i<2*(n+1);i++){
       I[i]=0;
    }

    //Rellenamos el vector final
    int aux=(2*(n+1)-1);
    int aux2=aux-(n/2);
    for(int i=0;i<n/2;i++){
       F[i]=1;
    }
    for(int i=(n/2);i<=aux2;i++){
       F[i]=0;
    }
    for(int i=aux2+1;i<=aux;i++){
       F[i]=1;
    }
      
      
    
   //RESTAMOS VECTOR FINAL - INICIAL
   for(int i=0;i<2*(n+1);i++){
      final[i]=F[i]-I[i];
   }
   
   
   //RELLENAMOS DESPLAZAMIENTOS DE ROJAS    
   
   dr[0]=dr[0]+"S" + itoa(n+1,buffer,10) + " + S" ;
   dr[0]=dr[0]+ itoa(3*n,buffer,10);
   dr[1]=dr[1] + "- S" + itoa(n+1,buffer,10) + " + S";
   dr[1]=dr[1] + itoa((n+2),buffer,10);   
   
       if(((3*n)+1)<((3*n)+(n-2))){
            dr[1]=dr[1] + " + S" + itoa((3*n)+1,buffer,10);   
       }      
    
     for(int i=2;i<n;i++){
        dr[i]=dr[i] + "- S" + itoa(n+i,buffer,10) + " + S";
        dr[i]=dr[i] + itoa((n+i+1),buffer,10);   
        dr[i]=dr[i] + "- S" + itoa((3*n+(i-2)),buffer,10);   
           if(((3*n)+i)<=((3*n)+(n-2))){
             dr[i]=dr[i] + " + S" + itoa((3*n)+i,buffer,10);   
           }
     }
     dr[n]=dr[n]+ "- S"+ itoa(n+n,buffer,10);
     dr[n]=dr[n]+ "- S"+ itoa((3*n)+(n-2),buffer,10);
   
  
  //RELLENAMOS DESPLAZAMIENTOS DE VERDES
  
   dv[0]=dv[0]+"- S1" + " - S" ;
   dv[0]=dv[0]+ itoa((2*n)+1,buffer,10);
   dv[1]=dv[1] + "S1 - S2";   
   if(n>2){
          dv[1]=dv[1] + " - S" + itoa((2*n)+2,buffer,10);   
          for(int i=2;i<n-1;i++){
             dv[i]=dv[i] + "S" + itoa(i,buffer,10) + " - S";
             dv[i]=dv[i] + itoa((i+1),buffer,10);         
             dv[i]=dv[i] + " + S" + itoa((2*n+(i-1)),buffer,10);   
             dv[i]=dv[i] + " - S" + itoa((2*n)+(i+1),buffer,10);   
          }
          dv[n-1]=dv[n-1]+ "S"+ itoa(n-1,buffer,10);
          dv[n-1]=dv[n-1]+ " - S"+ itoa(n,buffer,10);
          dv[n-1]=dv[n-1]+ " + S"+ itoa((3*n)-2,buffer,10);
   }
   dv[n]=dv[n]+ "S"+ itoa(n,buffer,10);
   dv[n]=dv[n]+ " + S"+ itoa((3*n)-1,buffer,10);
  
  
    out.open("NRanas(XPressMP).lp");
    int val=(4*n)-2;
    saltos="S1 ";
    for (int i=0;i<val-1;i++){
        saltos=saltos+"+ S"+ itoa (i+2,buffer,10) + " ";    
    }
    out<<"Minimize" <<endl;
    out<< saltos <<endl<<endl;
    
    out <<"Subject To"<<endl;
    out << "S0:  S"<<itoa (n/2,buffer,10) <<" >= 1"<<endl;
    
    for (int i=0;i<=n;i++){
        out << "R" <<itoa (i+1,buffer,10) <<":  " <<dr[i] <<"   = " << final[i] <<endl; 
    }
    for (int i=0;i<=n;i++){
        out << "V" <<itoa (i+1,buffer,10) <<":  " <<dv[i] <<"   = " << final[i+(n+1)]  <<endl; 
    }
    
     for (int i=3*n;i<=val;i++){
       sumas = sumas + " + S" + itoa (i,buffer,10);
    }
    
    for (int i=(2*n)+1;i<3*n;i++){
       sumas = sumas + " - S" + itoa (i,buffer,10);
    }
   
  if ((n/2)% 2 == 0){
      sumas=sumas + " = 0" ;
    }else{
      sumas=sumas + " = 1" ;
    }  
    
    out << "ST:  " <<sumas <<endl;
    out << endl<<endl;    
    out <<"Bounds"<<endl;
    for (int i=0;i<val;i++){
        out <<"S" <<itoa (i+1,buffer,10) <<" <= 20" <<endl;    
    }
    
    out <<endl<<endl; 
     
     
     
    int val2=(4*n)-2;
    saltos2="S1";
    for (int i=0;i<val2-1;i++){
        saltos2=saltos2+" S"+ itoa (i+2,buffer,10);    
    }
     
    
    out <<"Integers"<<endl;
    out << saltos2 <<" "<<endl<<endl;
    out <<"End" <<endl;  
    out.close();
}


void generarFicheroMPSXPressMP(int n)
{
   ofstream out;
   int valor;
   char buffer [33];
   float I[2*(n+1)];
    float F[2*(n+1)];
    float final[2*(n+1)];
        
     for(int i=0;i<=n/2;i++){
       I[i]=0;
    }
    for(int i=(n/2)+1;i<=(n+(n/2));i++){
       I[i]=1;
    }
    for(int i=(n+(n/2)+1);i<2*(n+1);i++){
       I[i]=0;
    }

    //Rellenamos el vector final
    int aux=(2*(n+1)-1);
    int aux2=aux-(n/2);
    for(int i=0;i<n/2;i++){
       F[i]=1;
    }
    for(int i=(n/2);i<=aux2;i++){
       F[i]=0;
    }
    for(int i=aux2+1;i<=aux;i++){
       F[i]=1;
    }
      
      
    
   //RESTAMOS VECTOR FINAL - INICIAL
   for(int i=0;i<2*(n+1);i++){
      final[i]=F[i]-I[i];
   }   
        
        
        
        
        
        
    out.open("NRanas(XPressMP).mps");
    out <<"NAME" <<endl;
    out <<"ROWS" <<endl;                  
    out <<" N   R0" <<endl;
       out << " G   S0  " <<endl;    
    out << " E   ST  " <<endl;
    for (int i=0;i<=n;i++){
        out << " E   R"  <<itoa (i+1,buffer,10)<<endl; 
    }
    for (int i=0;i<=n;i++){
        out << " E   V"  <<itoa (i+1,buffer,10)<<endl; 
    }
    
    out <<"COLUMNS" <<endl;  
    out <<"  MARK0000   'MARKER'                 'INTORG'" <<endl;  
    
    int val2=(4*n)-2;
    for (int i=1;i<=val2;i++){
        if (i<=9){
           out <<"   S" << itoa (i,buffer,10) <<"        "; 
        }else{
           out <<"   S" << itoa (i,buffer,10) <<"       ";    
        }
        if(i==1){
        out<<"R0"<<"         1.0000000000   ";
        out<<"S0"<<"        1.0000000000"<<endl;
        if (i<=9){
           out <<"   S" << itoa (i,buffer,10) <<"        "; 
        }else{
           out <<"   S" << itoa (i,buffer,10) <<"       ";    
        }
        }
        if(i<=n){
           out<<"V"<< itoa (i,buffer,10)<<"        -1.0000000000   ";
           out<<"V"<< itoa (i+1,buffer,10)<<"         1.0000000000"<<endl;
        }else if(i<=(2*n)){
           out<<"R"<< itoa (i-n,buffer,10)<<"         1.0000000000   ";
           out<<"R"<< itoa (i-n+1,buffer,10)<<"        -1.0000000000"<<endl;
        }else if(i<3*n){
           out<<"V"<< itoa (i-(2*n),buffer,10)<<"        -1.0000000000   ";
           out<<"V"<< itoa (i-(2*n)+2,buffer,10)<<"         1.0000000000"<<endl;
           
           if(i<10){
           out <<"   S" << itoa (i,buffer,10) <<"        ";        
           out<<"ST         1.0000000000"<<endl;
           }else{
           out <<"   S" << itoa (i,buffer,10) <<"       ";  
            if ((n/2)% 2 == 0){
               out<<"ST         0.0000000000"<<endl;
            }else{
               out<<"ST         1.0000000000"<<endl;
            }
                
          
           }
        }else if(i<=((4*n)-2)){
           out<<"R"<< itoa (i-(3*n)+1,buffer,10)<<"         1.0000000000   ";
           out<<"R"<< itoa (i-(3*n)+3,buffer,10)<<"        -1.0000000000"<<endl;
           
            if(i<10){
              out <<"   S" << itoa (i,buffer,10) <<"        ";        
              out<<"S0        -1.0000000000"<<endl;
            }else{
             out <<"   S" << itoa (i,buffer,10) <<"       ";         
            out<<"S0        -1.0000000000"<<endl;
            }
        }
    }
    
    out <<endl;
    out <<"  MARK0001   'MARKER'                 'INTEND'" <<endl;  
    valor=(2+(n/2))*(n/2);
    out <<"RHS" <<endl;  
    for (int i=1;i<=n;i=i+2){
    out <<"    RHS      R"<< itoa (i,buffer,10)<<"     "<<final[i-1]  <<".0000000000          R";
    out << itoa ((i+1),buffer,10)<<"     "<<final[i]<<".0000000000"  <<endl;
    }
    out <<"    RHS      R"<< itoa (n+1,buffer,10) <<"     "<<final[n]<<".0000000000         S0      1.0000000000"<<endl;
  
    for (int i=1;i<=n;i=i+2){
    
      out <<"    RHS      V"<< itoa (i,buffer,10)<<"     "<<final[n+i]  <<".0000000000         V";
      out << itoa ((i+1),buffer,10)<<"     "<<final[n+i+1]<<".0000000000"  <<endl;
    }
    out <<"    RHS      V"<< itoa (n+1,buffer,10)<<"     "<<final[2*(n+1)-1]<<".0000000000          ST     1.0000000000";
    out <<endl<<endl;
    out <<"ENDATA" <<endl;  
    out.close();  
}




