import java.io.*;
public class Domino {
	
	
	public static int fichas (int n){
		if (n==0)
			return 1;
		else
			return (n+1+fichas(n-1));
	}
	
	public static void main(String args[]){
        FileWriter fichero = null;
        PrintWriter pw = null;
        
		int z;
		int tam=Integer.parseInt(args[0].trim());
		int ficha=fichas(tam);
		int fichaAlta=10*tam+tam;
		int lados=Integer.parseInt(args[1].trim());
		
		// Apertura de fichero
		try {
			fichero=new FileWriter("Domino"+tam+lados+".lp");
			pw=new PrintWriter(fichero);
		} catch (IOException e) {
			
			e.printStackTrace();
		}
		
		// Minimize
		pw.print("Minimize ");
		for (int i=0;i < lados;i++){
			pw.print("z"+(i+1));
			if (i<(lados-1))
				pw.print(" + ");
		}
		pw.println(" ");
		
		
		// Subject To
		pw.println("Subject To\n");
		
		
		// Imprime la restriccion para la suma de los lados
		for(int i=0;i<lados;i++){
			pw.print("z"+(i+1));
			for(int j=((i*2*ficha)/lados +1);j<=(((i+1)*ficha*2)/lados +1);j++){
				if (j!=ficha*2+1)
					pw.print(" -x"+j);
				else
					pw.print(" -x1");
			}
			pw.println(" = 0");
		}
		pw.println(" ");
		
		// Fuerza a que todos los lados sumen lo mismo		
		for (int i=1;i<lados;i++){
			pw.println("z"+i+" - z"+(i+1)+" = 0");
		}
		
		// Se le puede especificar la ficha inicial
		if(args.length>2){
			int pieza11=Integer.parseInt(args[2].trim());
			int pieza12=Integer.parseInt(args[3].trim());
			if((pieza11<=tam)&&(pieza12<=tam)){
				pw.println(" ");
				pw.println("x1="+pieza11);
				pw.println("x2="+pieza12);
			}else{
				System.out.println("Error: El numero maximo de la ficha es:"+tam);
			}
			
			
		}
		pw.println(" ")	;
		// Comprueba que las fichas sean consecutivas
		for (int i=2; i<ficha*2; i+=2){
			pw.println("x"+i+" - x"+(i+1)+ " = 0");
		}
		pw.println("x"+(ficha*2)+" - x1 = 0");
		
		// Genera las fichas
		for (int i=1;i<=ficha;i++){
			pw.println("y"+(i)+" - 10 x"+(2*i-1)+" - x"+(2*i)+" = 0");		
		}
		pw.println(" ");
		// y las fichas giradas
		for (int i=1;i<=ficha;i++){
			pw.println("w"+(i)+" - x"+(2*i-1)+" - 10 x"+(2*i)+" = 0");		
		}
		pw.println(" ");
		
		// Generador de restricciones para que las fichas no esten repetidas
		z=0;
		for (int i=1;i<=ficha;i++){
			for (int j=i; j<ficha;j++){
				z++;
				pw.println("-y"+i+" + y"+(j+1)+" + "+(fichaAlta +1)+" t" +z+" >= 1");
				pw.println("y"+i+" - y"+(j+1)+" - "+(fichaAlta +1)+" t"+z+" >= -"+fichaAlta);
				z++;
				pw.println("-y"+i+" + w"+(j+1)+" + "+(fichaAlta +1)+" t" +z+" >= 1");
				pw.println("y"+i+" - w"+(j+1)+" - "+(fichaAlta +1)+" t"+z+" >= -"+fichaAlta);
			}
		}
		pw.println(" ");
		
		// Límites para los puntos de las fichas
		pw.println("Bounds");
		pw.println(" ");

		for (int i=1; i<=(ficha*2); i++){
			pw.println("0<= x"+i+" <= "+tam);
		}
		
		// Declaracion de las variables
		pw.println("Integer");

		for(int i=1;i<=(ficha*2);i++){
			pw.print(" x"+i);
		}
		for(int i=1;i<=(ficha);i++){
			pw.print(" y"+i + " w"+i);
		}
		pw.println(" ");
		pw.println("Binaries");
		for(int i=1;i<=z;i++){
			pw.print(" t"+i);
		}
		
		// Cerrar fichero
		if(null!=fichero){
			try {
				fichero.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		
	}
}
