function Hashi(matriz,lp,file)

%Autores: Juan Jos Gutierrez Ortega
%	  Javier Manchn Lpez
%     Manuel Snchez Matas
%matriz => tablero
%lp => si lp=1 formato lp_solve sino XpressMP
%file => nombre del fichero de salida

if nargin>2
	file=fopen(file, 'w');
else
	file=1;
end;

n=size(matriz,1); %numero de filas
m=size(matriz,2); %numero de columnas

if lp
	fprintf(file,'/* Objective function */\nmin:\n');
else
	fprintf(file,'Minimize\n obj: \n');
end;

%funcion objetivo

for i=1:n
        for j=1:m
            k=i;
            for p=j-1:0
                if p>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'+x%d_%d ',islaA,islaE);
                    fprintf(file,'+x%d_%d ',islaE,islaA);
                end;
            end;
     
            for p=j+1:m
                
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+x%d_%d ',islaA,islaE);
                fprintf(file,'+x%d_%d ',islaE,islaA);
            end;
         
            p=j;
            
            for k=i-1:0
                if k>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'+x%d_%d ',islaA,islaE);
                    fprintf(file,'+x%d_%d ',islaE,islaA);
                end;
            end;
     
            for k=i+1:n
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+x%d_%d ',islaA,islaE);
                fprintf(file,'+x%d_%d ',islaE,islaA);
            end;
        end;
end;

if lp
	fprintf(file,';\n\n/* Constraints */\n');
else
	fprintf(file,'\n\nSubject to\n');
end;

%RESTRICCIONES

for i=1:n
    for j=1:m
        if matriz(i,j)~=0
            valor=matriz(i,j);
            k=i;
            p=j-1;
            while p>0 && matriz(k,p)==0
                p=p-1;
            end;
            if p>0
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+ x%d_%d + x%d_%d ',islaA,islaE,islaE,islaA);
            end; 
            
            k=i;
            p=j+1;
            while p<=m && matriz(k,p)==0
                p=p+1;
            end;
            if p<=m
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+ x%d_%d + x%d_%d ',islaA,islaE,islaE,islaA);
            end; 
            
            k=i-1;
            p=j;
            while k>0 && matriz(k,p)==0
                k=k-1;
            end;
            if k>0
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+ x%d_%d + x%d_%d ',islaA,islaE,islaE,islaA);
            end; 
            
            k=i+1;
            p=j;
            while k<=n && matriz(k,p)==0
                k=k+1;
            end;
            if k<=n
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'+ x%d_%d + x%d_%d ',islaA,islaE,islaE,islaA);
            end; 
            
            if lp
                fprintf(file,' = %d;\n', valor);
            else
                fprintf(file,' = %d\n', valor);	
            end;
            
        end;
    end;
end;


%RESTRICCIONES PARA SABER SI EXISTEN PUENTES QUE SE CRUZAN

for i=2:n*m
    encontrado=0;
    fila=floor(i/m)+1;
    columna=mod(i,m);
    if columna>1
        for k=fila+2:n
            for f=fila+1:k-1
                islaA=m*(fila-1)+columna;
                islaB=m*(k-1)+columna;
                for j=1:columna-1
                    for p=columna+1:m
                        islaC=m*(f-1)+j;
                        islaD=m*(f-1)+p;
                        if lp
                            if matriz(fila,columna)~=0 && matriz(k,columna)~=0 && matriz(f,j)~=0 && matriz(f,p)~=0 && encontrado==0
                                fprintf(file, 'x%d_%d + x%d_%d <= 1;\n', islaA, islaB, islaC, islaD);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1;\n', islaA, islaB, islaD, islaC);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1;\n', islaB, islaA, islaC, islaD);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1;\n', islaB, islaA, islaD, islaC);
                                encontrado=1;
                            end;
                        else
                            if matriz(fila,columna)~=0 && matriz(k,columna)~=0 && matriz(f,j)~=0 && matriz(f,p)~=0 && encontrado==0
                                fprintf(file, 'x%d_%d + x%d_%d <= 1\n', islaA, islaB, islaC, islaD);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1\n', islaA, islaB, islaD, islaC);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1\n', islaB, islaA, islaC, islaD);
                                fprintf(file, 'x%d_%d + x%d_%d <= 1\n', islaB, islaA, islaD, islaC);
                                encontrado=1;
                            end;
                        end;
                    end;
                end;
            end;
        end;
    end;
end;

if lp
    fprintf(file,'\n/* Variable bounds */\n');
    
    for i=1:n
        for j=1:m
            k=i;
            for p=j-1:0
                if p>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'0 <= x%d_%d <=1;\n',islaA,islaE);
                    fprintf(file,'0 <= x%d_%d <=1;\n',islaE,islaA);
                end;
            end;
     
            for p=j+1:m
                
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'0 <= x%d_%d <=1;\n',islaA,islaE);
                fprintf(file,'0 <= x%d_%d <=1;\n',islaE,islaA);
            end;
         
            p=j;
            
            for k=i-1:0
                if k>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'0 <= x%d_%d <=1;\n',islaA,islaE);
                    fprintf(file,'0 <= x%d_%d <=1;\n',islaE,islaA);
                end;
            end;
     
            for k=i+1:n
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'0 <= x%d_%d <=1;\n',islaA,islaE);
                fprintf(file,'0 <= x%d_%d <=1;\n',islaE,islaA);
            end;
        end;
    end;
else
    fprintf(file,'\nBinaries\n');
    
    for i=1:n
        for j=1:m
            k=i;
            for p=j-1:0
                if p>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'x%d_%d\n',islaA,islaE);
                    fprintf(file,'x%d_%d\n',islaE,islaA);
                end;
            end;
     
            for p=j+1:m
                
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'x%d_%d\n',islaA,islaE);
                fprintf(file,'x%d_%d\n',islaE,islaA);
            end;
         
            p=j;
            
            for k=i-1:0
                if k>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,'x%d_%d\n',islaA,islaE);
                    fprintf(file,'x%d_%d\n',islaE,islaA);
                end;
            end;
     
            for k=i+1:n
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,'x%d_%d\n',islaA,islaE);
                fprintf(file,'x%d_%d\n',islaE,islaA);
            end;
        end;
    end;
   
end;

if lp
    fprintf(file,'/* Integer definitions */\nint x1_2, x2_1');
    for i=1:n
        for j=1:m
            k=i;
            for p=j-1:0
                if p>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,', x%d_%d',islaA,islaE);
                    fprintf(file,', x%d_%d',islaE,islaA);
                end;
            end;
     
            for p=j+1:m
                
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                if islaA~=1 || islaE~=2
                    fprintf(file,', x%d_%d',islaA,islaE);
                    fprintf(file,', x%d_%d',islaE,islaA);
                end;
            end;
         
            p=j;
            
            for k=i-1:0
                if k>0
                    islaA=m*(i-1)+j;
                    islaE=m*(k-1)+p;
                    fprintf(file,', x%d_%d',islaA,islaE);
                    fprintf(file,', x%d_%d',islaE,islaA);
                end;
            end;
     
            for k=i+1:n
                islaA=m*(i-1)+j;
                islaE=m*(k-1)+p;
                fprintf(file,', x%d_%d',islaA,islaE);
                fprintf(file,', x%d_%d',islaE,islaA);
            end;
        end;
    end;
    
    
    fprintf(file,';\n');
else
    fprintf(file,'\nEnd');
end;
if nargin>2, fclose(file); end;