IMPLEMENTATION MODULE pant;
FROM Window IMPORT Clear,Color,TextColor,TextBackground,GotoXY;
FROM IO IMPORT WrChar,RdKey,WrStr,WrCard,WrLn,RdChar;
FROM Lib IMPORT RANDOMIZE,RANDOM;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
IMPORT FIO;
TYPE
   T_pant= POINTER TO T_matriz;
   T_celda= RECORD
                muro:BOOLEAN;
           END;
   T_matriz= ARRAY [1..50],[1..20] OF T_celda;

(*****************************************************************)
PROCEDURE imprimirmenu();
VAR
BEGIN
    GotoXY(1,25);
    TextColor(LightGreen);
    TextBackground(Red);
    WrStr("   1. Jugar        <Esc> Abandonar Juego        <F1> Ayuda                    ");
    TextBackground(Black);


END imprimirmenu;
(*****************************************************************)

(*****************************************************************)
PROCEDURE visualizar(p:T_pant; puntos_1,puntos_2:CARDINAL);
VAR
  i,j:CARDINAL;
BEGIN
    (* parte de arriba de la pantallita de juego *)
    TextColor(Red);
    GotoXY(20,2);
    WrChar('');
    FOR i:=1 TO 50 DO
        WrChar('');
    END;
    WrChar('');
    TextColor(White);

    (* Cuerpo de la pantallita  de juego *)
    FOR j:=1 TO 20 DO
        GotoXY(20,j+2);
        TextColor(Red);
        WrChar('');
        TextColor(White);
        FOR i:=1 TO 50 DO
               GotoXY(i+20,j+2);
            IF p^[i,j].muro THEN
               TextColor(LightGray);
               WrChar('');
               TextColor(White);
            ELSE

               WrChar(' ');
            END;
        END;
        TextColor(Red);
        WrChar('');
        TextColor(White);
    END;
    (* Final de la pantallita deel juego *)
    GotoXY(20,22);
    TextColor(Red);
    WrChar('');

    FOR i:=1 TO 50 DO
        WrChar('');
    END;
    WrChar('');
    TextColor(White);

    (* Marcador *)
    TextColor(Yellow);
    GotoXY(2,5);WrStr("Jugador1:");WrCard(puntos_1,2);
    TextColor(Cyan);
    GotoXY(2,20);WrStr("Jugador2:");WrCard(puntos_2,2);
     GotoXY(1,25);
    TextColor(Black);
    TextBackground(Green);
    WrStr("                    <Esc> Abandonar Juego                                   ");
    TextBackground(Black);


END visualizar;

(*****************************************************************)
PROCEDURE inicializar(VAR p:T_pant);
VAR
  j,i:CARDINAL ;
BEGIN
    NEW(p);

    FOR j:=1 TO 20 DO
        FOR i:=1 TO 50 DO
            p^[i,j].muro:=FALSE;
        END;
    END;

END inicializar;

(*****************************************************************)
PROCEDURE crear_pant(p:T_pant);
VAR
  nivel:CARDINAL;
  fichero:FIO.File;
  j,i:CARDINAL;
  findelinea,car:CHAR;
BEGIN
    nivel:=RANDOM(3);
    CASE nivel OF
         0: fichero:=FIO.Open("pant0.txt");|
         1: fichero:=FIO.Open("pant1.txt"); |
         2: fichero:=FIO.Open("pant2.txt");  |
         3: fichero:=FIO.Open("pant3.txt");
    END;
    FOR j:=1 TO 20 DO
        FOR i:=1 TO 50 DO
            car:=FIO.RdChar(fichero);
            IF car='X' THEN
               p^[i,j].muro:=TRUE;
            END;
        END;
        findelinea:= FIO.RdChar(fichero);
        findelinea:= FIO.RdChar(fichero);
    END;
    FIO.Close(fichero);
END crear_pant;
(*********************************************************************)
PROCEDURE ayuda();
VAR
  c:CHAR;
BEGIN
    Clear();
    GotoXY(1,3);
    WrStr("             ͻ");WrLn;
    WrStr("                              - AYUDA -                ");WrLn;
    WrStr("              Teclas:                                  "); WrLn;
    WrStr("                    Jugador1: cursores                 "); WrLn;
    WrStr("                    Jugador2: A-izqda                  "); WrLn;
    WrStr("                              S-abajo                  "); WrLn;
    WrStr("                              D-dcha                   "); WrLn;
    WrStr("                              W-arriba                 "); WrLn;
    WrStr("                                                       "); WrLn;
    WrStr("                                                       ");WrLn;
    WrStr("              Se trata de conseguir marcar 10 goles    ");WrLn;
    WrStr("              al contrario                             ");WrLn;
    WrStr("                                                       ");WrLn;
    WrStr("              No se puede pasar a traves de los        ");WrLn;
    WrStr("              ladrillos. Estos pueden destruirse       ");WrLn;
    WrStr("              golpeandolos con la bola                 ");WrLn;
    WrStr("                                                       ");WrLn;
    WrStr("             ͼ");WrLn;
    WrStr("                        <Pulsa una tecla...>             ");
    c:=RdKey();
    Clear();


END ayuda;
(*****************************************************************)
PROCEDURE destruir(VAR p:T_pant);
VAR
BEGIN
    DISPOSE(p);
END destruir;
(*****************************************************************)
PROCEDURE acceder(p:T_pant;x,y:CARDINAL ):BOOLEAN;
VAR
BEGIN
   IF p^[x-20,y-2].muro THEN RETURN TRUE;
   ELSE RETURN FALSE;
   END;
END acceder;
(*****************************************************************)
PROCEDURE borrar_ladrillo(VAR p:T_pant; x,y:CARDINAL);
VAR
BEGIN
    p^[x-20,y-2].muro:=FALSE;

END borrar_ladrillo;
(*****************************************************************)
END pant.