IMPLEMENTATION MODULE pantalla;
FROM IO IMPORT WrChar,WrStr,WrLngCard,RdLn,RdKey,WrCard,WrLn;
FROM Lib IMPORT RANDOM,NoSound;
FROM Window IMPORT GotoXY,TextColor,TextBackground,Color,Clear;
FROM fantasma IMPORT FANTASMA,crearf;
FROM FIO IMPORT File,RdChar,Open,Close,RdCard;

(***************************************************)
PROCEDURE imprimirmenu();
BEGIN
    GotoXY(1,25);
    TextColor(LightGreen);
    TextBackground(Red);
    WrStr("   1.Jugar              <Esc> Acabar/Abandonar Juego             <F1> Ayuda    ");
    TextBackground(Black);
END imprimirmenu;
(***************************************************)
PROCEDURE ayuda();
VAR
  car:CHAR;
BEGIN
  Clear();
               GotoXY(1,3);
               WrStr("             ͻ");WrLn;
               WrStr("                                   AYUDA                     ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               <+/->  Aumenta/Reduce la velocidad de juego,  ");WrLn;
               WrStr("                      solo antes de comenzar el juego.       ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               <Cursores> Direccion del comecocos.           ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               No es necesario tener pulsada la tecla de     ");WrLn;
               WrStr("               direccion, una vez pulsada se mantendran en   ");WrLn;
               WrStr("               esa direccion hasta que le sea posible.       ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               Una vida extra cada 1200 ptos.                ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               Un fantasma adicional cada dos niveles,       ");WrLn;
               WrStr("               comenzando con 2, maximo 8.                   ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("               Segun se sube de nivel, tambien la velocidad  ");WrLn;
               WrStr("               de juego.                                     ");WrLn;
               WrStr("                                                             ");WrLn;
               WrStr("             ͼ");WrLn;
               WrStr("                       Pulse una tecla para continuar");
               car:=CAP(RdKey());
               Clear();
END ayuda;
(***************************************************)
PROCEDURE visualizar(p:PANTALLA;poder:PODER;vidas,nivel:CARDINAL;puntos:LONGCARD);
VAR
  x,y,z:CARDINAL;
BEGIN
  (* Fin de pantalla superior *)
  TextColor(Cyan);
  GotoXY(19,4);
  WrChar('');
  FOR x:=1 TO 40 DO
    WrChar('');
  END;
  WrChar('');
  TextColor(White);


  (* Visualizacion de la pantalla y fin de pantalla laterales *)

  FOR y:=1 TO 15 DO
    GotoXY(19,y+4);
    TextColor(Cyan);
    WrChar('');
    TextColor(White);
    FOR x:=1 TO 40 DO
      IF p[x,y].muro THEN
        GotoXY(x+19,y+4);
        TextColor(LightGray);
        WrChar(CHR(219));
        TextColor(LightGray);
        TextColor(White);
      ELSE
        IF p[x,y].boli THEN
          GotoXY(x+19,y+4);
          WrChar('');
        ELSE
          GotoXY(x+19,y+4);
          WrChar(' ');
        END;
      END;
    END;
    TextColor(Cyan);
    WrChar('');
    TextColor(White);
  END;


  (* Fin de pantalla inferior *)

  GotoXY(19,20);
  TextColor(Cyan);
  WrChar('');
  FOR x:=1 TO 40 DO
    WrChar('');
  END;
  WrChar('');
  TextColor(White);

  (* Colocacion de las bolas para comer los fantasmas *);
    FOR x:=1 TO 4 DO
      IF NOT(poder[x].comido) THEN
        GotoXY(poder[x].x+19,poder[x].y+4);
        TextColor(LightBlue);
        WrChar(CHR(9));
        TextColor(White);
      END;
    END;
  (* Comentarios laterales *)
  GotoXY(2,5);
  WrStr("Puntos:");
  GotoXY(2,6);
  WrLngCard(puntos,11);

  GotoXY(2,8);
  WrStr("Nivel:");
  WrCard(nivel,2);

  GotoXY(2,12);
  TextColor(Yellow);
  WrStr("Comecoco :");   WrChar(CHR(1));

  GotoXY(2,13);
  TextColor(Green);
  WrStr("Fantasmas:");   WrChar(CHR(15));

  (* Imprime las caritas de las vidas *)
  x:=2; y:=14;
  GotoXY(x,y);
  TextColor(LightGray);
  WrStr("Vidas:");
  x:=8;
  FOR z:=2 TO (vidas) DO
    IF x>=17 THEN
      x:=8;
      y:=y+1;
    END;
    GotoXY(x,y);
    WrChar(CHR(1));
    x:=x+1;
  END;

  (* Zona de mensajes *)
  GotoXY(1,25);
  TextColor(LightGreen);
  TextBackground(Red);
  WrStr("   1.Jugar              <Esc> Acabar/Abandonar Juego             <F1> Ayuda    ");
  TextBackground(Black);
END visualizar;
(************************************************)
PROCEDURE inicializar(VAR p:PANTALLA);
VAR
  x,y:CARDINAL;
BEGIN
(* Pongo todo a FALSE por lo que pueda tomar inicialmente y ponga un muro
   no deseado  *)

  FOR y:=1 TO 15 DO
    FOR x:=1 TO 40 DO
      p[x,y].muro:=FALSE;
      p[x,y].boli:=TRUE;
    END;
  END;

END inicializar;
(****************************************************)
PROCEDURE crearpantalla(VAR p:PANTALLA;VAR poder:PODER;nivel:CARDINAL);
VAR
  x,y:CARDINAL;
  fichero:File;
  findelinea,car:CHAR;
BEGIN

(* Abre el fichero que contiene la pantalla a jugar y crea la pantalla *)

  CASE (nivel MOD 10) OF
   1:  fichero:=Open("rom1.dat");|
   2:  fichero:=Open("rom2.dat");|
   3:  fichero:=Open("rom3.dat");|
   4:  fichero:=Open("rom4.dat");|
   5:  fichero:=Open("rom5.dat");|
   6:  fichero:=Open("rom6.dat");|
   7:  fichero:=Open("rom7.dat");|
   8:  fichero:=Open("rom8.dat");|
   9:  fichero:=Open("rom9.dat");|
   0:  fichero:=Open("rom0.dat");|
  END;
  FOR y:=1 TO 15 DO
    FOR x:=1 TO 40 DO
      car:=RdChar(fichero);
      IF car='X'THEN
        p[x,y].muro:=TRUE;
      END;
    END;
    findelinea:=RdChar(fichero);
    findelinea:=RdChar(fichero);
 END;
 FOR x:=1 TO 4 DO
  poder[x].x:=RdCard(fichero);      poder[x].y:=RdCard(fichero);
 END;
 Close(fichero);

(* Quita las bolitas de casillas espacificas  *)

  FOR y:=8 TO 9 DO
    FOR x:=17 TO 24 DO
      p[x,y].boli:=FALSE;
    END;
  END;
  p[1,8].boli:=FALSE;
  p[40,8].boli:=FALSE;

END crearpantalla;
(************************************************)
PROCEDURE n_pantalla(VAR p:PANTALLA;VAR poder:PODER;VAR nivel:CARDINAL);
VAR
  caracter:CHAR;
BEGIN
      GotoXY(12,22);    NoSound();
      WrStr("NIVEL TERMINADO,PULSE UNA TECLA PARA PASAR AL SIGUIENTE.");RdLn;
      caracter:=RdKey();
      Clear();
      nivel:=nivel+1;
      inicializar(p);
      crearpantalla(p,poder,nivel);
END n_pantalla;
(************************************************)
PROCEDURE inicializarp(VAR poder:PODER);
VAR
  x:CARDINAL;
BEGIN
  FOR x:=1 TO 4 DO
    poder[x].comido:=FALSE;
  END;
END inicializarp;

END pantalla.