IMPLEMENTATION MODULE pelota;
FROM IO IMPORT WrChar;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM Lib IMPORT RANDOM;
FROM pant IMPORT acceder;
FROM Window IMPORT GotoXY,TextColor,Color;
FROM jugon IMPORT pos_jug;
TYPE
   rango_direcc=[0..5];
   T_pelota= POINTER TO Reg_pelota;

   Reg_pelota= RECORD
                    x,y:CARDINAL;
                    direcc:rango_direcc;
               END;
(*****************************************************************)
PROCEDURE Crear_pelota():T_pelota;
VAR
    pelot:T_pelota;
BEGIN
    NEW(pelot);
    RETURN pelot;
END Crear_pelota;
(*****************************************************************)
PROCEDURE Destruir_pelota(VAR pelot:T_pelota);
BEGIN
    DISPOSE(pelot);

END Destruir_pelota;
(*****************************************************************)
PROCEDURE Choca(VAR pelot:T_pelota; p:T_pant; jug1,jug2:T_jug);
VAR
  nueva_direcc:CARDINAL;
BEGIN
    CASE pelot^.direcc OF
         0: IF (acceder(p,pelot^.x,pelot^.y-1)) OR (pos_jug(jug1,pelot^.x,pelot^.y-1))
                   OR (pos_jug(jug2,pelot^.x,pelot^.y-1)) THEN
               nueva_direcc:=RANDOM(2);
               CASE nueva_direcc OF
                    0: pelot^.direcc:=3;|
                    1: pelot^.direcc:=2; |
                    2: pelot^.direcc:=4;
               END;
            END;|
         1: IF (acceder(p,pelot^.x+1,pelot^.y-1)) OR (pos_jug(jug1,pelot^.x+1,pelot^.y-1))
                 OR (pos_jug(jug2,pelot^.x+1,pelot^.y-1))  THEN
               pelot^.direcc:=2;

            ELSIF pelot^.x+1>69 THEN
                  pelot^.direcc:=5;
            END;|
         2: IF (acceder(p,pelot^.x+1,pelot^.y+1)) OR (pos_jug(jug1,pelot^.x+1,pelot^.y+1))
                   OR (pos_jug(jug2,pelot^.x+1,pelot^.y+1)) THEN
               pelot^.direcc:=1;

            ELSIF pelot^.x+1>69 THEN
                  pelot^.direcc:=4;
            END;|
         3: IF (acceder(p,pelot^.x,pelot^.y+1)) OR (pos_jug(jug1,pelot^.x,pelot^.y+1))
                   OR (pos_jug(jug2,pelot^.x,pelot^.y+1)) THEN
               nueva_direcc:=RANDOM(2);
               CASE nueva_direcc OF
                    0: pelot^.direcc:=0;|
                    1: pelot^.direcc:=1; |
                    2: pelot^.direcc:=5;
               END;
            END;  |
         4: IF (acceder(p,pelot^.x-1,pelot^.y+1)) OR (pos_jug(jug1,pelot^.x-1,pelot^.y+1))
                 OR (pos_jug(jug2,pelot^.x-1,pelot^.y+1))  THEN
               pelot^.direcc:=5;
            ELSIF pelot^.x-1<21 THEN
               pelot^.direcc:=2;
            END;   |
         5: IF (acceder(p,pelot^.x-1,pelot^.y-1)) OR (pos_jug(jug1,pelot^.x-1,pelot^.y-1))
                 OR (pos_jug(jug2,pelot^.x-1,pelot^.y-1))  THEN
               pelot^.direcc:=4;
            ELSIF pelot^.x-1<21 THEN
                  pelot^.direcc:=1;
            END;

    END;






END Choca;

(*****************************************************************)
PROCEDURE Sacar(VAR pelot:T_pelota);
VAR
BEGIN
    pelot^.x:=(20+22);
    pelot^.y:=(2+10);
    pelot^.direcc:=RANDOM(5);
END Sacar;

(*****************************************************************)
PROCEDURE Pintar_pelot(pelot:T_pelota);
VAR
BEGIN
    GotoXY(pelot^.x,pelot^.y);
    TextColor(Magenta);
    WrChar(CHR(9));
END Pintar_pelot;
(*****************************************************************)
PROCEDURE Mover_pelot(VAR pelot:T_pelota);
BEGIN
    CASE pelot^.direcc OF
         0: pelot^.y:=pelot^.y-1;|
         1: pelot^.x:=pelot^.x+1;
            pelot^.y:=pelot^.y-1;|
         2: pelot^.x:=pelot^.x+1;
            pelot^.y:=pelot^.y+1;|
         3: pelot^.y:=pelot^.y+1;|
         4: pelot^.x:=pelot^.x-1;
            pelot^.y:=pelot^.y+1;|
         5: pelot^.x:=pelot^.x-1;
            pelot^.y:=pelot^.y-1;
    END;

END Mover_pelot;

(*****************************************************************)
PROCEDURE x_pelot(pel:T_pelota):CARDINAL ;
BEGIN
    RETURN pel^.x;

END x_pelot;

(*****************************************************************)
PROCEDURE y_pelot(pel:T_pelota):CARDINAL;
BEGIN
    RETURN pel^.y;
END y_pelot;

(*****************************************************************)
PROCEDURE direcc_pelot(pel:T_pelota):CARDINAL;
BEGIN
    RETURN  pel^.direcc;

END direcc_pelot;

(*****************************************************************)

END pelota.