MODULE Conecta4;
IMPORT IO;
IMPORT Graficos;
IMPORT Tablero;
IMPORT Raton;

VAR
  error: Tablero.ERROR;
  raton: BOOLEAN;
  fila,col: CARDINAL;
  t: Tablero.TABLERO;
  c: CHAR;
  i,j,turno,x,y,fgr,cgr,turno_ant: CARDINAL;
  insertado: BOOLEAN;
BEGIN
    error:=Tablero.Crear(t);
    IF error=Tablero.SinMemoria  THEN
       Graficos.EscribirTxt(12,23,"ERROR: No hay memoria suficiente",FALSE);
       c:=IO.RdKey();
       HALT;
    ELSE
        Tablero.Inicializar(t);
        Graficos.Instrucciones;
        Graficos.DibujarTabla();
        Raton.MostrarRaton();

        (*comenzamos a jugar*)

        (*comienza el jugador 1 -rojo-*)
        turno:=1;
        raton:=FALSE;

        REPEAT
                Graficos.DibujarTurno(turno);

                REPEAT
                     raton:=Raton.LocalizarPosRaton(x,y);
                UNTIL raton=FALSE;

                WHILE (NOT(raton)) DO
                      raton:=Raton.LocalizarPosRaton(x,y);
                END;

                Tablero.ConvertirCoord(x,col);     (*hallamos la columna donde insertar*)
                error:=Tablero.Insertar(t,fila,col,turno);    (*insertamos en la tabla,nos da la fila correcta*)

                (*si se ha insertado correctamente entonces dibujamos la ficha*)
                IF ((error<>Tablero.JugadaIlegal) AND (error<>Tablero.TabLleno)) THEN
                   Tablero.ConvertirCoordGr(fila,fgr);(*convertimos la coordenada fila en coord grficas*)
                   Tablero.ConvertirCoordGr(col,cgr); (*idem con columna*)
                   Graficos.DibujarFicha(cgr,fgr,turno);  (*dibujamos la ficha en el lugar correcto*)
                ELSE
                   IF (error=Tablero.JugadaIlegal) THEN
                      Graficos.EscribirTxt(1,52,"ERROR: JUGADA NO POSIBLE",FALSE);
                      c:=IO.RdKey();
                      Graficos.EscribirTxt(1,52,"ERROR: JUGADA NO POSIBLE",TRUE);
                   ELSE
                      Graficos.EscribirTxt(12,23,"TABLERO LLENO - EMPATE-",FALSE);
                      c:=IO.RdKey();
                      HALT;
                   END;
                END;

                IF (error<>Tablero.JugadaIlegal) THEN
                (*se pasan el turno*)
                     IF (turno=1) THEN
                        turno_ant:=1;  (*para poder comprobar el turno correcto en la cond final*)
                        turno:=2;
                     ELSIF (turno=2) THEN
                        turno_ant:=2;
                        turno:=1;
                     END;
                END; (*si no se ha insertado correctamente por jugada ilegal, repite el mismo jugador*)

    UNTIL (Tablero.EsJugadaGanadora(t,fila,col,turno_ant));

    Graficos.ImprimirGanador(turno_ant);

    c:=IO.RdKey();

    Tablero.Destruir(t);
   END;
END Conecta4.