IMPLEMENTATION MODULE Graficos;
IMPORT IO;
IMPORT Window;
IMPORT Graph;
CONST
    ROJO     = 4;
    AMARILLO = 14;
    NEGRO    = 0;
    MARRON   = 6;
    CYAN     = 3;
    GRIS     = 8;
    VERDE    = 2;

(**************************************************************************)

PROCEDURE EscribirTxt(x,y : CARDINAL; cad: ARRAY OF CHAR; ocultar: BOOLEAN);
VAR
  t:Graph.TextCoords;
  color, c1: CARDINAL;
BEGIN
    IF ocultar THEN
       color:=NEGRO;
    ELSE
       color:=MARRON;
    END;
    t:=Graph.SetTextPosition(x,y);
    c1:=Graph.SetTextColor(color);
    Graph.OutText(cad);

END EscribirTxt;

(**************************************************************************)

PROCEDURE DibujarMarcadores();
VAR
    tc:Graph.TextCoords;
    color: CARDINAL;
BEGIN
    (*Dibujamos los marcadores correspondientes a cada jugador*)

    EscribirTxt(6,60,"JUGADOR 1",FALSE);

    EscribirTxt(15,60,"JUGADOR 2",FALSE);

END DibujarMarcadores;

(***********************************************************************)

PROCEDURE DibujarFichasJug();
BEGIN
    Graph.Disc(510,115,20,ROJO);      (*ficha jugador 1 roja*)
    Graph.Disc(510,240,20,AMARILLO);  (*ficha jugador 2 amarilla*)
END DibujarFichasJug;

(***********************************************************************)

PROCEDURE DibujarTabla();
VAR
  c: CHAR;
  i,j: CARDINAL;
BEGIN
    Graph.GraphMode();
    Graph.ClearScreen(Graph._GWINDOW);

    Graph.Rectangle(0,0,400,350,CYAN,TRUE);  (*Dibujamos el tablero*)

    (*Dibujamos los huecos donde irn las fichas*)
    FOR i:=50 TO 350 BY 50 DO
        FOR j:=50 TO 300 BY 50 DO
            Graph.Disc(i,j,20,GRIS);
        END;
    END;

    DibujarMarcadores();
    DibujarFichasJug();

    EscribirTxt(1,52,"Pulse una tecla para comenzar",FALSE);

    c:=IO.RdKey();

    (*ocultar texto*)
    EscribirTxt(1,52,"Pulse una tecla para comenzar",TRUE);
END DibujarTabla;

(************************************************************************)

PROCEDURE DibujarTurno(c1: CARDINAL);
VAR
  t:BOOLEAN;
  c: CHAR;
  m,i,j: CARDINAL;
BEGIN
    (*Segun a quien corresponda el turno se dibuja la ficha de su color*)
    CASE c1 OF
         1: Graph.Disc(510,115,20,ROJO);
            Graph.Disc(510,240,20,NEGRO); | (*ocultamos la ficha del contrario*)
         2: Graph.Disc(510,240,20,AMARILLO);
            Graph.Disc(510,115,20,NEGRO);   (*ocultamos la ficha del contrario*)
    END;
END DibujarTurno;

(************************************************************************)

PROCEDURE DibujarFicha(fila,col,jug: CARDINAL);
BEGIN
    CASE jug OF
         1: Graph.Disc(fila,col,20,ROJO); |
         2: Graph.Disc(fila,col,20,AMARILLO);
    END;
END DibujarFicha;

(***********************************************************************)



PROCEDURE ImprimirGanador(j: CARDINAL);
VAR
  t1:Graph.TextCoords;
  color: CARDINAL;
BEGIN
    CASE j OF
         1 : EscribirTxt(12,23,"GANADOR JUGADOR 1",FALSE);|
         2 : EscribirTxt(12,23,"GANADOR JUGADOR 2",FALSE);
    END;
END ImprimirGanador;

(************************************************************************)

PROCEDURE Instrucciones();
VAR
  car:CHAR;
BEGIN
  Window.Clear();
               Window.GotoXY(1,3);
               IO.WrStr("             ͻ");IO.WrLn;
               IO.WrStr("                       INSTRUCCIONES   CONECTA4              ");IO.WrLn;
               IO.WrStr("                                                             ");IO.WrLn;
               IO.WrStr("                   El juego consiste en lo siguiente:        ");IO.WrLn;
               IO.WrStr("                                                             ");IO.WrLn;
               IO.WrStr("               Cada jugador ha de intentar conseguir         ");IO.WrLn;
               IO.WrStr("               4 fichas consecutivas de su color,            ");IO.WrLn;
               IO.WrStr("               ya sea en horizontal, vertical o diagonal.    ");IO.WrLn;
               IO.WrStr("               Para ello el jugador seleccionar la columna  ");IO.WrLn;
               IO.WrStr("               donde desea insertar su ficha con el ratn.   ");IO.WrLn;
               IO.WrStr("                                                             ");IO.WrLn;
               IO.WrStr("                                SUERTE                       ");IO.WrLn;
               IO.WrStr("             ͼ");IO.WrLn;IO.WrLn;
               IO.WrStr("                       Pulse una tecla para continuar");
               car:=CAP(IO.RdKey());
               Window.Clear();
END Instrucciones;

(***************************************************)

END Graficos.



