IMPLEMENTATION MODULE Tablero;
IMPORT IO;
IMPORT Graficos;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;

CONST
   FILA    = 5;
   COLUMNA = 6;
TYPE

   POS     = (vacia, jug1, jug2);
   TABLERO = POINTER TO TABLA;
   TABLA   = ARRAY [0..FILA],[0..COLUMNA] OF POS;



(******************************************************************)

PROCEDURE Inicializar(VAR t: TABLERO);
VAR
  i, j: CARDINAL;
BEGIN
    NEW(t);
    (*inicialmente todas las posiciones del ARRAY bidimensional
      tendrn 'vacia' su casilla*)
    FOR i:=0 TO COLUMNA DO
        FOR j:=0 TO FILA DO
            t^[j,i]:=vacia;
        END;
    END;
END Inicializar;


(*****************************************************************)

PROCEDURE Crear(VAR t: TABLERO): ERROR;
VAR
  error: ERROR;
BEGIN
    IF NOT(Available(SIZE(TABLERO))) THEN
       error:=SinMemoria;
    ELSE
       (*hay memoria suficiente para crear un tablero*)
       error:=ninguno;
       t:=NIL;
    END;
    RETURN error;
END Crear;

(******************************************************************)

PROCEDURE Destruir(VAR t: TABLERO);
BEGIN
    IF (t <>NIL) THEN
       DISPOSE(t);
    END;

    (*si es igual a NIL entonces no hay nada que destruir*)

END Destruir;

(********************************************************************)

PROCEDURE ColLegal(t: TABLERO; col: CARDINAL):BOOLEAN;
BEGIN
    RETURN ((col>=0) AND (col<=6));
END ColLegal;

(***********************************************************************)

PROCEDURE HayEspacio(t: TABLERO; VAR fila: CARDINAL; col: CARDINAL):BOOLEAN;
VAR
  hay: BOOLEAN;
  i: INTEGER;
BEGIN

    (*Si hay espacio tendremos en fila donde insertar y devolveremos TRUE.
      Empezaremos examinando por el final del tablero*)

    i:=FILA;
    WHILE ((i>=0) AND (t^[i,col]<>vacia)) DO
          i:=i-1;
    END;
    IF (i<0) THEN
       hay:=FALSE;
    ELSE
       fila:=i;
       hay:=TRUE;
    END;
    RETURN hay;
END HayEspacio;

(**********************************************************************)

PROCEDURE EsJugadaLegal(t: TABLERO; VAR fila: CARDINAL; col:CARDINAL):BOOLEAN;
VAR
  legal: BOOLEAN;
BEGIN

    (*ser legal siempre y cuando est dentro de los intervalos
      y haya hueco en la columna que se indica. Si es jugada legal
      devolveremos en fila la fila asignada*)

    IF (ColLegal(t,col) AND (HayEspacio(t,fila,col))) THEN
       legal:=TRUE;
    ELSE
       legal:=FALSE;
    END;
    RETURN legal;
END EsJugadaLegal;

(*********************************************************************)

PROCEDURE TableroLleno(t: TABLERO):BOOLEAN;
VAR
  lleno, parar: BOOLEAN;
  i, j: CARDINAL ;
BEGIN
    (*Empezaremos a examinar por el ppio del tablero, ya que tendremos
      ms posibilidades de encontrar una casilla vaca*)

    i:=0;
    parar:=FALSE;
    WHILE (NOT(parar) AND (i<=FILA)) DO
          j:=0;
          WHILE ((NOT parar) AND (j<=COLUMNA)) DO
                IF (t^[i,j]=vacia) THEN
                   parar:=TRUE;
                   lleno:=FALSE;
                END;
                j:=j+1;
          END;
          i:=i+1;
    END;
    IF NOT(parar) THEN
       lleno:=TRUE;
    END;
    RETURN lleno;
END TableroLleno;

(**********************************************************************)

PROCEDURE Insertar(VAR t: TABLERO; VAR fila:CARDINAL; col, jug: CARDINAL): ERROR;
VAR
  legal, lleno, si: BOOLEAN;
  error: ERROR;
BEGIN

    (*En Insertar se comprueba si es posible insertar, si la jugada es legal*)

    legal:=EsJugadaLegal(t,fila,col);
    (*si es legal en fila tendremos la fila donde insertar*)

    lleno:=TableroLleno(t);

    IF ((legal) AND NOT(lleno)) THEN
        CASE jug OF
             1 : t^[fila,col]:=jug1; |
             2 : t^[fila,col]:=jug2;
        END;
        error:=ninguno;
    ELSE
       IF (lleno) THEN
          error:=TabLleno;
       ELSIF (NOT(legal)) THEN
          error:=JugadaIlegal;
       END;
    END;
    RETURN error;
END Insertar;

(*********************************************************************)

PROCEDURE FilaGanadora(t: TABLERO; fila, col: CARDINAL; j: POS):BOOLEAN;
VAR
  gana : BOOLEAN;
  pos  : CARDINAL;
  c    : INTEGER;
BEGIN
    (*en este caso variar unicamente la columna*)
    pos:=1;
    c:=col+1;
    (*examinamos de col en adelante*)
    WHILE ((c<=COLUMNA) AND (t^[fila,c]=j)) DO
        pos:=pos+1;
        c:=c+1;
    END;

    (*examinamos de col hacia atrs*)
    IF (col>0) THEN
       c:=col-1;
       WHILE ((c>=0) AND (t^[fila,c]=j)) DO
          pos:=pos+1;
          c:=c-1;
       END;
    END;
    IF (pos>=4) THEN
       gana:=TRUE;
    ELSE
       gana:=FALSE;
    END;
    RETURN gana;
END FilaGanadora;

(*********************************************************************)

PROCEDURE ColGanadora(t: TABLERO; fila, col: CARDINAL; j:POS):BOOLEAN;
VAR
  gana: BOOLEAN;
  pos : CARDINAL;
  f   : INTEGER;
BEGIN
    (*Solo tendremos que comprobar de la casilla actual hacia abajo*)
    (*variar unicamente la fila                                   *)

    pos:=1;
    f:=fila+1;
    WHILE ((f<=FILA) AND (t^[f,col]=j)) DO
          pos:=pos +1;
          f:=f+1;
    END;
    IF (pos>=4) THEN
       gana:=TRUE;
    ELSE
       gana:=FALSE;
    END;
    RETURN gana;
END ColGanadora;

(*********************************************************************)


PROCEDURE DiagGanadora(t: TABLERO; fila, col: CARDINAL; j: POS):BOOLEAN;
VAR
  gana : BOOLEAN;
  pos  : CARDINAL;
  f,c  : INTEGER;
BEGIN
    (*Tendremos que comprobar dos diagonales*)

    (*Comprobamos la primera diagonal*)
    (*por encima*)
    pos:=1;
    IF (fila>0) THEN
       f:=fila-1;
       c:=col+1;
       WHILE ((f>=0) AND (c<COLUMNA) AND (t^[f,c]=j)) DO
          pos:=pos+1;
          f:=f-1;
          c:=c+1;
       END;
    END;

    (*por debajo*)
    IF (col>0) THEN
       f:=fila+1;
       c:=col-1;
       WHILE ((f<=FILA) AND (c>=0) AND (t^[f,c]=j)) DO
          pos:=pos+1;
          f:=f+1;
          c:=c-1;
       END;
    END;

    IF (pos>=4) THEN
       gana:=TRUE;
    ELSE
       (*comprobamos la otra diagonal*)
       (*por encima*)
       pos:=1;
       IF ((fila>0) AND (col>0)) THEN
          f:=fila-1;
          c:=col-1;
          WHILE ((f>=0) AND (c>=0) AND (t^[f,c]=j)) DO
             pos:=pos+1;
             f:=f-1;
             c:=c-1;
          END;
       END;

       (*por debajo*)
       f:=fila+1;
       c:=col+1;
       WHILE ((f<=FILA) AND (c<=COLUMNA) AND (t^[f,c]=j)) DO
             pos:=pos+1;
             f:=f+1;
             c:=c+1;
       END;
       IF (pos>=4) THEN
          gana:=TRUE;
       ELSE
          gana:=FALSE;
       END;
    END;
    RETURN gana;
END DiagGanadora;

(*********************************************************************)



PROCEDURE EsJugadaGanadora(t: TABLERO; fila, col, jug: CARDINAL):BOOLEAN;
VAR
  gana: BOOLEAN;
  j: POS;
BEGIN
    (*tendremos que comprobar si la jugada recien hecha es ganadora *)
    (*la jugada que acabamos de hacer es t^[fila,col]=jug           *)

    CASE jug OF
         1 : j:=jug1; |
         2 : j:=jug2;
    END;
    IF ((FilaGanadora(t,fila,col,j)) OR (ColGanadora(t,fila,col,j))
         OR (DiagGanadora(t,fila,col,j))) THEN
         gana:=TRUE;
    ELSE
       gana:=FALSE;
    END;
    RETURN gana;
END EsJugadaGanadora;

(***********************************************************************)

PROCEDURE ConvertirCoord(col: CARDINAL; VAR cnew: CARDINAL);
BEGIN
    (*con las coordenadas grficas obtenemos las coordenadas de la tabla*)

    IF ((col>=30) AND (col<=70)) THEN
       cnew:=0;
    ELSIF ((col>=80) AND (col<=120)) THEN
          cnew:=1;
    ELSIF ((col>=130) AND (col<=170)) THEN
          cnew:=2;
    ELSIF ((col>=180) AND (col<=220)) THEN
          cnew:=3;
    ELSIF ((col>=230) AND (col<=270)) THEN
          cnew:=4;
    ELSIF ((col>=280) AND (col<=320)) THEN
          cnew:=5;
    ELSIF ((col>=330) AND (col<=370)) THEN
          cnew:=6;
    END;
END ConvertirCoord;

(***********************************************************************)

PROCEDURE ConvertirCoordGr(ant: CARDINAL; VAR new: CARDINAL);
BEGIN
    (*Con las coordenadas de la tabla obtenemos las grficas*)
    new:=(ant+1)*50;
END ConvertirCoordGr;

(**********************************************************************)

END Tablero.

