IMPLEMENTATION MODULE anima;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;
IMPORT FIO;
CONST
    maxx = 16;
    maxy = 16;
TYPE
   xx = RECORD
         Linea :  ARRAY [0..maxx] OF CHAR ;
        END;
   Bits = RECORD
              x,y : CARDINAL;   (* profundidad y anchura de la imagen*)
              Color : ARRAY [0..maxy] OF xx;

          END;
   TB = POINTER TO Bits;

   TLista = ARRAY [1..maxlista] OF TB;
   Reg = RECORD
            maxframe : CARDINAL;
            Lista : TLista;
         END;
   ANIMA = POINTER TO Reg;


PROCEDURE Crear(): ANIMA;
VAR
  x : ANIMA;
  cont : CARDINAL;
BEGIN
    NEW(x);
    x^.maxframe := 0;
    FOR cont := 1 TO maxlista DO
        x^.Lista[cont] := NIL;
    END;

    RETURN x;
END Crear;

PROCEDURE AnadeAnim(fich : ARRAY OF CHAR; VAR M : ANIMA);
VAR
  man : FIO.File;
  total, y : CARDINAL;
  aux : TB;
  cabeza : BitMapHeader;
BEGIN
  IF FIO.Exists(fich) THEN
        man := FIO.Open(fich);

        total := FIO.RdBin(man, cabeza, SIZE(BitMapHeader));

        INC(M^.maxframe);
        IF M^.maxframe <= maxlista THEN

            NEW(M^.Lista[M^.maxframe]);

            aux := M^.Lista[M^.maxframe];

            aux^.x := INTEGER(cabeza.biWidth);
            aux^.y := INTEGER(cabeza.biHeight);


            FIO.Seek(man,LONGCARD(cabeza.bfOffbits));(*Coloco la lectura al pricipio de los datos*)
            FOR y := 0 TO CARDINAL(cabeza.biHeight) DO
                   total:=FIO.RdBin(man, aux^.Color[y].Linea, CARDINAL(cabeza.biWidth));
            END;
        ELSE


        END;
        FIO.Close(man);
    END;
END AnadeAnim;


PROCEDURE PonAnimacion(VAR anim : ANIMA; num, x0, y0 : INTEGER; VAR M1 : BMP);
VAR
  aux : TB;
  blanco, caracter : CHAR;
  x,y : INTEGER ;
BEGIN
   IF num <= maxlista THEN

      aux := anim^.Lista[num];

      blanco := aux^.Color[0].Linea[0];

      FOR x := x0 TO  maxx+x0  -1      DO
          FOR y := y0 TO maxy+y0 -1    DO

                  IF ((x < 320) AND (y < 200) AND
                            (x >=0) AND (y>=0)) THEN
                       caracter := aux^.Color[y-y0].Linea[x-x0];
                       IF caracter <> blanco THEN
                            M1^.Color[y].Linea[x] := caracter;
                       END;
                  END;
          END;
      END;
   END;

END PonAnimacion;


PROCEDURE Destruir(VAR anim: ANIMA);
VAR
  x : CARDINAL;
BEGIN
FOR x := 1 TO anim^.maxframe DO
  IF anim^.Lista[x] <> NIL THEN
     DISPOSE(anim^.Lista[x]);
  END;
END;
   DISPOSE(anim);
END Destruir;

END anima.