MODULE cc;
IMPORT fantasma, comecoco, pantalla, scores;
IMPORT IO, Window;
IMPORT Lib, Graph;
IMPORT icon, fondo, anima;
IMPORT tipo;


CONST
    TimeDelay = 1;


VAR
  malos : fantasma.FANTASMAS;
  bueno : comecoco.COMECOCO;
  puntuacion : scores.Puntos;
  tablero : pantalla.PANTALLA;
  op : CHAR;
  x,y, vidas : INTEGER;
  x0 : BOOLEAN;

  Gra : tipo.TipoGR;
BEGIN
  (* ----------------- INICIALIZAR VARIABLES ------------------*)
    x := 7;
    y := 1;
    Window.Clear();
    Window.CursorOff();


    puntuacion := scores.Inicializar();
    tablero := pantalla.Crear("PANT1.DAT", puntuacion);
    fantasma.Crear(malos);
    bueno := comecoco.Crear(x, y);
    pantalla.PonCoco(tablero, x,y,puntuacion);


    fantasma.Annadir(malos,7 ,6, 1);
    fantasma.Annadir(malos,6 ,6, 2);
    fantasma.Annadir(malos,8 ,6, 3);
    fantasma.Annadir(malos,9 ,6, 4);

    pantalla.PonFantasma(tablero, 7, 6, 1,puntuacion);
    pantalla.PonFantasma(tablero, 6, 6, 2,puntuacion);
    pantalla.PonFantasma(tablero, 8, 6, 3,puntuacion);
    pantalla.PonFantasma(tablero, 9, 6, 4,puntuacion);





    vidas := scores.CuantasVidas(puntuacion);




    tipo.Iniciar(Gra);



    (*   ............  inicia graf       .......................     *)


   Graph.GetVideoConfig(Gra.vid);
   x0 :=Graph.SetVideoMode(19);
   icon.IniciaVideoDelay();

   fondo.PonPaleta(Gra.pal);


    (* -------------------BUCLE DE JUEGO------------------------*)

    REPEAT
      IF (vidas >  scores.CuantasVidas(puntuacion)) THEN
         comecoco.Destruir(bueno, tablero);
         bueno := comecoco.Crear(x,y);
         vidas := scores.CuantasVidas(puntuacion);
         pantalla.PonCoco(tablero, x,y, puntuacion);
      END;

      pantalla.Visualizar(tablero, puntuacion, Gra);
      IF IO.KeyPressed() THEN
        op := IO.RdKey();
        IO.RdLn();
      END;
      fantasma.Mover(malos, tablero, puntuacion);
      CASE op OF
        '4' : comecoco.Mover(bueno,-1, 0, tablero, puntuacion);|
        '2' : comecoco.Mover(bueno, 0,-1, tablero, puntuacion);|
        '6' : comecoco.Mover(bueno, 1, 0, tablero, puntuacion);|
        '8' : comecoco.Mover(bueno, 0, 1, tablero, puntuacion);
      END;

      Lib.Delay(TimeDelay);
      IF scores.EstaSuper(puntuacion) THEN
         scores.DecSuper(puntuacion);
         comecoco.CompruebaPos(bueno, malos, puntuacion);
      END;


    UNTIL (op = CHR(27)) OR (scores.HaMuerto(puntuacion)) OR NOT(scores.QuedanFrutas(puntuacion));



 (* -------------------DEVOLVER RECURSOS -------------------------*)


    icon.AcabaVideoDelay();

     x0 := Graph.SetVideoMode(Gra.vid.mode);

    tipo.Destruir(Gra);

    comecoco.Destruir(bueno, tablero);

    fantasma.Destruir(malos);

    pantalla.Destruir(tablero);

    IF scores.HaMuerto(puntuacion) THEN
       IO.WrLn();
       IO.WrStr("                           <<<<<< HAS MUERTO !!! >>>>>");IO.WrLn;
    ELSIF (op = CHR(27)) THEN
       IO.WrLn();
       IO.WrStr("                           <<<<<< JUEGO ABORTADO >>>>>");IO.WrLn;
    ELSE
        IO.WrLn();
       IO.WrStr("                           <<<<<<   HAS GANADO   >>>>>");IO.WrLn;
    END;

   scores.Destruir(puntuacion);





    Window.CursorOn();
END cc.
