IMPLEMENTATION MODULE comecoco;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;
IMPORT pantalla;

TYPE
   COMECOCO = POINTER TO Dat;
   Dat = RECORD
              x,
              y : INTEGER;
         END;

(* -------------- variables globales (trat. error) -----------------*)
VAR
  error : ERROR;

(* --------------------- procedimientos ---------------------------*)


PROCEDURE Crear(x, y : INTEGER): COMECOCO;
VAR
p : COMECOCO;
BEGIN
    IF Available(SIZE(Dat)) THEN
       NEW(p);
       p^.x := x;
       p^.y := y;
       error := SinError;
     ELSE
       error := SinMemoria;
       p := NIL;
     END;
     RETURN p;
END Crear;

PROCEDURE Mover(VAR c : COMECOCO; incx, incy: INTEGER;VAR  pant : PANTALLA; VAR punt : Puntos);

BEGIN
   IF pantalla.CasillaValida(pant, c^.x + incx, c^.y +incy) THEN

       pantalla.BorraCoco(pant, c^.x, c^.y);
       c^.x := c^.x + incx;
       c^.y := c^.y + incy;
       pantalla.PonCoco(pant, c^.x, c^.y, punt );
   END;
END Mover;

PROCEDURE Error() : ERROR;
BEGIN
    RETURN error;
END Error;

PROCEDURE CompruebaPos(VAR c : COMECOCO;VAR f : fantasma.FANTASMAS ;VAR punt : scores.Puntos);
VAR
  aux : fantasma.FANTASMAS;
  x, y, col : INTEGER;
BEGIN
 IF scores.EstaSuper(punt) THEN
          fantasma.Crear(aux);
          WHILE fantasma.HayFantasmas(f) DO
              fantasma.Sacar(f, x,y, col);
              IF NOT((c^.x = x) AND (c^.y = y)) THEN
                  fantasma.Annadir(aux, x, y, col);
              END;
          END;
          f := aux;
 END;
END CompruebaPos;

PROCEDURE Destruir(VAR c : COMECOCO; VAR pant : PANTALLA);
BEGIN
    pantalla.BorraCoco(pant, c^.x, c^.y);
    DISPOSE(c);
END Destruir;

END comecoco.