IMPLEMENTATION MODULE fantasma;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;
IMPORT pantalla;
IMPORT scores;
FROM scores IMPORT Puntos;
IMPORT Lib;

TYPE
      fantas = RECORD
                   x,
                   y,
                   col : INTEGER;
                   sig : FANTASMAS;
                 END;
      FANTASMAS = POINTER TO fantas;


(* -------------- variables globales (trat. error) -----------------*)
VAR
  error : ERROR;

(* --------------------- procedimientos ---------------------------*)



PROCEDURE Crear(VAR f: FANTASMAS);
BEGIN
    Lib.RANDOMIZE();
    f := NIL;
END Crear;


PROCEDURE Annadir(VAR f : FANTASMAS; x, y, col : INTEGER);
VAR aux : FANTASMAS;
BEGIN
    IF Available(SIZE(fantas)) THEN
       NEW(aux);
       aux^.x := x;
       aux^.y := y;
       aux^.col := col;
       aux^.sig := f;
       f := aux;
       error := SinError;
     ELSE
       error := SinMemoria;
     END;
END Annadir;

PROCEDURE Sacar(VAR f: FANTASMAS; VAR x,y, col : INTEGER);
VAR
  aux : FANTASMAS;
BEGIN
    IF f <> NIL THEN
       aux := f;
       f := f^.sig;
       x := aux^.x;
       y := aux^.y;
       col := aux^.col;
       DISPOSE(aux);
    ELSE
       error := NullPointer;
    END;
END Sacar;

PROCEDURE HayFantasmas(VAR f : FANTASMAS): BOOLEAN;
BEGIN
    RETURN (f <> NIL );


END HayFantasmas;

PROCEDURE Mover(VAR f: FANTASMAS; p : PANTALLA; VAR punt : Puntos);
VAR
  Mov : CARDINAL;
  aux : FANTASMAS;
BEGIN
 aux := f;
 WHILE aux <> NIL DO

    Mov :=  Lib.RANDOM(4);

    CASE Mov OF

        0: IF  pantalla.CasillaValida(p, aux^.x , aux^.y - 1) THEN
               pantalla.BorraFantasma(p, aux^.x, aux^.y);
               DEC(aux^.y);
               pantalla.PonFantasma(p, aux^.x, aux^.y, aux^.col ,  punt);
            END;  |

        1: IF  pantalla.CasillaValida(p, aux^.x , aux^.y+1) THEN
               pantalla.BorraFantasma(p, aux^.x, aux^.y);
               INC(aux^.y);
               pantalla.PonFantasma(p, aux^.x, aux^.y, aux^.col,punt);
            END;  |

        2: IF  pantalla.CasillaValida(p, aux^.x-1 , aux^.y)  THEN
               pantalla.BorraFantasma(p, aux^.x, aux^.y);
               DEC(aux^.x);
               pantalla.PonFantasma(p, aux^.x, aux^.y,aux^.col, punt);
            END;  |

        3: IF  pantalla.CasillaValida(p, aux^.x+1 , aux^.y)  THEN
               pantalla.BorraFantasma(p, aux^.x, aux^.y);
               INC(aux^.x);
               pantalla.PonFantasma(p, aux^.x, aux^.y,aux^.col, punt);
            END;

        END;
  aux := aux^.sig;
 END;
END Mover;

PROCEDURE Error(): ERROR;
BEGIN
    RETURN error;
END Error;

PROCEDURE Destruir(VAR f : FANTASMAS);
VAR
  p : FANTASMAS;
BEGIN
    WHILE f <> NIL DO
          p := f;
          f := f^.sig;
          DISPOSE(p);
    END;
END Destruir;

END fantasma.