IMPLEMENTATION MODULE pantalla;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;
IMPORT IO,FIO, Window, Graph;
IMPORT scores;
IMPORT tipo, fondo, anima, icon;

CONST
    FANTASMA = CHR(01);
    COMECOCO = CHR(2);
    FRUTA    = CHR(250);
    BOLA     = CHR(15);
    MURO     = CHR(219);
    BLANCO   = ' ';
    xbase    =  305;
    ybase    =  143;
    xbase0   = 305;
    ybase0   = 92;

TYPE
  Celd = RECORD
              fantasma,
              comecoco,
              fruta,
              bola,
              muro : BOOLEAN;
              color : CARDINAL;

          END;
   Tabl = ARRAY [0..MAX_X],[0..MAX_Y] OF Celd;
   PANTALLA = POINTER TO Tabl;

(* -------------- variables globales (trat. error)---*)
VAR
  error : ERROR;
  cocovar : CARDINAL;


(* --------------------- procedimientos ---------------------------*)

PROCEDURE CargarDesdeEn(d: ARCHIVO; VAR  p : PANTALLA; VAR punt : Puntos);
VAR
  man : FIO.File;
  tmp : ARRAY [0..MAX_X+1] OF CHAR ;
  x,y : CARDINAL;
BEGIN
    IF FIO.Exists(d) THEN
       man := FIO.Open(d);
       FOR y := 0 TO MAX_Y DO
         FIO.RdStr(man, tmp);
         FOR x := 0 TO MAX_X DO
           CASE tmp[x] OF
            BLANCO : p^[x,y].fantasma := FALSE; p^[x,y].comecoco := FALSE;
                     p^[x,y].fruta    := FALSE; p^[x,y].bola     := FALSE;
                     p^[x,y].muro     := FALSE; |

            MURO   : p^[x,y].fantasma := FALSE; p^[x,y].comecoco := FALSE;
                     p^[x,y].fruta    := FALSE; p^[x,y].bola     := FALSE;
                     p^[x,y].muro     := TRUE; |

            '.'    : p^[x,y].fantasma := FALSE; p^[x,y].comecoco := FALSE;
                     p^[x,y].fruta    := TRUE;  p^[x,y].bola     := FALSE;
                     p^[x,y].muro     := FALSE; scores.IncFrutas(punt);|

            '*'    : p^[x,y].fantasma := FALSE; p^[x,y].comecoco := FALSE;
                     p^[x,y].fruta    := FALSE; p^[x,y].bola     := TRUE;
                     p^[x,y].muro     := FALSE; scores.IncFrutas(punt);
            ELSE
                     error := ArchivoCorrupto;

            END;
            p^[x,y].color := 0;

       END;
      END;
      FIO.Close(man);
    ELSE
       error := FaltaArchivo;
    END;
END CargarDesdeEn;



PROCEDURE Crear(d : ARCHIVO; VAR punt: Puntos): PANTALLA;
VAR
  p : PANTALLA;
BEGIN

    IF Available(SIZE(Tabl)) THEN
       NEW(p);
       error := SinError;
       CargarDesdeEn(d, p, punt);
    ELSE
       p := NIL;
       error := SinMemoria;
    END;
    RETURN p;
END Crear;



PROCEDURE CasillaValida(VAR p : PANTALLA; x, y : INTEGER): BOOLEAN;
BEGIN
  IF p <> NIL THEN
     IF ((x >= 0) AND (x <= MAX_X) AND (y >= 0) AND (y <= MAX_Y)) THEN
        IF (p^[x,y].muro) THEN
           RETURN FALSE;
        ELSE
           RETURN TRUE;
        END;
     ELSE
         RETURN FALSE;
     END;
  ELSE
     error := NullPointer;
  END;
END CasillaValida;


PROCEDURE BorraCoco(VAR p: PANTALLA; x,y : INTEGER);
BEGIN
   p^[x,y].comecoco := FALSE;
END BorraCoco;


PROCEDURE PonCoco(VAR p: PANTALLA; x,y : INTEGER;VAR  punt : scores.Puntos);
BEGIN
    WITH p^[x,y] DO
         comecoco := TRUE;
         IF fantasma THEN
            IF scores.EstaSuper(punt) THEN
               fantasma := FALSE;
               scores.MasPuntos(punt, 20);
            ELSE
               comecoco := FALSE;
               scores.Muere(punt);
            END;
         ELSIF bola THEN

            bola := FALSE;
            scores.ComoBola(punt);
            scores.DecFrutas(punt);
            scores.MasPuntos(punt, 5);

         ELSIF fruta THEN
            fruta := FALSE;
            scores.DecFrutas(punt);
            scores.MasPuntos(punt, 2);
         END;
     END;
END PonCoco;


PROCEDURE BorraFantasma(VAR p: PANTALLA; x,y : INTEGER);
BEGIN
   p^[x,y].fantasma := FALSE;
   p^[x,y].color := 0;
END BorraFantasma;


PROCEDURE PonFantasma(VAR p: PANTALLA; x,y,col : INTEGER;VAR  punt: scores.Puntos);
BEGIN
    WITH p^[x,y] DO
         IF comecoco THEN
           IF scores.EstaSuper(punt) THEN
               fantasma := FALSE;
               scores.MasPuntos(punt, 100);
            ELSE
               fantasma := TRUE;
               color := col;
               scores.Muere(punt);
           END;
         ELSE
            fantasma := TRUE;
            color := col;
         END;
     END;
END PonFantasma;



PROCEDURE NoHayFanta(VAR p: PANTALLA; x, y: INTEGER  ): BOOLEAN;

BEGIN
    RETURN NOT(p^[x,y].fantasma);


END NoHayFanta;





TYPE
   cadnum = ARRAY [0..6] OF CHAR;
PROCEDURE ACadena(x : CARDINAL): cadnum;
VAR
 cad : cadnum ;
 con, c : CARDINAL;

BEGIN
  con := 0;
WHILE x > 0 DO
  c := x MOD 10;
  x := x DIV 10;
  cad[con] := CHR(c + ORD(0));
  INC(con);
END;
  IF con <= 6 THEN
     cad[con] := 0C;
  END;
RETURN cad;
END ACadena;

PROCEDURE Visualizar(VAR p : PANTALLA; punt : scores.Puntos; VAR Gra : tipo.TipoGR);
VAR
  x, y, posx, posy : INTEGER;
  kk : Graph.TextCoords;
  kk2 , pun, cont1, seg: CARDINAL;
BEGIN
    icon.Intercambia;
    fondo.Copia(Gra.back, Gra.pant);
      IF p <> NIL THEN
         FOR y := 0 TO MAX_Y DO
            FOR x := 0 TO MAX_X DO
                 posx := x * 16;
                 posy := y * 16;
                 WITH p^[x,y] DO
                     IF fantasma THEN

                         anima.PonAnimacion(Gra.grafant,color,  posx, posy,  Gra.pant);
                      ELSIF comecoco THEN
                         IF cocovar >= 4 THEN
                            cocovar := 1;
                         ELSE
                            INC(cocovar);
                         END;


                         IF scores.EstaSuper(punt) THEN
                         anima.PonAnimacion(Gra.grafcoco, cocovar+4, posx, posy,  Gra.pant);



                         ELSE


                         anima.PonAnimacion(Gra.grafcoco, cocovar, posx, posy,  Gra.pant);

                        END;
                     ELSIF muro THEN

                          anima.PonAnimacion(Gra.objetos, 1, posx, posy,  Gra.pant);
                     ELSIF fruta THEN
                           anima.PonAnimacion(Gra.objetos, 2, posx, posy, Gra.pant);
                     ELSIF bola THEN
                           anima.PonAnimacion(Gra.objetos, 3, posx, posy, Gra.pant);
                     ELSE

                     END;
                 END;
            END;
        END;

        pun := scores.CuantosPuntos(punt);


        IF pun = 0 THEN
           anima.PonAnimacion(Gra.tnum, 1, xbase-16,  ybase, Gra.pant);

        END;
        cont1 := xbase;
        WHILE (pun > 0) DO
            seg := pun MOD 10;
            pun := pun DIV 10;
            DEC(cont1, 16);
            anima.PonAnimacion(Gra.tnum, seg +1, cont1, ybase, Gra.pant);
        END;

        pun := scores.CuantasVidas(punt);
        cont1 := xbase0;
        WHILE (pun > 0) DO
            seg := pun MOD 10;
            pun := pun DIV 10;
            DEC(cont1, 16);
            anima.PonAnimacion(Gra.tnum, seg +1, cont1, ybase0, Gra.pant);
        END;



        fondo.Pinta(Gra.pant);





    ELSE
       error := NullPointer;
    END;
END Visualizar;

PROCEDURE Error() : ERROR;
BEGIN
    RETURN error;
END Error;

PROCEDURE Destruir(VAR p : PANTALLA);
BEGIN
    DISPOSE(p);
END Destruir;

END pantalla.