IMPLEMENTATION MODULE scores;
FROM Storage IMPORT ALLOCATE, DEALLOCATE, Available;
CONST
    CONTSUPER = 20;


TYPE
  kk = RECORD
         vidas : INTEGER;
         puntos : CARDINAL;
         contador : CARDINAL;
         frutas : CARDINAL;
       END;
  Puntos = POINTER TO kk;

VAR
  error : ERROR;

PROCEDURE Inicializar(): Puntos;
VAR
  p : Puntos;
BEGIN
    IF Available(SIZE(kk)) THEN
       NEW(p);
       p^.vidas := 3;
       p^.puntos := 0;
       p^.contador := 0;
       p^.frutas := 0;
    ELSE
       error := SinMemoria;
    END;
    RETURN p;
END Inicializar;

PROCEDURE HaMuerto(VAR p : Puntos): BOOLEAN;
BEGIN
    RETURN (p^.vidas = -1);
END HaMuerto;

PROCEDURE MasPuntos(VAR p : Puntos; x : CARDINAL);
BEGIN
    p^.puntos := p^.puntos + x;
END MasPuntos;

PROCEDURE Error(): ERROR;
BEGIN
    RETURN error;
END Error;

PROCEDURE Muere(VAR p : Puntos);
BEGIN
    DEC(p^.vidas);
END Muere;

PROCEDURE CuantosPuntos(VAR p : Puntos): CARDINAL;
BEGIN
    RETURN p^.puntos;
END CuantosPuntos;

PROCEDURE CuantasVidas(VAR p : Puntos): INTEGER;
BEGIN
    RETURN p^.vidas;
END CuantasVidas;


PROCEDURE ComoBola(VAR p: Puntos);
BEGIN
    p^.contador := p^.contador + CONTSUPER;
END ComoBola;

PROCEDURE DecSuper(VAR p: Puntos);
BEGIN
    DEC(p^.contador);
END DecSuper;


PROCEDURE EstaSuper(VAR p: Puntos): BOOLEAN;
BEGIN
    RETURN (p^.contador > 0);
END EstaSuper;


PROCEDURE IncFrutas(VAR p:Puntos);
BEGIN
    INC(p^.frutas);
END IncFrutas;

PROCEDURE DecFrutas(VAR p:Puntos);
BEGIN
    DEC(p^.frutas);
END DecFrutas;


PROCEDURE QuedanFrutas(VAR p: Puntos): BOOLEAN;
BEGIN
    RETURN (p^.frutas > 0);

END QuedanFrutas;


PROCEDURE Destruir( VAR p : Puntos);
BEGIN
    DISPOSE(p);
END Destruir;

END scores.