IMPLEMENTATION MODULE fondo;
FROM Storage IMPORT ALLOCATE, DEALLOCATE;
IMPORT FIO, SYSTEM;
IMPORT Graph;

PROCEDURE Cargar(fich : ARRAY OF CHAR) : BMP;
VAR
  man : FIO.File;
  total, y : CARDINAL;
  byte1 : CHAR;
  cabeza : BitMapHeader;
  bitmap : BMP;
BEGIN
    IF FIO.Exists(fich) THEN
        man := FIO.Open(fich);
        total := FIO.RdBin(man, cabeza, SIZE(BitMapHeader));
        NEW(bitmap);
        bitmap^.x := INTEGER(cabeza.biWidth);
        bitmap^.y := INTEGER(cabeza.biHeight);
        FIO.Seek(man,LONGCARD(cabeza.bfOffbits));(*Coloco la lectura al pricipio de los datos*)
        FOR y := 0 TO CARDINAL(cabeza.biHeight) DO
               total:=FIO.RdBin(man,bitmap^.Color[y].Linea, CARDINAL(cabeza.biWidth));
        END;
        FIO.Close(man);
    END;
    RETURN bitmap;
END Cargar;

PROCEDURE CargaPaleta(fich : ARRAY OF CHAR): TipoPaleta;
VAR
  man : FIO.File;
  n, total : CARDINAL;
  byte1 : CHAR;
  paleta : TipoPaleta;
BEGIN
IF FIO.Exists(fich) THEN
    man := FIO.Open(fich);
    NEW(paleta);
    FIO.Seek(man,54);(*Se posiciona el cursor en el sitio para empezar a leer*)
    FOR n:=0 TO 255 DO
        total:=FIO.RdBin(man,paleta^[n].b,SIZE(CHAR));
        total:=FIO.RdBin(man,paleta^[n].g,SIZE(CHAR));
        total:=FIO.RdBin(man,paleta^[n].r,SIZE(CHAR));
        total:=FIO.RdBin(man,byte1,SIZE(CHAR));
        paleta^[n].r:=paleta^[n].r DIV 4;
        paleta^[n].g:=paleta^[n].g DIV 4;
        paleta^[n].b:=paleta^[n].b DIV 4;
    END;
END;
RETURN paleta;
END CargaPaleta;


PROCEDURE PonPaleta(paleta: TipoPaleta);
PROCEDURE Actualiza(color,R,G,B : SHORTCARD);
VAR
BEGIN
     SYSTEM.Out(968,color);
     SYSTEM.Out(969,R);
     SYSTEM.Out(969,G);
     SYSTEM.Out(969,B);
END Actualiza;
VAR n:CARDINAL;
BEGIN
    FOR n:=0 TO 255 DO
        Actualiza(SHORTCARD(n),paleta^[n].r,paleta^[n].g,paleta^[n].b);
    END;
END PonPaleta;


PROCEDURE DelPaleta(VAR p : TipoPaleta);
BEGIN
    DISPOSE(p);
END DelPaleta;


PROCEDURE Copia(VAR M1, M2 : BMP);
VAR
BEGIN
               M2^.Color := M1^.Color;
END Copia;


(* muevo de m1 a m2  un trozo como m3 *)
(* antes de mover algo, restauramos el fondo, que ocupaba *)
(* mas rapido que mover todo el fondo *)
PROCEDURE RestauraFondo(VAR M1, M2: BMP; x0,y0, x1, y1: INTEGER);
VAR
  x,y : INTEGER ;
BEGIN
      FOR x := x0 TO x1 DO
          FOR y := y0 TO y1 DO
                 IF ((x <= 320) AND (y <= 200) AND (x >=0) AND (y>=0)) THEN
                         M2^.Color[y].Linea[x] := M1^.Color[y].Linea[x];
                  END;
          END;
      END;
END RestauraFondo;

PROCEDURE Pinta(VAR Matriz: BMP);
VAR
  x,y : INTEGER;
BEGIN
      FOR y := 0 TO Matriz^.y DO
          FOR x := 0 TO Matriz^.x DO
               Graph.Plot(x, maxy-y, CARDINAL(Matriz^.Color[y].Linea[x]));
          END;
      END;
END Pinta;

PROCEDURE Destruir(VAR m : BMP);
BEGIN
    DISPOSE(m);
END Destruir;


END fondo.
