(* Jess Garca Pavn '02 *)

IMPLEMENTATION MODULE BITMAPS;

IMPORT Graph,FIO,visual;

TYPE
   MatrizBola = ARRAY [1..41],[1..41] OF BYTE;
   MatrizMarco = ARRAY [1..640] OF BYTE;
   MatrizNumero = ARRAY [1..27],[1..18] OF BYTE;
   MatrizFin = ARRAY [1..30],[1..170] OF BYTE;

VAR
   fich: FIO.File;
   bolaRoja,bolaCyan,bolaMora,bolaVerde,bolaGris: MatrizBola;
   cero,uno,dos,tres,cuatro,cinco,seis,siete,ocho,nueve: MatrizNumero;
   fin: MatrizFin;
   marco : MatrizMarco;
   leidos: CARDINAL;

PROCEDURE RestauraColoresBola(VAR m: MatrizBola);
VAR
   i,j: CARDINAL;
BEGIN
   i:=1;
   j:=1;
   FOR j:=1 TO 41 DO
      FOR i:=1 TO 41 DO
         IF m[i,j]=BYTE(1) THEN  (* Rojo Oscuro *)
            m[i,j]:=4;
         ELSIF m[i,j]=BYTE(3) THEN (* Verde Oscuro *)
            m[i,j]:=2;
         ELSIF m[i,j]=BYTE(6) THEN (* Cyan Oscuro *)
            m[i,j]:=3;
         ELSIF m[i,j]=BYTE(7) THEN (* Gris *)
            m[i,j]:=8;
         ELSIF m[i,j]=BYTE(17) THEN (* Rojo *)
            m[i,j]:=12;
         ELSIF m[i,j]=BYTE(19) THEN (* Verde *)
            m[i,j]:=10;
         ELSIF m[i,j]=BYTE(22) THEN (* Cyan *)
            m[i,j]:=11;
         ELSIF m[i,j]=BYTE(20) THEN (* Azul - transparente - *)
            m[i,j]:=9;
         ELSIF m[i,j]=BYTE(21) THEN (* Morao *)
            m[i,j]:=13;
         ELSIF m[i,j]=BYTE(255) THEN (* Blanco *)
            m[i,j]:=7;
         ELSIF m[i,j]=BYTE(4) THEN (* Azul *)
            m[i,j]:=1;
         END;
      END;
   END;
END RestauraColoresBola;

PROCEDURE RestauraColoresFin(VAR m: MatrizFin);
VAR
   i,j: CARDINAL;
BEGIN
   i:=1;
   j:=1;
   FOR j:=1 TO 170 DO
      FOR i:=1 TO 30 DO
         IF m[i,j]=BYTE(1) THEN  (* Rojo Oscuro *)
            m[i,j]:=4;
         ELSIF m[i,j]=BYTE(3) THEN (* Verde Oscuro *)
            m[i,j]:=2;
         ELSIF m[i,j]=BYTE(6) THEN (* Cyan Oscuro *)
            m[i,j]:=3;
         ELSIF m[i,j]=BYTE(7) THEN (* Gris *)
            m[i,j]:=8;
         ELSIF m[i,j]=BYTE(17) THEN (* Rojo *)
            m[i,j]:=12;
         ELSIF m[i,j]=BYTE(19) THEN (* Verde *)
            m[i,j]:=10;
         ELSIF m[i,j]=BYTE(22) THEN (* Cyan *)
            m[i,j]:=11;
         ELSIF m[i,j]=BYTE(20) THEN (* Azul - transparente - *)
            m[i,j]:=9;
         ELSIF m[i,j]=BYTE(21) THEN (* Morao *)
            m[i,j]:=13;
         ELSIF m[i,j]=BYTE(255) THEN (* Blanco *)
            m[i,j]:=7;
         ELSIF m[i,j]=BYTE(4) THEN (* Azul *)
            m[i,j]:=1;
         END;
      END;
   END;
END RestauraColoresFin;

PROCEDURE RestauraColoresNumero(VAR m: MatrizNumero);
VAR
   i,j: CARDINAL;
BEGIN
   i:=1;
   j:=1;
   FOR j:=1 TO 18 DO
      FOR i:=1 TO 27 DO
         IF m[i,j]=BYTE(1) THEN  (* Rojo Oscuro *)
            m[i,j]:=4;
         ELSIF m[i,j]=BYTE(3) THEN (* Verde Oscuro *)
            m[i,j]:=2;
         ELSIF m[i,j]=BYTE(6) THEN (* Cyan Oscuro *)
            m[i,j]:=3;
         ELSIF m[i,j]=BYTE(7) THEN (* Gris *)
            m[i,j]:=8;
         ELSIF m[i,j]=BYTE(17) THEN (* Rojo *)
            m[i,j]:=12;
         ELSIF m[i,j]=BYTE(19) THEN (* Verde *)
            m[i,j]:=10;
         ELSIF m[i,j]=BYTE(22) THEN (* Cyan *)
            m[i,j]:=11;
         ELSIF m[i,j]=BYTE(20) THEN (* Azul - transparente - *)
            m[i,j]:=9;
         ELSIF m[i,j]=BYTE(21) THEN (* Morao *)
            m[i,j]:=13;
         ELSIF m[i,j]=BYTE(255) THEN (* Blanco *)
            m[i,j]:=7;
         ELSIF m[i,j]=BYTE(4) THEN (* Azul *)
            m[i,j]:=1;
         END;
      END;
   END;
END RestauraColoresNumero;

PROCEDURE VuelcaMarco(VAR m: MatrizMarco; y: CARDINAL);
VAR
   i: CARDINAL;
BEGIN
   i:=1;
   FOR i:=1 TO 640 DO
      IF m[i]=BYTE(1) THEN  (* Rojo Oscuro *)
         m[i]:=4;
      ELSIF m[i]=BYTE(3) THEN (* Verde Oscuro *)
         m[i]:=2;
      ELSIF m[i]=BYTE(6) THEN (* Cyan Oscuro *)
         m[i]:=3;
      ELSIF m[i]=BYTE(7) THEN (* Gris *)
         m[i]:=8;
      ELSIF m[i]=BYTE(17) THEN (* Rojo *)
         m[i]:=12;
      ELSIF m[i]=BYTE(19) THEN (* Verde *)
         m[i]:=10;
      ELSIF m[i]=BYTE(22) THEN (* Cyan *)
         m[i]:=11;
      ELSIF m[i]=BYTE(20) THEN (* Azul - transparente - *)
         m[i]:=9;
      ELSIF m[i]=BYTE(21) THEN (* Morao *)
         m[i]:=13;
      ELSIF m[i]=BYTE(255) THEN (* Blanco *)
         m[i]:=7;
      ELSIF m[i]=BYTE(4) THEN (* Azul *)
         m[i]:=1;
      END;
      IF (m[i]<>BYTE(9)) THEN
         Graph.Plot(i-1,0+y,CARDINAL(m[i]));
      END;
   END;

END VuelcaMarco;

PROCEDURE VuelcaBola(m: MatrizBola;x,y:CARDINAL);
VAR
   i,j: CARDINAL;
BEGIN
   FOR j:=1 TO 41 DO
      FOR i:=1 TO 41 DO
         IF (m[i,j]<>BYTE(9)) THEN
            Graph.Plot(i+x,j+y,CARDINAL(m[i,j]));
         END;
      END;
   END;
END VuelcaBola;

PROCEDURE VuelcaFin(m: MatrizFin;x,y:CARDINAL);
VAR
   i,j: CARDINAL;
BEGIN
   FOR j:=1 TO 170 DO
      FOR i:=1 TO 30 DO
         IF (m[i,j]<>BYTE(9)) THEN
            Graph.Plot(j+y,i+x,CARDINAL(m[i,j]));
         END;
      END;
   END;
END VuelcaFin;

PROCEDURE DibujaFin(x,y:CARDINAL);
BEGIN
   VuelcaFin(fin,x,y);
END DibujaFin;

PROCEDURE VuelcaNumero(m: MatrizNumero;x,y:CARDINAL);
VAR
   i,j: CARDINAL;
BEGIN
   FOR j:=1 TO 18 DO
      FOR i:=1 TO 27 DO
         IF (m[i,j]<>BYTE(9)) THEN
            Graph.Plot(j+y,i+x,CARDINAL(m[i,j]));
         END;
      END;
   END;
END VuelcaNumero;

PROCEDURE DibujaNumero(c: CHAR;x,y:CARDINAL);
BEGIN
   IF c='0' THEN
      VuelcaNumero(cero,x,y);
   ELSIF c='1' THEN
      VuelcaNumero(uno,x,y);
   ELSIF c='2' THEN
      VuelcaNumero(dos,x,y);
   ELSIF c='3' THEN
      VuelcaNumero(tres,x,y);
   ELSIF c='4' THEN
      VuelcaNumero(cuatro,x,y);
   ELSIF c='5' THEN
      VuelcaNumero(cinco,x,y);
   ELSIF c='6' THEN
      VuelcaNumero(seis,x,y);
   ELSIF c='7' THEN
      VuelcaNumero(siete,x,y);
   ELSIF c='8' THEN
      VuelcaNumero(ocho,x,y);
   ELSIF c='9' THEN
      VuelcaNumero(nueve,x,y);
   END;
END DibujaNumero;

PROCEDURE DibujaMarco;
VAR
   j: CARDINAL;
   m: MatrizMarco;
   f: FIO.File;
   l: CARDINAL;
BEGIN
   f:=FIO.OpenRead("marco.raw");
   FOR j:=0 TO 479 DO
      l:=FIO.RdBin(fich,marco,640);
      VuelcaMarco(marco,j);
   END;
   FIO.Close(fich);
END DibujaMarco;

PROCEDURE DibujaMenu;
VAR
   j: CARDINAL;
   m: MatrizMarco;
   f: FIO.File;
   l: CARDINAL;
BEGIN
   f:=FIO.OpenRead("menu.raw");
   FOR j:=0 TO 479 DO
      l:=FIO.RdBin(fich,marco,640);
      VuelcaMarco(marco,j);
   END;
   FIO.Close(fich);
END DibujaMenu;

PROCEDURE DibujaBola(x,y,color: CARDINAL);
BEGIN
   IF color=14 THEN (* Cyan *)
      VuelcaBola(bolaCyan,x-20,y-20);
   ELSIF color=2 THEN (* Verde *)
      VuelcaBola(bolaVerde,x-20,y-20);
   ELSIF color=4 THEN (* Rojo *)
      VuelcaBola(bolaRoja,x-20,y-20);
   ELSIF color=5 THEN (* Morao *)
      VuelcaBola(bolaMora,x-20,y-20);
   ELSIF color=8 THEN (* Gris *)
      VuelcaBola(bolaGris,x-20,y-20);
   ELSE
      Graph.TrueDisc(x,y,22,color);
   END;
END DibujaBola;



BEGIN
   fich:=FIO.OpenRead("rojo.raw");
   leidos:=FIO.RdBin(fich,bolaRoja,1681);
   FIO.Close(fich);

   fich:=FIO.OpenRead("cyan.raw");
   leidos:=FIO.RdBin(fich,bolaCyan,1681);
   FIO.Close(fich);

   fich:=FIO.OpenRead("verde.raw");
   leidos:=FIO.RdBin(fich,bolaVerde,1681);
   FIO.Close(fich);

   fich:=FIO.OpenRead("morao.raw");
   leidos:=FIO.RdBin(fich,bolaMora,1681);
   FIO.Close(fich);

   fich:=FIO.OpenRead("gris.raw");
   leidos:=FIO.RdBin(fich,bolaGris,1681);
   FIO.Close(fich);

   fich:=FIO.OpenRead("0.raw");
   leidos:=FIO.RdBin(fich,cero,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("1.raw");
   leidos:=FIO.RdBin(fich,uno,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("2.raw");
   leidos:=FIO.RdBin(fich,dos,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("3.raw");
   leidos:=FIO.RdBin(fich,tres,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("4.raw");
   leidos:=FIO.RdBin(fich,cuatro,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("5.raw");
   leidos:=FIO.RdBin(fich,cinco,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("6.raw");
   leidos:=FIO.RdBin(fich,seis,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("7.raw");
   leidos:=FIO.RdBin(fich,siete,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("8.raw");
   leidos:=FIO.RdBin(fich,ocho,486);
   FIO.Close(fich);
   fich:=FIO.OpenRead("9.raw");
   leidos:=FIO.RdBin(fich,nueve,486);
   FIO.Close(fich);

   fich:=FIO.OpenRead("fin.raw");
   leidos:=FIO.RdBin(fich,fin,5100);
   FIO.Close(fich);

   RestauraColoresBola(bolaRoja);
   RestauraColoresBola(bolaCyan);
   RestauraColoresBola(bolaMora);
   RestauraColoresBola(bolaVerde);
   RestauraColoresBola(bolaGris);

   RestauraColoresNumero(cero);
   RestauraColoresNumero(uno);
   RestauraColoresNumero(dos);
   RestauraColoresNumero(tres);
   RestauraColoresNumero(cuatro);
   RestauraColoresNumero(cinco);
   RestauraColoresNumero(seis);
   RestauraColoresNumero(siete);
   RestauraColoresNumero(ocho);
   RestauraColoresNumero(nueve);

   RestauraColoresFin(fin);

END BITMAPS.