(* Jess Garca Pavn '02 *)

IMPLEMENTATION MODULE bola;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM Lib IMPORT Delay;
IMPORT visual;
FROM tablero IMPORT Tablero,InsertaBola,CalculaCasilla,Ocupada,CalculaLinea;

TYPE
   Nodo = RECORD
             x,y,color: CARDINAL;
          END;
   Bola = POINTER TO Nodo;

(* Crea e inicializa la bola (x,y de pantalla) *)
PROCEDURE CreaBola(VAR b:Bola; c:CARDINAL);
BEGIN
   NEW(b);
   b^.x:=320;
   b^.y:=450;
   b^.color:=c;
END CreaBola;

(* Muestra una bola (x,y de pantalla) *)
PROCEDURE DibujaBola(b:Bola);
BEGIN
   visual.DibujaBola(b^.x,b^.y,b^.color);
END DibujaBola;

(* Borra una bola de la pantalla *)
PROCEDURE BorraBola(b:Bola);
BEGIN
   visual.DibujaBola(b^.x,b^.y,0);
END BorraBola;

(* Mueve la bola con incrementos x,y, calcula choques e inserta en tablero *)
(* RETURN # de bolas eliminadas *)
PROCEDURE TiraBola(VAR b:Bola;x,y:INTEGER;VAR t: Tablero):CARDINAL;
VAR
   xt,yt: INTEGER;
   fila,columna,filaT,columnaT: CARDINAL;
   posible: BOOLEAN;
   numero: CARDINAL;
BEGIN
   posible:=TRUE;
   xt:=x;
   yt:=y;
   CalculaCasilla(b^.x,b^.y,columna,fila);
   filaT:=fila;
   columnaT:=columna;

   WHILE posible DO
      BorraBola(b);
      IF (b^.x<180) OR (b^.x>480) THEN     (* 460 *)
         xt:=xt*(-1);
      END;
      b^.x:=CARDINAL(INTEGER(b^.x)+xt);
      b^.y:=CARDINAL(INTEGER(b^.y)+yt);
      CalculaCasilla(b^.x,b^.y,columna,fila);

      IF (fila>9) OR NOT(Ocupada(columna,fila,t)) THEN
         IF fila=0 THEN
            posible:=FALSE;
         END;
         columnaT:=columna;
         filaT:=fila;
         DibujaBola(b);
      ELSE
         posible:=FALSE;
      END;
      Delay(5);

   END;
   BorraBola(b);
   InsertaBola(columnaT,filaT,b^.color,t);
   numero:=CalculaLinea(columnaT,filaT,t);
   RETURN(numero);
END TiraBola;

PROCEDURE DestruyeBola(VAR b:Bola);
BEGIN
   DISPOSE(b);
END DestruyeBola;

END bola.