(* Jess Garca Pavn '02 *)

MODULE EDITOR;

IMPORT IO,FIO,visual,Graph,tablero;

TYPE
   Nombre = ARRAY [1..11] OF CHAR;

PROCEDURE DibujaMatriz;
VAR
   i,j,y,x: CARDINAL;
BEGIN
   y:=50;
   visual.DibujaLaterales(158,500,9);

   FOR i:=1 TO 9 DO
      Graph.Line(158,y,500,y,8);
      IF ((i MOD 2)=0) THEN
         x:=178;
      ELSE
         x:=199;
      END;
      FOR j:=1 TO 8 DO
         Graph.Line(x,y-40,x,y,8);
         x:=x+40;
      END;
      y:=y+40;
   END;
   Graph.Line(158,y,500,y,12);
END DibujaMatriz;

PROCEDURE DibujaMenu;
VAR
   basura: Graph.TextCoords;
   basura2: CARDINAL;
BEGIN
   visual.DibujaBola(82,200,14);
   visual.DibujaBola(82,250,2);
   visual.DibujaBola(82,300,4);
   visual.DibujaBola(82,350,5);
   visual.DibujaBola(82,400,8);
   basura:=Graph.SetTextPosition(13,11);
   basura2:=Graph.SetTextColor(7);
   Graph.OutText("Z");
   basura:=Graph.SetTextPosition(16,11);
   basura2:=Graph.SetTextColor(7);
   Graph.OutText("X");
   basura:=Graph.SetTextPosition(19,11);
   basura2:=Graph.SetTextColor(7);
   Graph.OutText("C");
   basura:=Graph.SetTextPosition(22,11);
   basura2:=Graph.SetTextColor(7);
   Graph.OutText("V");
   basura:=Graph.SetTextPosition(25,11);
   basura2:=Graph.SetTextColor(7);
   Graph.OutText("B");

END DibujaMenu;

VAR
   tecla: CHAR;
   tab: tablero.Tablero;
   x,y: CARDINAL;
   nombre: Nombre;
   fich: FIO.File;
BEGIN
   IO.WrStr("Introduce el nombre del fichero: ");
   IO.RdStr(nombre);

   fich:=FIO.Create(nombre);

   tablero.CreaTablero(tab);

   visual.Abre();

   DibujaMatriz();
   DibujaMenu();

   FOR y:=0 TO 9 DO
      FOR x:=1 TO 8 DO
         tecla:=IO.RdKey();
         IF tecla='z' THEN
            tablero.InsertaBola(x,y,14,tab);
            FIO.WrChar(fich,'A');
         ELSIF tecla='x' THEN
            tablero.InsertaBola(x,y,2,tab);
            FIO.WrChar(fich,'V');
         ELSIF tecla='c' THEN
            tablero.InsertaBola(x,y,4,tab);
            FIO.WrChar(fich,'R');
         ELSIF tecla='v' THEN
            tablero.InsertaBola(x,y,5,tab);
            FIO.WrChar(fich,'M');
         ELSIF tecla='b' THEN
            tablero.InsertaBola(x,y,8,tab);
            FIO.WrChar(fich,'G');
         ELSE
            tablero.InsertaBola(x,y,6,tab);
            FIO.WrChar(fich,'X');
         END;
         tablero.DibujaTablero(tab);
         DibujaMatriz();
      END;
   END;

   visual.Cierra();
   FIO.WrChar(fich,'F');
   FIO.Close(fich);

   tablero.DestruyeTablero(tab);
END EDITOR.