(* Jess Garca Pavn '02 *)

IMPLEMENTATION MODULE marcador;
FROM Graph IMPORT SetTextColor,SetTextPosition,OutText,TextCoords;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
IMPORT FIO,BITMAPS;

TYPE
   TCadena = ARRAY [1..6] OF CHAR;
   Puntos= RECORD
              cadena: TCadena;
              numero: LONGCARD;
           END;
   Marcador=POINTER TO Puntos;

VAR
   maximo: LONGCARD; (* Variable global del record de partida *)
   superado: BOOLEAN; (* Cambia el color del record *)

PROCEDURE Convierte(numero: LONGCARD):TCadena;
VAR
   i:CARDINAL;
   cadena: TCadena;
BEGIN
   FOR i:=1 TO 6 DO
      cadena[i]:='0';
   END;
   i:=6;
   WHILE (numero<>0) AND (i<>0) DO
      cadena[i]:=CHAR((numero MOD 10)+48);
      numero:=numero DIV 10;
      DEC(i);
   END;
   RETURN(cadena);
END Convierte;

PROCEDURE CreaMarcador(VAR m: Marcador);
VAR
   i:CARDINAL;
BEGIN
   NEW(m);
   FOR i:=1 TO 6 DO
      m^.cadena[i]:='0';
   END;
   m^.numero:=0;
   superado:=FALSE;
END CreaMarcador;

PROCEDURE MuestraMarcador(m: Marcador);
VAR
   x,y,i: CARDINAL;
   temp: TCadena;
BEGIN

   temp:=Convierte(maximo);
   x:=23;
   y:=140;
   FOR i:=1 TO 6 DO
      BITMAPS.DibujaNumero(temp[i],y,x);
      x:=x+18;
   END;

   x:=23;
   y:=255;
   FOR i:=1 TO 6 DO
      BITMAPS.DibujaNumero(m^.cadena[i],y,x);
      x:=x+18;
   END;
END MuestraMarcador;

PROCEDURE GuardaRecord();
VAR
   fichero: FIO.File;
BEGIN
   fichero:=FIO.Create("RECORD.DAT");
   FIO.WrLngCard(fichero,maximo,0);
   FIO.Close(fichero);
END GuardaRecord;

PROCEDURE CargaRecord();
VAR
   fichero: FIO.File;
BEGIN
   fichero:=FIO.Open("RECORD.DAT");
   maximo:=FIO.RdLngCard(fichero);
   FIO.Close(fichero);
END CargaRecord;


(* Suma al marcador puntos *)
PROCEDURE Puntua(VAR m: Marcador;puntos:CARDINAL);
BEGIN
   m^.numero:=m^.numero+LONGCARD(puntos);
   IF m^.numero>maximo THEN
      superado:=TRUE;
      maximo:=m^.numero;
      GuardaRecord();
   END;
   m^.cadena:=Convierte(m^.numero);
END Puntua;

PROCEDURE DestruyeMarcador(VAR m: Marcador);
BEGIN
   DISPOSE(m);
END DestruyeMarcador;

BEGIN
   CargaRecord();
   superado:=FALSE;

END marcador.