(* Jess Garca Pavn '02 *)

IMPLEMENTATION MODULE mira;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM MATHLIB IMPORT Sin,Cos;
IMPORT Graph;

TYPE
   Nodo = RECORD
             color: CARDINAL;
             angulo: LONGREAL; (* En grados, -90 arriba, 0 dr, -180 iz *)
          END;
   Mira = POINTER TO Nodo;

CONST
   radio=50.0; (* Dsde centro a extremo de la mira *)
   PI=3.1415927;
   desplz=5.0; (* Incremento en grados del ngulo de la mira *)

(* Crea una mira con ngulo -90 (arriba) *)
PROCEDURE CreaMira(VAR m:Mira;c:CARDINAL);
BEGIN
   NEW(m);
   m^.color:=c;
   m^.angulo:=-90.0;
END CreaMira;

(* Pinta una mira *)
PROCEDURE DibujaMira(m:Mira);
VAR
  x,y:CARDINAL;
  xt,yt,radianes: LONGREAL;
BEGIN
   radianes:=(m^.angulo/180.0)*PI; (* Transforma grados en radianes *)
   xt:=radio*Cos(radianes);        (* Calcula x,y del extremo *)
   yt:=radio*Sin(radianes);
   xt:=xt+320.0;                   (* Compensa con la pos del centro *)
   yt:=yt+450.0;
   x:=CARDINAL(xt);
   y:=CARDINAL(yt);
   Graph.Line(320,450,x,y,m^.color);
END DibujaMira;

(* Calcula el incremento de x,y segn el ngulo de la mira *)
PROCEDURE CalculaTiro(m:Mira;VAR x,y:INTEGER);
VAR
   radianes: LONGREAL;
BEGIN
   radianes:=(m^.angulo/180.0)*PI;
   x:=INTEGER(12.0*Cos(radianes));
   y:=INTEGER(12.0*Sin(radianes))+1;
END CalculaTiro;

(* Borra una mira de la pantalla *)
PROCEDURE BorraMira(m:Mira);
VAR
  x,y:CARDINAL;
  xt,yt,radianes: LONGREAL;
BEGIN
   radianes:=(m^.angulo/180.0)*PI;
   xt:=radio*Cos(radianes);
   yt:=radio*Sin(radianes);
   xt:=xt+320.0;
   yt:=yt+450.0;
   x:=CARDINAL(xt);
   y:=CARDINAL(yt);
   Graph.Line(320,450,x,y,0);
END BorraMira;

(* Borra,gira a la derecha y pinta la mira *)
PROCEDURE MueveMiraDr(VAR m:Mira);
BEGIN
   IF m^.angulo<(-15.0) THEN
      BorraMira(m);
      m^.angulo:=m^.angulo+desplz;
      DibujaMira(m);
   END;
END MueveMiraDr;

(* Borra,gira a la izquierda y pinta la mira *)
PROCEDURE MueveMiraIz(VAR m:Mira);
BEGIN
   IF m^.angulo>(-165.0) THEN
      BorraMira(m);
      m^.angulo:=m^.angulo-desplz;
      DibujaMira(m);
   END;
END MueveMiraIz;

PROCEDURE DestruyeMira(VAR m:Mira);
BEGIN
   DISPOSE(m);
END DestruyeMira;

END mira.