(* Jess Garca Pavn '02 *)

MODULE puzzle;

FROM Lib IMPORT RANDOM;
IMPORT tablero,visual,mira,marcador,bola,IO,Window,BITMAPS;

CONST
   NUMCOLORES=4;
   NUMNIVELES=9;

TYPE
   TablaColores = ARRAY [0..NUMCOLORES] OF CARDINAL;
   Nombre = ARRAY [1..11] OF CHAR;
   TablaNiveles = ARRAY [1..NUMNIVELES] OF Nombre;

PROCEDURE InicializaColores(VAR c: TablaColores);
BEGIN
   c[0]:=14;
   c[1]:=2;
   c[2]:=4;
   c[3]:=5;
END InicializaColores;

PROCEDURE InicializaNiveles(VAR n: TablaNiveles);
BEGIN
   n[1]:="NIVEL01.PZZ";
   n[2]:="NIVEL02.PZZ";
   n[3]:="NIVEL03.PZZ";
   n[4]:="NIVEL04.PZZ";
   n[5]:="NIVEL05.PZZ";
   n[6]:="NIVEL06.PZZ";
   n[7]:="NIVEL07.PZZ";
   n[8]:="NIVEL08.PZZ";
   n[9]:="NIVEL09.PZZ";
END InicializaNiveles;

PROCEDURE EligeColor(VAR act,sig: CARDINAL;col: TablaColores);
BEGIN
   act:=sig;
   sig:=col[RANDOM(NUMCOLORES)];
END EligeColor;



PROCEDURE CargaNivel(VAR tab: tablero.Tablero;
                         niveles: TablaNiveles;VAR act: CARDINAL);
BEGIN
   tablero.CargaTablero(tab,niveles[act]);
   INC(act);
   IF act>NUMNIVELES THEN
      act:=1;
   END;
END CargaNivel;

PROCEDURE FinalizaPartida(VAR tab: tablero.Tablero; VAR mir: mira.Mira;
                              VAR marc: marcador.Marcador);
BEGIN
   tablero.DestruyeTablero(tab);
   mira.DestruyeMira(mir);
   marcador.DestruyeMarcador(marc);
END FinalizaPartida;

PROCEDURE DibujaNext(color: CARDINAL);
BEGIN
   visual.DibujaBola(82,380,color);
END DibujaNext;

PROCEDURE DibujaNivel(niv: CARDINAL);
VAR
   x,y: CARDINAL;
   n: CARDINAL;
BEGIN
   n:=niv;
   IF n=0 THEN
      n:=NUMNIVELES;
   END;
   x:=558;
   y:=215;
   IF n=0 THEN
      BITMAPS.DibujaNumero('0',y,x);
   ELSIF n=1 THEN
      BITMAPS.DibujaNumero('1',y,x);
   ELSIF n=2 THEN
      BITMAPS.DibujaNumero('2',y,x);
   ELSIF n=3 THEN
      BITMAPS.DibujaNumero('3',y,x);
   ELSIF n=4 THEN
      BITMAPS.DibujaNumero('4',y,x);
   ELSIF n=5 THEN
      BITMAPS.DibujaNumero('5',y,x);
   ELSIF n=6 THEN
      BITMAPS.DibujaNumero('6',y,x);
   ELSIF n=7 THEN
      BITMAPS.DibujaNumero('7',y,x);
   ELSIF n=8 THEN
      BITMAPS.DibujaNumero('8',y,x);
   ELSIF n=9 THEN
      BITMAPS.DibujaNumero('9',y,x);
   END;
END DibujaNivel;

VAR
   tab: tablero.Tablero;
   mir: mira.Mira;
   marc: marcador.Marcador;
   colores: TablaColores;
   siguienteColor,colorActual: CARDINAL;
   niveles: TablaNiveles;
   nivelActual: CARDINAL;
   bol: bola.Bola;
   tecla: CHAR;
   perdido,ganado: BOOLEAN;
   x,y: INTEGER;
   fin: BOOLEAN;

BEGIN
   fin:=FALSE;
   visual.Abre();

   WHILE (NOT(fin)) DO

      BITMAPS.DibujaMenu();
      tecla:=IO.RdKey();
      IF tecla='j' THEN
         visual.BorraPantalla();

         (*-------------- Nueva Partida --------*)
         tablero.CreaTablero(tab);
         mira.CreaMira(mir,14);
         marcador.CreaMarcador(marc);
         InicializaColores(colores);
         siguienteColor:=colores[RANDOM(NUMCOLORES)];
         EligeColor(colorActual,siguienteColor,colores);
         InicializaNiveles(niveles);
         nivelActual:=1;
         perdido:=FALSE;
         ganado:=FALSE;

         bola.CreaBola(bol,colorActual);
         CargaNivel(tab,niveles,nivelActual);

         tablero.DibujaTablero(tab);
         marcador.MuestraMarcador(marc);
         mira.DibujaMira(mir);
         bola.DibujaBola(bol);
         DibujaNext(siguienteColor);
         BITMAPS.DibujaMarco();
         DibujaNivel(nivelActual-1);

         WHILE ((tecla<>'s') AND (NOT(perdido))) DO

            tecla:=IO.RdKey();

            IF tecla='m' THEN
               mira.MueveMiraDr(mir);
               bola.DibujaBola(bol);
            ELSIF tecla='n' THEN
               mira.MueveMiraIz(mir);
               bola.DibujaBola(bol);
            ELSIF tecla='b' THEN
               mira.CalculaTiro(mir,x,y);
               marcador.Puntua(marc,bola.TiraBola(bol,x,y,tab));
               marcador.Puntua(marc,tablero.CalculaCaida(tab));
               Window.Clear();
               mira.DibujaMira(mir);
               bola.BorraBola(bol);
               bola.DestruyeBola(bol);
               EligeColor(colorActual,siguienteColor,colores);
               bola.CreaBola(bol,colorActual);
               bola.DibujaBola(bol);
               DibujaNext(siguienteColor);
               IF tablero.JuegoPerdido(tab) THEN
                  tablero.DibujaTableroPerdido(tab);
                  BITMAPS.DibujaMarco();
                  DibujaNivel(nivelActual-1);
                  BITMAPS.DibujaFin(150,242);
                  perdido:=TRUE;
               END;
               IF tablero.JuegoGanado(tab) THEN
                  Window.Clear();

                  CargaNivel(tab,niveles,nivelActual);
                  DibujaNivel(nivelActual-1);
                  BITMAPS.DibujaMarco();
                  marcador.MuestraMarcador(marc);
                  mira.DibujaMira(mir);
                  EligeColor(colorActual,siguienteColor,colores);
                  bola.DestruyeBola(bol);
                  bola.CreaBola(bol,colorActual);
                  bola.DibujaBola(bol);
                  DibujaNext(siguienteColor);
               END;
               IF NOT(perdido) THEN
                  tablero.DibujaTablero(tab);
               END;
               BITMAPS.DibujaMarco();
               marcador.MuestraMarcador(marc);
            END; (*IF tecla*)
         END; (*WHILE*)

         IF perdido THEN
            tecla:=IO.RdKey();
         END;

         bola.DestruyeBola(bol);

         FinalizaPartida(tab,mir,marc);
         (*-------- Fin de partida ------------*)
      ELSIF tecla='s' THEN  (* IF jugar *)
         fin:=TRUE;
      END;
   END; (* WHILE Menu *)
   visual.Cierra();
END puzzle.