(* Jess Garca Pavn '02 *);

IMPLEMENTATION MODULE tablero;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM visual IMPORT DibujaBola;
FROM Lib IMPORT Delay;
IMPORT FIO;

TYPE

(* Tipo Tablero, almacena las bolas ya colocadas *)
Casilla = RECORD
             ocupada: BOOLEAN;
             color: CARDINAL;
             marcada: BOOLEAN;
          END;
Columna = ARRAY [0..9] OF Casilla;
Cuadricula = ARRAY [1..8] OF Columna;
Tablero = POINTER TO Cuadricula;

(* Tipo Trans interno, transforma x,y de pantalla a tablero *)
CasillaTrans = RECORD
                  x1,y1,x2,y2: CARDINAL;
               END;
ColumnaTrans = ARRAY [0..9] OF CasillaTrans;
Trans = ARRAY [1..8] OF ColumnaTrans;

(* Tipo Bajada, ayuda a la animacin de caida *)
CasillaBajada = RECORD
                   x,y,color:CARDINAL;
                END;
Bajada = ARRAY [1..80] OF CasillaBajada;

VAR
(* Variable global de transformacin de pantalla a tablero *)
   tr: Trans;

(* Variable global de posiciones para el Backtracking *)
   mov_px,mov_py,mov_ix,mov_iy : ARRAY [1..6] OF INTEGER;

(* Variable global de recuento de Backtracking *)
   recuento: CARDINAL;

(* Inicializa la variable global del Backtracking *)
PROCEDURE PosiblesDirecciones;
BEGIN
   mov_px[1]:=0; mov_py[1]:=-1;
   mov_px[2]:=1; mov_py[2]:=0;
   mov_px[3]:=0; mov_py[3]:=1;
   mov_px[4]:=-1; mov_py[4]:=1;
   mov_px[5]:=-1; mov_py[5]:=0;
   mov_px[6]:=-1; mov_py[6]:=-1;

   mov_ix[1]:=0; mov_iy[1]:=-1;
   mov_ix[2]:=1; mov_iy[2]:=-1;
   mov_ix[3]:=1; mov_iy[3]:=0;
   mov_ix[4]:=1; mov_iy[4]:=1;
   mov_ix[5]:=0; mov_iy[5]:=1;
   mov_ix[6]:=-1; mov_iy[6]:=0;
END PosiblesDirecciones;

(* Hace el clculo para la transformacin de pantalla a tablero *)
PROCEDURE InicializaTrans();
VAR
   i,j: CARDINAL;
BEGIN
   FOR i:=1 TO 8 DO
      FOR j:=0 TO 9 DO
         IF (((j+1) MOD 2)<>0) THEN
            tr[i,j].x1:=(i-1)*40+160;
            tr[i,j].x2:=tr[i,j].x1+40;
         ELSE
            tr[i,j].x1:=(i-1)*40+180;
            tr[i,j].x2:=tr[i,j].x1+40;
         END;
         tr[i,j].y1:=j*40+10;
         tr[i,j].y2:=tr[i,j].y1+40;
      END;
   END;
END InicializaTrans;

(* Determina en que pos de tablero se encuentra una bola con x,y de pantalla *)
PROCEDURE CalculaCasilla(x,y: CARDINAL;VAR columna,fila: CARDINAL);
VAR
   i,j: CARDINAL;
BEGIN
   i:=1;
   j:=0;

   WHILE (j<=9) AND (y>tr[i,j].y2) DO
      j:=j+1;
   END;
   IF (j<=9) THEN
      WHILE x>tr[i,j].x2 DO
         i:=i+1;
      END;
   END;

   columna:=i;
   fila:=j;

END CalculaCasilla;

(* Crea e inicializa el tablero *)
PROCEDURE CreaTablero(VAR t:Tablero);
VAR
   x,y:CARDINAL;
BEGIN
   NEW(t);
   FOR x:=1 TO 8 DO
      FOR y:=0 TO 9 DO
         t^[x,y].ocupada:=FALSE;
         t^[x,y].marcada:=FALSE;
      END;
   END;
END CreaTablero;

(* Aade una bola al tablero. x e y relativas a tablero *)
PROCEDURE InsertaBola(x,y,color:CARDINAL; VAR t:Tablero);
BEGIN
   t^[x,y].ocupada:=TRUE;
   t^[x,y].marcada:=FALSE;
   t^[x,y].color:=color;
END InsertaBola;

(* Transforma x e y de tablero a pantalla *)
PROCEDURE CalculaPosicion(tx,ty:CARDINAL;VAR px,py:CARDINAL);
BEGIN
   py:=(ty*40)+30;
   IF ((ty+1)MOD 2)<>0 THEN
      px:=((tx-1)*40)+180;
   ELSE
      px:=((tx-1)*40)+200;
   END;
END CalculaPosicion;

(* Muestra el tablero *)
PROCEDURE DibujaTablero(t:Tablero);
VAR
   tx,ty,px,py:CARDINAL;
BEGIN
   FOR ty:=0 TO 9 DO
      FOR tx:=1 TO 8 DO
         IF t^[tx,ty].ocupada THEN
            CalculaPosicion(tx,ty,px,py);
            DibujaBola(px,py,t^[tx,ty].color);
         END;
      END;
   END;
END DibujaTablero;

PROCEDURE DestruyeTablero(VAR t:Tablero);
BEGIN
   DISPOSE(t);
END DestruyeTablero;

(* Hay bola en la casilla x,y del tablero? *)
PROCEDURE Ocupada(x,y:CARDINAL;t:Tablero):BOOLEAN;
BEGIN
   RETURN(t^[x,y].ocupada);
END Ocupada;

(* Hay bola en la primera fila? *)
PROCEDURE JuegoGanado(t: Tablero):BOOLEAN;
VAR
   ocupada:BOOLEAN;
   i:CARDINAL;
BEGIN
   ocupada:=FALSE;
   FOR i:=1 TO 8 DO
      IF t^[i,0].ocupada THEN
         ocupada:=TRUE;
      END;
   END;
   RETURN(NOT(ocupada));
END JuegoGanado;

(* Hay bola en la ltima fila? *)
PROCEDURE JuegoPerdido(t: Tablero):BOOLEAN;
VAR
   ocupada:BOOLEAN;
   i:CARDINAL;
BEGIN
   ocupada:=FALSE;
   FOR i:=1 TO 8 DO
      IF t^[i,9].ocupada THEN
         ocupada:=TRUE;
      END;
   END;
   RETURN(ocupada);
END JuegoPerdido;

(* Dibuja el tablero con todas las bolas en gris *)
PROCEDURE DibujaTableroPerdido(t:Tablero);
VAR
   tx,ty,px,py:CARDINAL;
BEGIN
   FOR ty:=0 TO 9 DO
      FOR tx:=1 TO 8 DO
         IF t^[tx,ty].ocupada THEN
            CalculaPosicion(tx,ty,px,py);
            DibujaBola(px,py,8);
         END;
      END;
   END;
END DibujaTableroPerdido;

(* Desmarca todas las casillas del tablero *)
PROCEDURE LimpiaMarcas(VAR t:Tablero);
VAR
   x,y:CARDINAL;
BEGIN
   FOR x:=1 TO 8 DO
      FOR y:=0 TO 9 DO
         t^[x,y].marcada:=FALSE;
      END;
   END;
END LimpiaMarcas;

(* Elimina del tablero las bolas marcadas *)
PROCEDURE LimpiaTablero(VAR t:Tablero);
VAR
   x,y:CARDINAL;
   x2,y2: CARDINAL;
BEGIN

   FOR x:=1 TO 8 DO
      FOR y:=0 TO 9 DO
         IF t^[x,y].marcada THEN
            CalculaPosicion(x,y,x2,y2);
            DibujaBola(x2,y2,7);
         END;
      END;
   END;
   Delay(100);
   FOR x:=1 TO 8 DO
      FOR y:=0 TO 9 DO
         IF t^[x,y].marcada THEN
            t^[x,y].ocupada:=FALSE;
            t^[x,y].marcada:=FALSE;
            CalculaPosicion(x,y,x2,y2);
            DibujaBola(x2,y2,0);
         END;
      END;
   END;
END LimpiaTablero;

(* Ayuda al siguiente procedimiento *)
PROCEDURE BacktrackingLinea(x,y,c,etapa: CARDINAL;VAR t:Tablero);
VAR
   orden,u,v: CARDINAL;
BEGIN
   orden:=0;
   REPEAT
      INC(orden);
      IF (((y+1)MOD 2)<>0) THEN  (* Fila par *)
         u:=CARDINAL(INTEGER(x)+mov_px[orden]);
         v:=CARDINAL(INTEGER(y)+mov_py[orden]);
      ELSE
         u:=CARDINAL(INTEGER(x)+mov_ix[orden]);
         v:=CARDINAL(INTEGER(y)+mov_iy[orden]);
      END;
      IF (1<=u) AND (u<=8) AND (0<=v) AND (v<=9) AND
         (t^[u,v].ocupada=TRUE) AND (t^[u,v].color=c) AND
         (t^[u,v].marcada=FALSE) THEN
         t^[u,v].marcada:=TRUE;
         INC(recuento);
         BacktrackingLinea(u,v,c,etapa+1,t);
      END;
   UNTIL (orden=6);
END BacktrackingLinea;

(* Calcula si la bola que esta en x,y hace linea (tres o ms mismo color) *)
(* RETURN # de bolas borradas *)
PROCEDURE CalculaLinea(x,y: CARDINAL;VAR t:Tablero):CARDINAL;
VAR
   c:CARDINAL;
BEGIN
   c:=t^[x,y].color;
   t^[x,y].marcada:=TRUE;
   recuento:=1;

   BacktrackingLinea(x,y,c,0,t);
   IF (recuento>=3) THEN
      LimpiaTablero(t);
   ELSE
      recuento:=0;
   END;
   LimpiaMarcas(t);
   RETURN(recuento);
END CalculaLinea;

PROCEDURE Baja(VAR t:Tablero):CARDINAL;
VAR
   x,y,i,j,limite: CARDINAL;
   b: Bajada;
BEGIN
   (* Salva las bolas no marcadas en el ARRAY b *)
   limite:=0;
   FOR y:=0 TO 9 DO
      FOR x:=1 TO 8 DO
         IF t^[x,y].ocupada AND NOT(t^[x,y].marcada) THEN
            INC(limite);
            b[limite].color:=t^[x,y].color;
            CalculaPosicion(x,y,b[limite].x,b[limite].y);
            t^[x,y].ocupada:=FALSE;
            t^[x,y].marcada:=FALSE;
         END;
      END;
   END;
   LimpiaMarcas(t);

   (* Animacion *)
   IF limite>0 THEN
      FOR i:=1 TO 50 DO     (* -------------- Num. Iteraciones *)
         FOR j:=1 TO limite DO
            DibujaBola(b[j].x,b[j].y,0);
         END;
         FOR j:=1 TO limite DO
            b[j].y:=b[j].y+10;       (* --------- Vel. bajada *)
            DibujaBola(b[j].x,b[j].y,b[j].color);
         END;
      END;
   END;
   RETURN(limite);
END Baja;

(* Marca todas las bolas que no han de caer *)
(* RETURN # de bolas que caen *)
PROCEDURE CalculaCaida(VAR t:Tablero):CARDINAL;
VAR
   x,y,u,v: CARDINAL;
   orden: CARDINAL;
   numero: CARDINAL;
BEGIN
   (* Marcamos la primera fila *)
   FOR x:=1 TO 8 DO
      IF t^[x,0].ocupada THEN
         t^[x,0].marcada:=TRUE;
      END;
   END;
   (* Primera pasada (hacia abajo) *)
   FOR y:=1 TO 9 DO
      FOR x:=1 TO 8 DO
         IF t^[x,y].ocupada THEN
            (* Miramos alrededor *)
            FOR orden:=1 TO 6 DO
               IF (((y+1)MOD 2) <> 0) THEN (* Fila Par *)
                  u:=CARDINAL(INTEGER(x)+mov_px[orden]);
                  v:=CARDINAL(INTEGER(y)+mov_py[orden]);
               ELSE
                  u:=CARDINAL(INTEGER(x)+mov_ix[orden]);
                  v:=CARDINAL(INTEGER(y)+mov_iy[orden]);
               END;
               IF (1<=u) AND (u<=8) AND (0<=v) AND (v<=9) AND
                  t^[u,v].ocupada AND t^[u,v].marcada THEN
                  t^[x,y].marcada:=TRUE;
               END;
            END;
         END; (* IF *)
      END; (* FOR x *)
   END; (* FOR y *)

   (* Segunda pasada (hacia arriba) *)
   FOR y:=9 TO 1 DO
      FOR x:=1 TO 8 DO
         IF t^[x,y].ocupada THEN
            (* Miramos alrededor *)
            FOR orden:=1 TO 6 DO
               IF (((y+1)MOD 2) <> 0) THEN (* Fila Par *)
                  u:=CARDINAL(INTEGER(x)+mov_px[orden]);
                  v:=CARDINAL(INTEGER(y)+mov_py[orden]);
               ELSE
                  u:=CARDINAL(INTEGER(x)+mov_ix[orden]);
                  v:=CARDINAL(INTEGER(y)+mov_iy[orden]);
               END;
               IF (1<=u) AND (u<=8) AND (0<=v) AND (v<=9) AND
                  t^[u,v].ocupada AND t^[u,v].marcada THEN
                  t^[x,y].marcada:=TRUE;
               END;
            END;
         END; (* IF *)
      END; (* FOR x *)
   END; (* FOR y *);

   numero:=Baja(t);
   LimpiaMarcas(t);
   RETURN(numero);
END CalculaCaida;

(* Carga un tablero de un fichero *)
PROCEDURE CargaTablero(VAR t:Tablero; nombre: ARRAY OF CHAR);
VAR
   fichero: FIO.File;
   c: CHAR;
   x,y: CARDINAL;
BEGIN
   fichero:=FIO.Open(nombre);
   c:=FIO.RdChar(fichero);
   x:=1;
   y:=0;
   WHILE c<>'F' DO
      IF c<>'X' THEN
         IF c='A' THEN
            t^[x,y].ocupada:=TRUE;
            t^[x,y].color:=14;
         ELSIF c='V' THEN
            t^[x,y].ocupada:=TRUE;
            t^[x,y].color:=2;
         ELSIF c='R' THEN
            t^[x,y].ocupada:=TRUE;
            t^[x,y].color:=4;
         ELSIF c='M' THEN
            t^[x,y].ocupada:=TRUE;
            t^[x,y].color:=5;
         ELSIF c='G' THEN
            t^[x,y].ocupada:=TRUE;
            t^[x,y].color:=8;
         END;
      END;
      INC(x);
      IF x=9 THEN
         x:=1;
         INC(y);
      END;
      c:=FIO.RdChar(fichero);
   END; (* WHILE *)
   FIO.Close(fichero);
END CargaTablero;

BEGIN
   InicializaTrans();
   PosiblesDirecciones();

END tablero.