(* Jess Garca Pavn '02 *)

IMPLEMENTATION MODULE visual;
IMPORT Graph,BITMAPS;

(* Radio de la bola a pintar *)
CONST radio=20;

(* Inicializa modo grfico *)
PROCEDURE Abre();
VAR
   ok:BOOLEAN;
BEGIN
   ok:=Graph.SetVideoMode(Graph._VRES16COLOR);
END Abre;

(* Vuelve al modo texto *)
PROCEDURE Cierra();
VAR
   ok:BOOLEAN;
BEGIN
   ok:=Graph.SetVideoMode(Graph._DEFAULTMODE);
END Cierra;

(* Dibuja el techo y los laterales *)
PROCEDURE DibujaLaterales(iz,dr,h:CARDINAL);
BEGIN
   Graph.Line(iz,h,iz,479,8);
   Graph.Line(dr,h,dr,479,8);
   Graph.Line(iz,h,dr,h,8);
END DibujaLaterales;

(* Dibuja una bola *)
PROCEDURE DibujaBola(x,y,color:CARDINAL);
BEGIN
   BITMAPS.DibujaBola(x,y,color);
END DibujaBola;

PROCEDURE BorraPantalla;
VAR
   x,y:CARDINAL;
BEGIN
  FOR x:=0 TO 639 DO
     FOR y:=0 TO 479 DO
        Graph.Plot(x,y,0);
     END;
  END;
END BorraPantalla;

END visual.