IMPLEMENTATION MODULE Hiscore;
FROM FIO IMPORT WrChar,WrLn,Open, Close,File,RdStr,RdCard,WrStr,WrCard;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
IMPORT Str;
TYPE
   nodo2= RECORD
            nombre:ARRAY[1..8] OF CHAR;
            puntos:CARDINAL;
            END;
        RECORDS= POINTER TO nodo1;
  nodo1= RECORD
            jugador1: nodo2;
            jugador2: nodo2;
            jugador3: nodo2;
            END;


(* Crea una variable de tipo records *)
PROCEDURE CrearRecord(VAR records:RECORDS);
VAR
BEGIN
   NEW (records);
END CrearRecord;

(* Carga los records desde fichero y los pasa a la variable *)
PROCEDURE CargarRecord(VAR records:RECORDS;fichero:ARRAY OF CHAR);
VAR
f:File;
BEGIN

f:=Open(fichero);
records^.jugador1.puntos:=RdCard(f);
RdStr(f,records^.jugador1.nombre);
records^.jugador2.puntos:=RdCard(f);
RdStr(f,records^.jugador2.nombre);
records^.jugador3.puntos:=RdCard(f);
RdStr(f,records^.jugador3.nombre);

Close(f)

END CargarRecord;


(* Devuelve por referencia el nombre de un RECORD que se encuentra en determinada posicion *)
PROCEDURE MostrarNombreRecord(VAR records:RECORDS;posicion:CARDINAL;VAR nombre:ARRAY OF  CHAR);

VAR
BEGIN
IF posicion=1 THEN
 Str.Copy(nombre,records^.jugador1.nombre);
ELSIF posicion=2 THEN
 Str.Copy(nombre,records^.jugador2.nombre);
ELSE
 Str.Copy(nombre,records^.jugador3.nombre);
END;
END MostrarNombreRecord      ;


(* Devuelve los puntos de los records de una determinada posicion *)
PROCEDURE MostrarPuntosRecord(VAR records:RECORDS;posicion:CARDINAL):CARDINAL;

VAR
BEGIN
IF posicion=1 THEN
 RETURN(records^.jugador1.puntos);
ELSIF posicion=2 THEN
 RETURN(records^.jugador2.puntos);
ELSE
 RETURN(records^.jugador3.puntos);
END;
END MostrarPuntosRecord      ;


(* Inserta puntos en una posicion de los records *)
PROCEDURE InsertarPuntosRecord(VAR records:RECORDS;posicion:CARDINAL;puntos:CARDINAL);
VAR
BEGIN

IF posicion=1 THEN
records^.jugador1.puntos:=puntos;
ELSIF posicion=2 THEN
records^.jugador2.puntos:=puntos;
ELSE
records^.jugador3.puntos:=puntos;
END;
END InsertarPuntosRecord ;

(* Graba la variable records a un archivo *)
PROCEDURE GrabarRecord(VAR records:RECORDS;fichero:ARRAY OF CHAR);
VAR
f:File;
BEGIN
f:=Open(fichero);
WrCard(f,records^.jugador1.puntos,0);
WrStr(f,' ');
WrStr(f,records^.jugador1.nombre);
WrChar(f,CHR(13));
WrChar(f,CHR(10));
WrCard(f,records^.jugador2.puntos,0);
WrStr(f,' ');
WrStr(f,records^.jugador2.nombre);

WrChar(f,CHR(13));
WrChar(f,CHR(10));
WrCard(f,records^.jugador3.puntos,0);
WrStr(f,' ');
WrStr(f,records^.jugador3.nombre);
WrChar(f,CHR(13));
WrChar(f,CHR(10));


Close(f)
END GrabarRecord;

(*Destruye la variable records *)
PROCEDURE DestruirRecord(VAR records:RECORDS);
BEGIN
DISPOSE (records);
END DestruirRecord;

END Hiscore.