IMPLEMENTATION MODULE juego;
FROM FIO IMPORT WrChar,WrLn,Open, Close,File,RdStr,RdCard,WrStr,WrCard;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
IMPORT Str;
TYPE JUEGO=POINTER TO nodo;
     nodo=RECORD;
          puntos:CARDINAL;
          vidas:CARDINAL;
          nivel:CARDINAL;
          END;


(* Crea un juego *)
PROCEDURE Crear(VAR a:JUEGO);
VAR
BEGIN
NEW(a);
a^.nivel:=1;
a^.puntos:=0;
a^.vidas:=3;
END Crear;

(* procedimiento para poner las vidas en un juego *)
PROCEDURE PonerVidas(VAR  a:JUEGO;vidas:CARDINAL);
VAR
BEGIN
    a^.vidas:=vidas;
END PonerVidas;
(* procedimiento para quitar 1 vida en el juego*)
PROCEDURE QuitarVidas(VAR  a:JUEGO);
VAR
BEGIN
        DEC(a^.vidas);
END QuitarVidas;

(* Devuelve el numero de vidas que hay en el juego *)
PROCEDURE Vidas(VAR a:JUEGO):CARDINAL;
VAR
BEGIN
         RETURN a^.vidas;
END Vidas;


(* Suma puntos al juego *)
PROCEDURE SumarPuntos(VAR a:JUEGO;VAR puntos:CARDINAL);
VAR
BEGIN
     a^.puntos:=a^.puntos+puntos;
END SumarPuntos;

(* Devuelve los puntos que hay en el juego *)
PROCEDURE Puntos(VAR a:JUEGO):CARDINAL;
VAR
BEGIN
    RETURN a^.puntos;
END Puntos;

(*Destruye un juego *)
PROCEDURE Destruir(VAR a:JUEGO);
VAR
BEGIN
DISPOSE (a);
END Destruir;

(*Devuelve el nivel actual del juego *)
PROCEDURE Nivel(VAR a:JUEGO):CARDINAL;
VAR
BEGIN
  RETURN a^.nivel;
END Nivel;

(* Aumenta en un valor el nivel del juego *)
PROCEDURE AumentarNivel(VAR a:JUEGO);
VAR
BEGIN
   INC(a^.nivel);
END AumentarNivel;


END juego.