IMPLEMENTATION MODULE pantalla;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM Conver IMPORT TextToGraphX, TextToGraphY;
FROM escribir IMPORT LETRA,Escribir,Cargar,EscribirMucho;
IMPORT escribir;
FROM Lib IMPORT RANDOMIZE,RANDOM;
IMPORT FIO;
FROM Graph IMPORT Plot;
CONST pantallax=79;
      pantallay=44;
TYPE PANTALLA=POINTER TO nodo;
     nodo=RECORD
          imagenArbusto,imagenTierra,imagenManzana:ARRAY[1..8],[1..8] OF CARDINAL;
          tabla:ARRAY [1..pantallax],[1..pantallay] OF CARDINAL;
          END;                          (* 1 seto 2 tierra 3 manzana *)


(* Refresca la Pantalla *)

PROCEDURE Refrescar (VAR a:PANTALLA; VAR nivel:CARDINAL);
VAR
pantallaj,pantallai,i,j,posicionxgrafica,posicionygrafica:CARDINAL;
letra:LETRA;
BEGIN

FOR pantallai:=1 TO pantallax DO
  FOR pantallaj:=1 TO pantallay DO

  posicionxgrafica:=TextToGraphX(pantallai)    ;
  posicionygrafica:=TextToGraphY(pantallaj)    ;
  IF a^.tabla[pantallai,pantallaj]=2 THEN    (*pregunta si es tierra *)
     FOR i:=1 TO 8  DO
         FOR j:=1 TO 8    DO
           Plot(posicionxgrafica+i,posicionygrafica+j,7);

        END;

     END;


  (* Pinta Arbusto *)
  ELSIF a^.tabla[pantallai,pantallaj]=1 THEN
    FOR i:=1 TO 8  DO
        FOR j:=1 TO 8    DO
          Plot(posicionxgrafica+i,posicionygrafica+j,a^.imagenArbusto[i,j]);

        END;
   END;

  ELSE   (*pinta manzana*)
      FOR i:=1 TO 8  DO
         FOR j:=1 TO 8    DO
                Plot(posicionxgrafica+i,posicionygrafica+j,a^.imagenManzana[i,j]);

          END;
      END;




  END;
  END;
END;

END Refrescar;


PROCEDURE Crear(VAR  a:PANTALLA;VAR nivel:CARDINAL);
VAR i,j:CARDINAL;
f:FIO.File;

xmanzana,ymanzana,numeromanzanas:CARDINAL;
BEGIN


NEW(a);
IF nivel=1 THEN

   f:=FIO.Open('level1.txt');
ELSIF nivel=2 THEN
   f:=FIO.Open('level2.txt');
ELSIF nivel=3 THEN
   f:=FIO.Open('level3.txt');
ELSIF nivel=4 THEN
   f:=FIO.Open('level4.txt');
ELSIF nivel=5 THEN
   f:=FIO.Open('level5.txt');
ELSIF nivel=6 THEN
   f:=FIO.Open('level6.txt');

END;







FOR i:=1 TO pantallay DO
    FOR j:=1 TO pantallax  DO
    a^.tabla[j,i]:=FIO.RdCard(f);
    END;

END;

FIO.Close(f);

(*coger el grafico de las manzanas*)
     f:=FIO.Open('manzana.txt');
  FOR i:=1 TO 8 DO
    FOR j:=1 TO 8 DO
    a^.imagenManzana[j,i]:=FIO.RdCard(f);
    END;
  END;
FIO.Close(f);
RANDOMIZE;
(*crear manzanas *)
numeromanzanas:=0;
WHILE numeromanzanas<nivel+10 DO

xmanzana:=RANDOM(pantallax-1)+1;
ymanzana:=RANDOM(pantallay-1)+1;
IF (a^.tabla[xmanzana,ymanzana]#1) AND (a^.tabla[xmanzana,ymanzana]#3) THEN
   IF (xmanzana#10) AND (ymanzana#10) THEN (*miro que no caigan en la serpiente *)
      a^.tabla[xmanzana,ymanzana]:=3;
      INC(numeromanzanas);
   END;
END;
END;

(* coger grfico del arbusto *)

  f:=FIO.Open('arbusto.txt');
  FOR i:=1 TO 8 DO
    FOR j:=1 TO 8 DO
    a^.imagenArbusto[j,i]:=FIO.RdCard(f);
    END;
  END;
FIO.Close(f);



END Crear;



PROCEDURE Destruir (VAR a:PANTALLA);
VAR
BEGIN
DISPOSE (a);

END Destruir;



PROCEDURE PosicionPantallaValida (VAR  a:PANTALLA;VAR x,y:CARDINAL):BOOLEAN;
VAR
BEGIN
RETURN (a^.tabla[x,y]=2) OR (a^.tabla[x,y]=3);

END PosicionPantallaValida;

PROCEDURE HayManzana(VAR a:PANTALLA;VAR x,y:CARDINAL):BOOLEAN;
VAR
BEGIN
 IF a^.tabla[x,y]=3 THEN
    a^.tabla[x,y]:=2;
    RETURN TRUE
 ELSE
 RETURN FALSE;
 END;
END HayManzana;

            (* pintar fondo para que no parpadee*)
PROCEDURE PintarFondo (VAR a:PANTALLA; VAR x,y:CARDINAL);
VAR
i,j,posicionxgrafica,posicionygrafica:CARDINAL;
BEGIN
posicionxgrafica:=TextToGraphX(x)    ;
 posicionygrafica:=TextToGraphY(y)    ;

    FOR i:=1 TO 8  DO
    FOR j:=1 TO 8    DO
     Plot(posicionxgrafica+i,posicionygrafica+j,7);

        END;

  END;

END PintarFondo;

END pantalla.