MODULE ser;
IMPORT juego ;
FROM Window IMPORT CursorOff,Clear;
FROM IO IMPORT RdKey,KeyPressed,RdChar,RdLn;
FROM Lib IMPORT GetTime,Delay,Sound,NoSound;
FROM Graph IMPORT ClearScreen,Line,SelectPalette,SetVideoMode;
IMPORT Hiscore;
IMPORT snake;
IMPORT escribir;
IMPORT pantalla;
IMPORT Str    ;
VAR
a:snake.serpiente;
i:CARDINAL;


(* calcula el retraso del sistema *)
PROCEDURE Retraso():REAL;

VAR
segundos2,horas,minutos,segundos,decimas:CARDINAL;
desfaseentero,desfasecomillas,desfase:REAL;
BEGIN
GetTime(horas,minutos,segundos,decimas);
segundos:=segundos*100+decimas;
Delay(2000);
GetTime(horas,minutos,segundos2,decimas);
segundos2:=segundos2*100+decimas;

  desfase:=REAL(segundos2-segundos);

  desfase:=desfase * 0.005;

  RETURN desfase;





END Retraso;

(* Muestra la presentacion *)
PROCEDURE Presentacion (VAR letra:escribir.LETRA;desfase:REAL);

VAR
a:snake.serpiente;
x,y,i,j:CARDINAL;
Pantalla:pantalla.PANTALLA;
retrasolocal:CARDINAL;
BEGIN
retrasolocal:=(CARDINAL (100. /desfase));
i:=1;
pantalla.Crear(Pantalla,i);
snake.Crear(a);
FOR i:=1 TO 5 DO
snake.Incrementar (a);
END;
FOR  i:=1 TO 9 DO
 snake.UltimaCoords(a,x,y);
  snake.Arriba(a);
  ClearScreen(0);
snake.DibujarSerpiente(a);
Delay(retrasolocal);
END;
FOR  i:=1 TO 10 DO
 snake.UltimaCoords(a,x,y);
  snake.Derecha(a);
  ClearScreen(0);
snake.DibujarSerpiente(a);
Delay(retrasolocal);
END;
FOR j:=1 TO 4 DO
FOR  i:=1 TO 3 DO
 snake.UltimaCoords(a,x,y);
  snake.Abajo(a);
  ClearScreen(0);
snake.DibujarSerpiente(a);
Delay(retrasolocal);
END;
FOR  i:=1 TO 2 DO
 snake.UltimaCoords(a,x,y);
  snake.Izquierda(a);
  ClearScreen(0);
snake.DibujarSerpiente(a);
Delay(retrasolocal);
END;
END;
escribir.EscribirMucho('ERPIENTE',11,9,letra);
Delay(retrasolocal*20);
escribir.EscribirMucho(' POR:',4,13,letra);
escribir.EscribirMucho('JUAN CALDERON DOMINGUEZ',5,15,letra);

snake.Destruir(a);

Delay(retrasolocal*30);
END Presentacion;

           (* Muestra la informacion de la pantalla *)
PROCEDURE InfoPantalla(VAR partida:juego.JUEGO; texto:ARRAY  OF  CHAR ;x,y:CARDINAL;limpiar:BOOLEAN;modo320:BOOLEAN;letra:escribir.LETRA;desfase:REAL);
VAR
video:BOOLEAN;
nivel:CARDINAL;
BEGIN
IF modo320 THEN

 video:=SetVideoMode(19);
 END;
    nivel:=juego.Nivel(partida);
   IF limpiar THEN
    ClearScreen(0);
   END;
   IF Str.Compare('',texto)#0 THEN
   escribir.EscribirMucho(texto,x-5,y-1,letra);
   END;
   escribir.EscribirMucho('NIVEL:',x,y+2,letra);

   escribir.EscribirNumero(nivel,x+7,y+2,letra);
   escribir.EscribirMucho('VIDAS:',x,y+4,letra);
   escribir.EscribirNumero(juego.Vidas(partida),x+7,y+4,letra);
   escribir.EscribirMucho('PUNTOS:',x,y+6,letra);
   escribir.EscribirNumeros(juego.Puntos(partida),x+8,y+6,letra);


IF modo320 THEN
 Delay(CARDINAL(5500. / desfase));
 video:=SetVideoMode(18);
 END;

 END InfoPantalla;





      (* procedimiento que se encarga del juego ens *)
PROCEDURE menu(VAR a:snake.serpiente; VAR Pantalla:pantalla.PANTALLA;VAR partida:juego.JUEGO;letra:escribir.LETRA;desfase:REAL):CARDINAL;
VAR
i,nivel,manzanas,infopantalla,x,y:CARDINAL;
antigua,tecla:CHAR;
puntos,vidas:CARDINAL;
muerta:BOOLEAN;
video:BOOLEAN;
BEGIN
snake.Crear(a); (*creo la serpiente *)
muerta:=FALSE;
nivel:=juego.Nivel(partida);
pantalla.Crear(Pantalla,nivel);
manzanas:=juego.Nivel(partida)+10;
pantalla.Refrescar(Pantalla,nivel);

REPEAT

RdLn;
antigua:=tecla;
IF KeyPressed() THEN
  tecla:=RdKey();
END;
CASE  CAP(tecla) OF

'A' : snake.UltimaCoords(a,x,y);
      snake.Izquierda(a);
      pantalla.PintarFondo(Pantalla,x,y);
      muerta:=snake.Muerde(a);
      snake.CoordenadasSerpiente(a,x,y);
      IF  NOT (pantalla.PosicionPantallaValida(Pantalla,x,y))
          THEN muerta:=TRUE;END;
      IF pantalla.HayManzana(Pantalla,x,y) THEN DEC(manzanas);
       Sound(3000);
       Delay(CARDINAL(30./ desfase));
       NoSound();
       FOR  i:=1 TO  nivel*2   DO (*Incrementar la serpiente segn el nivel*)
       snake.Incrementar(a)
       END;
       puntos:=5*nivel+snake.LongitudSerpiente(a);
       juego.SumarPuntos(partida,puntos);
        InfoPantalla(partida,'JUGADOR',5,38,FALSE,FALSE,letra,desfase);
      END;|

'S' : snake.UltimaCoords(a,x,y);
      snake.Abajo(a);
      pantalla.PintarFondo(Pantalla,x,y);
      muerta:=snake.Muerde(a);
      snake.CoordenadasSerpiente(a,x,y);
      IF  NOT (pantalla.PosicionPantallaValida(Pantalla,x,y)) THEN muerta:=TRUE;END;
      IF pantalla.HayManzana(Pantalla,x,y) THEN DEC(manzanas);
          Sound(3000);
       Delay(CARDINAL(30./ desfase));
       NoSound();
       FOR  i:=1 TO  nivel*2 DO    (*Incrementar la serpiente segn el nivel*)
         snake.Incrementar(a)
       END;
       puntos:=5*nivel+snake.LongitudSerpiente(a);;
       juego.SumarPuntos(partida,puntos);
         InfoPantalla(partida,'JUGADOR',5,38,FALSE,FALSE,letra,desfase);
      END;|

'D' : snake.UltimaCoords(a,x,y);
      snake.Derecha(a);
      pantalla.PintarFondo(Pantalla,x,y);
      muerta:=snake.Muerde(a);snake.CoordenadasSerpiente(a,x,y);
      IF  NOT (pantalla.PosicionPantallaValida(Pantalla,x,y)) THEN muerta:=TRUE;END;
      IF pantalla.HayManzana(Pantalla,x,y) THEN DEC(manzanas);
          Sound(3000);
       Delay(CARDINAL(30./ desfase));
       NoSound();
       FOR  i:=1 TO  nivel*2 DO   (*Incrementar la serpiente segn el nivel*)
         snake.Incrementar(a)
       END;
       puntos:=5*nivel+snake.LongitudSerpiente(a);;
       juego.SumarPuntos(partida,puntos);
        InfoPantalla(partida,'JUGADOR',5,38,FALSE,FALSE,letra,desfase);
      END; |

'W' : snake.UltimaCoords(a,x,y);
      snake.Arriba(a);
      pantalla.PintarFondo(Pantalla,x,y);
      muerta:=snake.Muerde(a);
      snake.CoordenadasSerpiente(a,x,y);
      IF  NOT (pantalla.PosicionPantallaValida(Pantalla,x,y)) THEN muerta:=TRUE;END;
      IF pantalla.HayManzana(Pantalla,x,y) THEN DEC(manzanas);
            Sound(3000);
       Delay(CARDINAL(30./ desfase));
       NoSound();
         FOR  i:=1 TO  nivel*2 DO    (*Incrementar la serpiente segn el nivel*)
         snake.Incrementar(a)
       END;
       puntos:=5*nivel+snake.LongitudSerpiente(a);;
       juego.SumarPuntos(partida,puntos);
         InfoPantalla(partida,'JUGADOR',5,38,FALSE,FALSE,letra,desfase);
      END; |

'P' : snake.Incrementar(a); tecla:=antigua;Clear; snake.DibujarSerpiente(a); |

END;
snake.DibujarSerpiente(a);
Delay(CARDINAL((110. / desfase) - (REAL( (REAL (juego.Nivel(partida)) * 10.)) / desfase) ));
IF muerta THEN
   FOR i:=1 TO 80 DO
   Sound(150+i);
   Delay(CARDINAL (5./desfase))
   END;
   NoSound();
   juego.QuitarVidas(partida);
   InfoPantalla(partida,'HAS MUERTO',10,6,FALSE,TRUE,letra,desfase);
   snake.Destruir(a);
   tecla:='';
   IF juego.Vidas(partida)>0  THEN
      pantalla.Refrescar(Pantalla,nivel);
      InfoPantalla(partida,'JUGADOR',5,38,FALSE,FALSE,letra,desfase);
      snake.Crear(a);
   END;
END;
muerta:=FALSE;


UNTIL (juego.Vidas(partida)=0) OR   (manzanas=0);
snake.Destruir(a);
pantalla.Destruir(Pantalla);
IF manzanas=0 THEN RETURN 2
ELSE RETURN 1;
END;

END menu;



    (* Controla las pantallas y las vidas *)
PROCEDURE Jugar(VAR records:Hiscore.RECORDS;desfase:REAL);
VAR
  video:BOOLEAN;
  Pantalla:pantalla.PANTALLA;
  puntos,seguir,nivel,paleta:CARDINAL;
  partida:juego.JUEGO;
  letra:escribir.LETRA;
BEGIN
escribir.Cargar(letra);
video:=SetVideoMode(18);
nivel:=1;
CursorOff  ;
juego.Crear(partida);
InfoPantalla(partida,'JUGADOR 1:',5,38,FALSE,FALSE,letra,desfase);
seguir:=2;
WHILE (seguir=2) AND (juego.Nivel(partida)#7) DO
InfoPantalla(partida,'JUGADOR ',5,38,FALSE,FALSE,letra,desfase);
seguir:=menu(a,Pantalla,partida,letra,desfase);

      IF seguir=2 THEN
        juego.AumentarNivel(partida);  (*Aumento el nivel*)

           InfoPantalla(partida,'SIGUIENTE NIVEL',6,5,FALSE,TRUE,letra,desfase);

      END;
END;

 IF seguir=1 THEN
         video:=SetVideoMode(19);
         escribir.ScrollHorizontal('FIN DEL JUEGO',2,55,6,CARDINAL(50./desfase),letra);
 ELSE
       video:=SetVideoMode(19);
       escribir.ScrollHorizontal('TE HAS DADO LA VUELTA',2,55,6,CARDINAL(50. /desfase),letra);
              seguir:=1;
 END;
 Delay(CARDINAL(2000.*desfase));

IF Hiscore.MostrarPuntosRecord(records,3)<juego.Puntos(partida) THEN
   escribir.ScrollVertical('HAS CONSEGUIDO EL PUESTO: ',2,8,35,CARDINAL(50./desfase),letra);
   i:=3;
   WHILE (i>0) AND (Hiscore.MostrarPuntosRecord(records,i)<juego.Puntos(partida))  DO
    DEC(i);
   END;
   INC(i);
   nivel:=2   ;
   FOR seguir:=2 TO i BY -1 DO

       puntos:=Hiscore.MostrarPuntosRecord(records,nivel);
       Hiscore.InsertarPuntosRecord(records,nivel+1,puntos);
       nivel:=nivel-1;
   END;
   Hiscore.InsertarPuntosRecord(records,i,juego.Puntos(partida));
   escribir.EscribirNumero(i,28,9,letra);
   Delay(CARDINAL(2000./desfase));
END;


juego.Destruir(partida);
escribir.Destruir(letra);
END Jugar;
(* Muestra el menu del juegp *)
PROCEDURE PintarMenu(opcion:INTEGER;letra:escribir.LETRA);
VAR
video:BOOLEAN;
i:CARDINAL;
BEGIN
video:=SetVideoMode(19);
IF opcion=1 THEN
   FOR i:=1 TO 15 DO
       Line(0,78+i,320,78+i,102+i);
       Line(0,48+i,320,48+i,30+i);
       Line(0,138+i,320,138+i,102+i);
       Line(0,108+i,320,108+i,102+i);
   Line(0,168+i,320,168+i,102+i);

   END;

ELSIF opcion=2   THEN
   FOR i:=1 TO 15 DO
       Line(0,78+i,320,78+i,30+i);
       Line(0,48+i,320,48+i,102+i);
  Line(0,138+i,320,138+i,102+i);
     Line(0,168+i,320,168+i,102+i);

       Line(0,108+i,320,108+i,102+i);

   END;
ELSIF opcion=3 THEN
 FOR i:=1 TO 15 DO
  Line(0,48+i,320,48+i,102+i);
 Line(0,78+i,320,78+i,102+i);
  Line(0,138+i,320,138+i,102+i);
     Line(0,168+i,320,168+i,102+i);

       Line(0,108+i,320,108+i,30+i);
   END;


ELSIF opcion=4 THEN
 FOR i:=1 TO 15 DO
  Line(0,48+i,320,48+i,102+i);
  Line(0,78+i,320,78+i,102+i);
  Line(0,108+i,320,108+i,102+i);
  Line(0,138+i,320,138+i,30+i);
    Line(0,168+i,320,168+i,102+i);
  END;
ELSIF opcion=5 THEN
 FOR i:=1 TO 15 DO
  Line(0,48+i,320,48+i,102+i);
  Line(0,78+i,320,78+i,102+i);
  Line(0,108+i,320,108+i,102+i);
  Line(0,138+i,320,138+i,102+i);
    Line(0,168+i,320,168+i,30+i);
 END;

END;
FOR i:=1 TO 15 DO
  Line(0,18+i,320,18+i,129);
END;

escribir.EscribirMucho('   MENU ',10,2,letra);
escribir.EscribirMucho('   JUGAR ',10,5,letra);
escribir.EscribirMucho('  CREDITOS ',10,8,letra);
escribir.EscribirMucho('   RECORDS  ',10,11,letra);
escribir.EscribirMucho('INSTRUCCIONES',10,14,letra);
escribir.EscribirMucho('   SALIR  ',10,17,letra);
END PintarMenu;

(* Muestra los crditos *)
PROCEDURE Creditos(desfase:REAL);
VAR
  letra:escribir.LETRA;
x,y:CARDINAL;

BEGIN
escribir.Cargar(letra);
ClearScreen(0);

escribir.ScrollVertical(' JUEGO REALIZADO POR:',3,3,30,CARDINAL(100./desfase),letra);

escribir.ScrollVertical(' JUAN CALDERON DOMINGUEZ ',3,6,30,CARDINAL(100./desfase),letra);
FOR x:=1 TO 3 DO
escribir.EscribirMucho('',3,7,letra);
Delay(CARDINAL(700./desfase)) ;
escribir.EscribirMucho(' JUAN CALDERON DOMINGUEZ ',3,7,letra);
Delay(CARDINAL(1000./desfase));
END;
Delay(CARDINAL(1000./desfase));
escribir.Destruir(letra);

END Creditos;

(* Muestra los records *)
PROCEDURE Records(VAR records:Hiscore.RECORDS; VAR letra:escribir.LETRA;desfase:REAL);
VAR
  nombre:ARRAY [1..8] OF CHAR ;
  puntos:CARDINAL;
BEGIN

ClearScreen(0);
escribir.ScrollHorizontal('RECORDS',11,35,2,CARDINAL(50./desfase),letra);
Hiscore.MostrarNombreRecord(records,1,nombre);

escribir.ScrollVertical(nombre,6,4,35,CARDINAL(100./desfase),letra);

Hiscore.MostrarNombreRecord(records,2,nombre);

escribir.ScrollVertical(nombre,6,6,35,CARDINAL(100./desfase),letra);

Hiscore.MostrarNombreRecord(records,3,nombre);
escribir.ScrollVertical(nombre,6,8,35,CARDINAL(100./desfase),letra);

puntos:=Hiscore.MostrarPuntosRecord(records,1);
escribir.EscribirNumeros(puntos,20,5,letra);

puntos:=Hiscore.MostrarPuntosRecord(records,2);
escribir.EscribirNumeros(puntos,20,7,letra);

puntos:=Hiscore.MostrarPuntosRecord(records,3);
escribir.EscribirNumeros(puntos,20,9,letra);





Delay(CARDINAL(7000./desfase));
END Records;


(* Muestra las instrucciones *)
PROCEDURE Instrucciones (VAR letra:escribir.LETRA;desfase:REAL);
VAR

BEGIN
ClearScreen(0);
escribir.ScrollHorizontal('INSTRUCCIONES',8,35,2,CARDINAL(50./desfase),letra);
escribir.ScrollVertical('COMETE LAS MANZANAS DEL',2,6,24,CARDINAL(100./desfase),letra);
escribir.ScrollVertical('JARDIN PARA PASAR A OTRO',2,8,24,CARDINAL(100./desfase),letra);
escribir.ScrollVertical('CUIDADO CON MORDERTE Y',2,10,24,CARDINAL(100./desfase),letra);
escribir.ScrollVertical('CUIDADO CON LOS MUROS ',2,12,24,CARDINAL(100./desfase),letra);

Delay(CARDINAL (3000./desfase));
END Instrucciones;


(* Procedimiento de salir *)
PROCEDURE Salir(letra:escribir.LETRA;desfase:REAL);
VAR
x,y:CARDINAL;
BEGIN
ClearScreen(0);
x:=10;
y:=20;
WHILE y>5 DO
ClearScreen(0);
escribir.EscribirMucho (' ADIOS',x,y,letra);
Delay(CARDINAL(100./desfase));
y:=y-1;
END;
Delay(CARDINAL (1000./desfase));
FOR i:=5 TO 1 BY -1 DO
escribir.EscribirNumero(i,14,8,letra) ;
Sound(CARDINAL(3000./desfase)) ;
Delay(CARDINAL(30./desfase));
NoSound();
Delay(CARDINAL(800./desfase));
END;

END Salir;


VAR
video:BOOLEAN;
letra:escribir.LETRA;
tecla:CHAR ;
opcion:INTEGER;
records:Hiscore.RECORDS;
fichero:ARRAY [1..12] OF CHAR;
desfase:REAL;
BEGIN
desfase:=Retraso();
fichero:='records.txt';
escribir.Cargar(letra);
video:=SetVideoMode(19);
Presentacion(letra,desfase);
Hiscore.CrearRecord(records);
Hiscore.CargarRecord(records,fichero);
PintarMenu(1,letra);

opcion:=1;
REPEAT
REPEAT

  tecla:=RdKey();



RdLn;
CASE CAP(tecla) OF
'S': opcion:=(opcion MOD 5) +1;PintarMenu(opcion,letra);Sound(1000);Delay(CARDINAL (10./desfase));NoSound(); |
'W': IF  opcion=1 THEN  opcion:=5;
     ELSE DEC(opcion)END; ;PintarMenu(opcion,letra);Sound(1000);Delay(CARDINAL(10./desfase));NoSound()
      |
END;

UNTIL tecla=CHR(13);

CASE opcion OF
1: Jugar(records,desfase);  |
2: Creditos(desfase);|
3: Records(records,letra,desfase);|
4: Instrucciones(letra,desfase);|
5: Salir(letra,desfase);
END;
PintarMenu(opcion,letra);

UNTIL opcion=5;
escribir.Destruir(letra);
Hiscore.GrabarRecord(records,fichero);
Hiscore.DestruirRecord(records);
END ser.