IMPLEMENTATION  MODULE  snake    ;
FROM IO IMPORT WrChar;
FROM Conver IMPORT TextToGraphX,TextToGraphY;
FROM Window IMPORT GotoXY;
FROM Graph IMPORT Plot;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
IMPORT FIO  ;

TYPE
     serpiente=POINTER TO nodo;
     nodo=RECORD
          x,y:CARDINAL;
          sig:serpiente;
          END;

(* CREAR SERPIENTE *)

PROCEDURE Crear(VAR  a:serpiente);
VAR
f:FIO.File;
i,j:CARDINAL;
BEGIN
    NEW(a);
    a^.x:=10;
    a^.y:=10;
    a^.sig:=NIL;

    Incrementar(a);
    Incrementar(a);

END Crear;

(* incrementa la serpiente una unidad  *)

PROCEDURE Incrementar(VAR a:serpiente);
VAR aux:serpiente;
i,j:CARDINAL;
BEGIN
    NEW(aux);
    aux^.x:=a^.x;
    aux^.y:=a^.y;
    aux^.sig:=a;
    a:=aux;


END Incrementar;





(*movimiento de la serpiente *)

PROCEDURE Izquierda (VAR a:serpiente);
VAR
aux1,aux:serpiente;
BEGIN
          NEW(aux);
          aux^.x:=(a^.x)-1;
          aux^.y:=a^.y  ;
aux^.sig:=a;
a:=aux;

     aux1:=aux^.sig;
     WHILE aux1^.sig<>NIL DO
        aux:=aux1;
        aux1:=aux1^.sig;
     END;
     aux^.sig:=NIL  ;
     DISPOSE(aux1);
END Izquierda;


PROCEDURE Derecha (VAR a:serpiente);
VAR
aux1,aux:serpiente  ;
i,j,posicionxgrafica,posicionygrafica:CARDINAL;
BEGIN
          NEW(aux);
          aux^.x:=(a^.x)+1;
          aux^.y:=a^.y ;

aux^.sig:=a;
a:=aux;

    aux1:=aux^.sig;
     WHILE aux1^.sig<>NIL DO
        aux:=aux1;
        aux1:=aux1^.sig;
     END;




   aux^.sig:=NIL  ;
     DISPOSE(aux1);
END Derecha;


PROCEDURE Arriba (VAR a:serpiente);
VAR
aux1,aux:serpiente;
BEGIN
          NEW(aux);
          aux^.x:=(a^.x);
          aux^.y:=(a^.y)-1 ;
aux^.sig:=a;
a:=aux;

     aux1:=aux^.sig;
     WHILE aux1^.sig<>NIL DO
        aux:=aux1;
        aux1:=aux1^.sig;
     END;
     aux^.sig:=NIL   ;
     DISPOSE(aux1);

END Arriba;


PROCEDURE Abajo (VAR a:serpiente);
VAR
aux1,aux:serpiente;
BEGIN
  NEW(aux);
  aux^.x:=(a^.x);
  aux^.y:=(a^.y)+1;
  aux^.sig:=a;
  a:=aux;
  aux1:=aux^.sig;
     WHILE aux1^.sig<>NIL DO
        aux:=aux1;
        aux1:=aux1^.sig;
     END;
  aux^.sig:=NIL ;
  DISPOSE(aux1);
END Abajo;


PROCEDURE Destruir(VAR a:serpiente);
VAR
aux:serpiente;
BEGIN
IF a#NIL THEN  (*Si existe *)
   aux:=a^.sig;
   WHILE aux<>NIL DO
         DISPOSE(a);
         a:=aux;
         aux:=aux^.sig;
   END;

   DISPOSE (a);
END;
END Destruir    ;


PROCEDURE DibujarSerpiente(VAR a:serpiente);
VAR
aux:serpiente;
i,j,posicionxgrafica,posicionygrafica:CARDINAL;
color:CARDINAL;

BEGIN
aux:=a;
(*Dibujo la cabeza *)

WHILE aux#NIL DO
 posicionxgrafica:=TextToGraphX(aux^.x);
 posicionygrafica:=TextToGraphY(aux^.y);
 FOR i:=1 TO 8  DO
  FOR j:=1 TO 8    DO
     Plot(posicionxgrafica+i,posicionygrafica+j,2);
  END;
  END;
aux:=aux^.sig
    END;
END DibujarSerpiente;


(* CHEKEA SI LA SERPIENTE SE TOCA A SI MISMA *)

PROCEDURE Muerde(VAR a:serpiente):BOOLEAN;
VAR
muerta:BOOLEAN;

aux:serpiente;
BEGIN
 muerta:=FALSE;
      aux:=a^.sig;

WHILE aux#NIL DO
  IF (aux^.x=a^.x) AND (aux^.y=a^.y)THEN muerta:=TRUE;
  END;
  aux:=aux^.sig;

END;
RETURN muerta;
END Muerde;


(* Devuelve las coordenadas de la cabeza de la serpiente *)

PROCEDURE CoordenadasSerpiente(VAR a:serpiente;VAR x:CARDINAL;VAR y:CARDINAL);
VAR
BEGIN
    x:=a^.x;
    y:=a^.y;
END CoordenadasSerpiente;

(*Devuelve las coordenadas de la cola *)
PROCEDURE UltimaCoords (VAR a:serpiente;VAR  x,y:CARDINAL);
VAR
aux:serpiente;
BEGIN
aux:=a;
WHILE aux^.sig#NIL DO
aux:=aux^.sig;
END;
x:=aux^.x;
y:=aux^.y;
END UltimaCoords;


PROCEDURE LongitudSerpiente(VAR a:serpiente):CARDINAL;
VAR
longitud:CARDINAL;
aux:serpiente;
BEGIN
longitud:=0;
aux:=a;
WHILE aux#NIL DO
 INC (longitud);
 aux:=aux^.sig;
END;
RETURN longitud
END LongitudSerpiente;

END snake.