IMPLEMENTATION MODULE ADORNOS;
     IMPORT Lib, FIO, CTES, MUSICA, FICHGRAF;

     (* El usuario no ve los mduos utilizados, solo ADORNOS *)

     CONST
         DIMGRAF  = CTES.DIMGRAF;
         ANCHOSCR = CTES.ANCHOSCR;
         ALTOSCR  = CTES.ALTOSCR;

     TYPE
        Linea = ARRAY [0.. 4] OF CHAR;

(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ---------------------------------------------------------------------- *)
PROCEDURE Card2Str (    num : CARDINAL;
                    VAR cad : Linea);
  VAR
     i, j : CARDINAL;
  BEGIN
      (* Queremos los ceros a la izda *)
      i := 1;
      cad [0] := CHR ( (num DIV 10000) + 48);
      num := num MOD 10000;
      cad [1] := CHR ( (num DIV 1000)+48);
      num := num MOD 1000;
      cad [2] := CHR ( (num DIV 100)+48);
      num := num MOD 100;
      cad [3] := CHR ( (num DIV 10)+48);
      cad [4] := CHR ( (num MOD 10)+48);

END Card2Str;
(* ---------------------------------------------------------------------- *)
PROCEDURE EscribePuntos (puntos      : CARDINAL;
                         posX, posY  : CARDINAL);
  VAR
    Ok  : BOOLEAN;
    i   : CARDINAL;
    txt : Linea;

  BEGIN
       (* Las posiciones de marcador son fijas *)
       Card2Str (puntos, txt);

       FOR i:= 0 TO 4 DO
           CASE txt[i] OF
             "0"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "cero.raw"  , Ok); |
             "1"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "uno.raw"   , Ok); |
             "2"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "dos.raw"   , Ok); |
             "3"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "tres.raw"  , Ok); |
             "4"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "cuatro.raw", Ok); |
             "5"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "cinco.raw" , Ok); |
             "6"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "seis.raw"  , Ok); |
             "7"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "siete.raw" , Ok); |
             "8"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "ocho.raw"  , Ok); |
             "9"  :  FICHGRAF.dibujaRAW (DIMGRAF, DIMGRAF, posX+(i*DIMGRAF), posY, "nueve.raw" , Ok); |
           END;
       END;
END EscribePuntos;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
PROCEDURE Marcador     ( puntos : CARDINAL;
                         x,y    : CARDINAL;
                         VAR Ok : BOOLEAN);
  BEGIN
      Ok := TRUE;
      EscribePuntos (puntos, x, y);
END Marcador;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
PROCEDURE Sonido       (VAR Ok : BOOLEAN); (* Sonido cuando aplastamos a un bicho *)
   BEGIN
        Lib.Speaker (440,1);   (* Si queremos que el bicho haga un ruido     *)
        Lib.Speaker (540,1);   (* bonito al ser aplastado definir una musica.*)
        Lib.Speaker (640,1);
        Lib.Speaker (540,1);
        Lib.Speaker (440,1);
END Sonido;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
PROCEDURE Musica  (    fich  : ARRAY OF CHAR;
                       veces : CARDINAL;
                   VAR Ok    : BOOLEAN); (* Toca la musica predefinida *)
   VAR
      mus : MUSICA.Cancion;
   BEGIN
       MUSICA.Crear (mus, Ok);
       IF Ok THEN
          MUSICA.LeerPartitura (fich, mus, Ok);
          MUSICA.Tocar (mus, veces, Ok);
       END;
       MUSICA.Destruir (mus);

END Musica;
(* ---------------------------------------------------------------------- *)
PROCEDURE Crear();
    (* No hay nada que crear *)
END Crear;
(* ---------------------------------------------------------------------- *)
PROCEDURE Destruir ();
    (* Aqui destruiremos las musicas....*)
END Destruir;
(* ---------------------------------------------------------------------- *)
PROCEDURE DibujaRAW    (fichero : ARRAY OF CHAR;
                        VAR Ok  : BOOLEAN);
  BEGIN
       (* En realidad es un alias *)
      Ok := ExisteFichero (fichero);
      IF Ok THEN
          FICHGRAF.dibujaRAW (ANCHOSCR, ALTOSCR, 0, 0, fichero, Ok );
      END;
END DibujaRAW;
(* ---------------------------------------------------------------------- *)
PROCEDURE DibujaRLE    (fichero : ARRAY OF CHAR;
                        VAR Ok  : BOOLEAN);
   BEGIN
      Ok := ExisteFichero (fichero);
      IF Ok THEN
        FICHGRAF.dibujaRLE (ANCHOSCR, ALTOSCR, 0, 0, fichero, Ok );
      END;
END DibujaRLE;
(* ---------------------------------------------------------------------- *)

END ADORNOS.