IMPLEMENTATION MODULE FICHGRAF;
       IMPORT FIO, Graph;

     CONST
        ANCHOSCR = 640; (* Maximo ancho de linea permitido por el mdula  *)
        LIMITE   =  16; (* maxima longitud permitida para un segmento RLE *)

     TYPE
         Linea = ARRAY [1.. ANCHOSCR] OF BYTE;

         (* Es ms rpido dibujar por lineas que leer cada pixel
            y dibuyjarlo, en contra esta que necesita ANCHOSCR bytes
            de esta forma
         *)

(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ----------------------------------------------------------- *)

(* ------------------------------------------------------------ *)
(* Dibuja una pantalla con la informacin almacenada en el fichero que se *)
(* pasa como parmetro. El formato de los ficheros .RAW es el BYTE que    *)
(* indica el color de un punto en la pantalla, cuyas coordenadas vienes   *)
(* dadas por la posicin que ocupa en el fichero, dibuja por lineas       *)
(* ------------------------------------------------------------- *)
PROCEDURE dibujaRAW   (    ancho,alto : CARDINAL;
                           x,y        : CARDINAL;
                           nom        : ARRAY OF CHAR;
                       VAR Ok         : BOOLEAN);
  VAR
     f,c   : CARDINAL;
     Fich  : FIO.File;
     linea : Linea;

     num   : CARDINAL;
  BEGIN
      Ok := ExisteFichero (nom);
      f  := 0;
      c  := 0;

      IF Ok THEN
         Fich := FIO.Open (nom);                               (* abrimos el fichero *)
         REPEAT
            num := FIO.RdBin (Fich, linea, ancho      );      (* y leemos linea a linea    *)

            FOR num :=1 TO ancho DO                            (* hasta el final suponemos  *)
               Graph.Plot (c+x,f+y, CARDINAL(linea[num]) );        (* que el fichero tiene      *)
               IF ( (c+1) MOD ancho = 0) THEN                 (* las dimensiones y formato *)
                  f := f+1;   (*linea siguiente*)              (* correctos                 *)
                  c := 0;
               ELSE
                  c := c+1;
               END;
            END;

         UNTIL (f = (alto-1) );
         FIO.Close (Fich);
      END;

END dibujaRAW;
(* ---------------------------------------------------------------------- *)
PROCEDURE dibujaRLE (ancho, alto : CARDINAL;      (* de la imagen en el fichero *)
                     x,y         : CARDINAL;      (* coordenadas del primer pixels eje x,y esquina sup izda *)
                     nom         : ARRAY OF CHAR;
                     VAR Ok      : BOOLEAN);    (* Indica que todo ha ido correctamente.*)

 VAR
     f,c   : CARDINAL;
     Fich  : FIO.File;
     cont  : CARDINAL;
     long  : CARDINAL;   (* longitud de la secuencia de bytes *)
     color : CARDINAL;   (* color para dicha secuencia        *)
     bait  : BYTE;

  BEGIN
      Ok := ExisteFichero (nom);
      f  := 0;
      c  := 0;

      IF Ok THEN
         Fich := FIO.Open (nom);                               (* abrimos el fichero *)
         REPEAT
              cont  := FIO.RdBin (Fich, bait, SIZE(bait) );
              long  := ( CARDINAL(bait) DIV 16 ) + 1;
              color := CARDINAL  (bait) MOD 16;

              FOR cont := 1 TO long DO
                  Graph.Plot (c+x, f+y, color);
                  IF ( (c+1) MOD ANCHOSCR = 0 ) THEN
                      f := f+1;
                      c := 0;
                  ELSE
                      c := c+1;
                  END;
              END;
       UNTIL FIO.EOF;

         FIO.Close (Fich);
      END;

END dibujaRLE;
(* ---------------------------------------------------------------------- *)
(* Este procedimiento es para intnetar alcarar mas el formato de los RLE  *)
(* y pasar los antiguos RAW a RLE                                         *)
(* Un RAW de 640*480*16 colores necesita unos 300 Kb                      *)
(* Un RLE necesitara el mismo espacio SOLO si no tiene cadenas consecutivas *)

PROCEDURE RAW2RLE (raw, rle : ARRAY OF CHAR);
  VAR
     FichRAW, FichRLE : FIO.File;
     i, cont, temp    : CARDINAL;
     color1, color2   : BYTE;

  BEGIN
      (* Suponemos que existe *)
      FichRAW := FIO.Open   (raw);
      FichRLE := FIO.Create (rle);

      i     := 0;
      cont  := 0;

      temp := FIO.RdBin (FichRAW, color1, SIZE(BYTE) );
      WHILE NOT FIO.EOF DO
          (* leemos el color SIN comprimir *)
          REPEAT
             temp := FIO.RdBin (FichRAW, color2, SIZE(BYTE) );
             INC (cont);
          UNTIL (color1 <> color2) OR (cont = LIMITE) OR FIO.EOF;

          (* traducimos *)
          temp := (  (cont-1) * 16 ) + CARDINAL(color1);
                   (* 1er nibble *)      (* 2do nibble *)

          (* escribimos comprimido *)
          FIO.WrBin (FichRLE, BYTE ( temp )  , SIZE(BYTE) );

          color1 := color2;
          cont   := 0;
      END;

      FIO.Close (FichRAW);
      FIO.Close (FichRLE);

END RAW2RLE;
(* ---------------------------------------------------------------------- *)


END FICHGRAF.