IMPLEMENTATION MODULE PANTALLA;

       IMPORT IO, Lib, FIO, Graph, CTES;
       FROM Storage IMPORT Available, ALLOCATE, DEALLOCATE;

       CONST
          DIM       = CTES.DIM;       (* n de celdas          *)
          DIMGRAF   = CTES.DIMGRAF;   (* ancho de cada grfico *)
          ANCHOTBL  = DIM*DIMGRAF;    (* ancho del tablero     *)

          ANCHOSCR  = 640;          (* Indica el ancho del modo de video  *)
          ALTOSCR   = 480;          (* que se tomar por defecto          *)
          FINLINEA  = CHR (10);
          LIMFIL    = DIM DIV 4;    (* para calcular las posiciones validas para *)
          LIMCOL    = DIM DIV 4;    (* crear los sistemas                        *)
          NUMENT    = 5;            (* n de Sistemas en el enumerado *)

       TYPE
          Sistema   = (Vacio, Modula, Cmas, Java, Vbasic);
          rPantalla = RECORD
                          vacio   : BOOLEAN;   (* es muro o no?   *)
                          sistema : Sistema;   (*  es ordenador? *)
                          posFin  : BOOLEAN;   (* es posfinjuego  *)
                      END;
          aPantalla = ARRAY [1..DIM],[1..DIM] OF rPantalla;
          Pantalla  = POINTER TO aPantalla;

          Grafico   = ARRAY [1..DIMGRAF*DIMGRAF] OF CARDINAL;
          LineaGraf = ARRAY [1..ANCHOSCR] OF BYTE;    (* para leer los ficheros de forma mas eficiente que BYTE a BYTE *)

  (* Con el fin de utilizar lo menos posible variables globales, las imgenes *)
  (* se han almacenado como constantes en el propio programa, otra solucin   *)
  (* consistira en cargarlas desde un fichero en variables globales del tipo *)
  (* 'Grafico' al inicializar el mdulo                                       *)

   (* Se ha decidido a propsito que el mdulo contenga todas las opciones del juego*)
   (* sin requerir de modulos externos, esto resta flexibilidad al diseo           *)

      CONST
          VACIO = Grafico(
0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,
0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,
0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,7  ,0  ,7  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,7  ,0  ,7  ,0  ,7  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,7  ,0  ,7  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,7  ,0  ,7  ,0  ,7  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,7  ,0  ,7  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,
0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0
                          );
          MODULA = Grafico(
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,10 ,0  ,0  ,0  ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,0  ,10 ,0  ,0  ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,0  ,10 ,0  ,10 ,10 ,10 ,10 ,0  ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,10 ,0  ,10 ,10 ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,10 ,10 ,0  ,10 ,0  ,0  ,0  ,0  ,0  ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,10 ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,12 ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,0  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,1
);

          C      = Grafico(
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,14 ,14 ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,0  ,0  ,0  ,0  ,14 ,14 ,14 ,0  ,14 ,14 ,14 ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,14 ,14 ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,12 ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,0  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,1
);

          JAVA     = Grafico(
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,14 ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,14 ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,14 ,0  ,14 ,0  ,14 ,0  ,14 ,0  ,14 ,0  ,14 ,0  ,14 ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,14 ,0  ,14 ,0  ,14 ,14 ,14 ,0  ,14 ,0  ,14 ,0  ,14 ,14 ,14 ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,14 ,14 ,0  ,14 ,0  ,14 ,0  ,0  ,14 ,0  ,0  ,14 ,0  ,14 ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,12 ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,0  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,1
);

          VBASIC = Grafico(
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,14 ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,14 ,14 ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,0  ,0  ,0  ,10 ,0  ,0  ,10 ,10 ,10 ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,0  ,0  ,0  ,10 ,0  ,0  ,10 ,0  ,0  ,10 ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,0  ,0  ,0  ,10 ,0  ,0  ,10 ,10 ,10 ,0  ,0  ,14 ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,0  ,0  ,0  ,10 ,0  ,0  ,10 ,0  ,0  ,10 ,14 ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,10 ,10 ,0  ,10 ,0  ,0  ,0  ,10 ,0  ,0  ,10 ,0  ,0  ,14 ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,10 ,0  ,0  ,0  ,0  ,10 ,10 ,10 ,0  ,0  ,14 ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,14 ,8  ,14 ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,0  ,14 ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,12 ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,8  ,14 ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,14 ,14 ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,14 ,14 ,14 ,0  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,8  ,0  ,8  ,14 ,0  ,8  ,0  ,0  ,0  ,8  ,
8  ,0  ,0  ,8  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,0  ,8  ,8  ,8  ,8  ,8  ,0  ,8  ,8  ,8  ,0  ,0  ,8  ,
8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,14 ,0  ,0  ,0  ,0  ,0  ,8  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,1
);

    CHICA = Grafico (
0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,
6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,6  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,6  ,6  ,6  ,
6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,
6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,6  ,6  ,
6  ,0  ,6  ,6  ,12 ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,12 ,6  ,6  ,0  ,6  ,6  ,
6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,
6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,
6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,
6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,
6  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,
6  ,6  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,6  ,6  ,6  ,
0  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,0  ,
8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0
);

    CHICO = Grafico (
0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
8  ,8  ,8  ,8  ,8  ,8  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,8  ,
0  ,8  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,
0  ,0  ,8  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,
0  ,0  ,0  ,8  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,8  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,8  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,8  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,8  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,8  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,
0  ,8  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,8  ,0  ,
8  ,8  ,8  ,8  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,8  ,8  ,8  ,
0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,0  ,6  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,6  ,6  ,6  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0
);

VAR                          (* Son variables globales, se pueden eliminar y aadirlas a las cabeceras *)
   GustaChicas : BOOLEAN;    (* se han dejado por comodida ya que la sorpresa no forma parte del juego... *)
   OdiaChicas  : BOOLEAN;
   EsPascua    : BOOLEAN;

(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ----------------------------------------------------------- *)
PROCEDURE ExisteEstruc (VAR fase : Pantalla) : BOOLEAN;
   BEGIN
      RETURN (fase <> NIL);
END ExisteEstruc;
(* ----------------------------------------------------------- *)
PROCEDURE HayMem () : BOOLEAN;
   BEGIN
      RETURN ( Available(SIZE (aPantalla) ) );
END HayMem;
(* ----------------------------------------------------------- *)
PROCEDURE InicializarFase (VAR fase : aPantalla);
  VAR x,y : CARDINAL;
  BEGIN
      FOR y := 1 TO DIM DO
        FOR x := 1 TO DIM DO
              (* En principio no existen Muros *)
              fase[y,x].vacio   := TRUE;
              fase[y,x].sistema := Vacio;
              fase[y,x].posFin  := FALSE;
        END;
     END;
END InicializarFase;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE Crear     (VAR fase : Pantalla;
                     VAR   Ok : BOOLEAN);
   VAR nodo : Pantalla;
   BEGIN
       Ok := HayMem (); (* es cosa del prog no pasar una VAR que ya este inicializada *)
       IF (Ok) THEN
            NEW             (nodo);
            InicializarFase (nodo^);
            fase := nodo;
       END;
END Crear;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE Destruir  (VAR fase : Pantalla;
                     VAR   Ok : BOOLEAN);
   BEGIN
      Ok := ExisteEstruc (fase);
      IF Ok THEN
         DISPOSE (fase);
      END;
END Destruir;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
(* Dibuja las lineas amarillas que rodean al tablero           *)
(* DESPLZX, DESPLZY indican el desplazamiento respecto al      *)
(* origen x,y de la pantalla                                   *)
(* ----------------------------------------------------------- *)
PROCEDURE DibujaBordes ( DESPLZX,DESPLZY : CARDINAL);
  BEGIN
       (* y que tal pasarle un parametro que ndique a que distancia ? *)
       (* y otro para el color.*)

       Graph.Line (DESPLZX-3, DESPLZY-3     , ANCHOTBL+DESPLZX+3, DESPLZY-3, 14);
       Graph.Line (DESPLZX-1, DESPLZY-1     , ANCHOTBL+DESPLZX+1, DESPLZY-1, 14);

       Graph.Line (DESPLZX-3, DESPLZY+ANCHOTBL+3 , ANCHOTBL+DESPLZX+2, DESPLZY+ANCHOTBL+3, 14);
       Graph.Line (DESPLZX-1, DESPLZY+ANCHOTBL+1 , ANCHOTBL+DESPLZX+1, DESPLZY+ANCHOTBL+1, 14);

       Graph.Line (DESPLZX-3, DESPLZY-3     , DESPLZX-3, DESPLZY+ANCHOTBL+3, 14);
       Graph.Line (DESPLZX-1, DESPLZY-1     , DESPLZX-1, DESPLZY+ANCHOTBL+1, 14);

       Graph.Line (ANCHOTBL+DESPLZX+3, DESPLZY-3 , ANCHOTBL+DESPLZX+3, DESPLZY+ANCHOTBL+3, 14);
       Graph.Line (ANCHOTBL+DESPLZX+1, DESPLZY-1 , ANCHOTBL+DESPLZX+1, DESPLZY+ANCHOTBL+1, 14);

END DibujaBordes;
(* ---------------------------------------------------------------------- *)

(* -----------------------------------------------------------     *)
(* Dbuja las constantes, se prescinde de las llamadas a FICHGRAF  *)
(* -----------------------------------------------------------     *)
PROCEDURE DibujaGrafico (info   : Grafico;
                          x,y   : CARDINAL); (* posiciones de la PANTALLA *)
  VAR
      f,c,t : CARDINAL;
  BEGIN
      f := y; c:= x;        (* temporales *)

      FOR t := 1 TO DIMGRAF*DIMGRAF DO
         Graph.Plot (c,f,info[t]);
         IF (t MOD DIMGRAF = 0) THEN   (* Cambio de linea *)
             f := f+1;
             c := x;
         ELSE
             c := c+1;
         END;
      END;

END DibujaGrafico;
(* ----------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Dibuja la celda de coordenadas x,y en la posicion correspondiente *)
(* a dichas coordenadas respecto al desplazamiento indicado por  *)
(* los parametrso desplaz                                        *)
(* Si los graficos hubiesen sido almacenados en arrays en vez de *)
(* en constantes se podra eliminar todo menos el primer CASE    *)
(* ------------------------------------------------------------- *)
PROCEDURE DibujarCelda (VAR fase    : Pantalla;
                            fil     : CARDINAL;
                            col     : CARDINAL;
                            desplzX : CARDINAL;
                            desplzY : CARDINAL;
                        VAR Ok      : BOOLEAN);
    BEGIN
        (* calculamos las coordenadas *)
        desplzX := desplzX + ( (col-1) * DIMGRAF );
        desplzY := desplzY + ( (fil-1) * DIMGRAF );

        IF NOT EsPascua THEN

            CASE fase^[fil, col].sistema OF
                Vacio  : DibujaGrafico (VACIO  , desplzX, desplzY); |
                Modula : DibujaGrafico (MODULA , desplzX, desplzY); |
                Java   : DibujaGrafico (JAVA   , desplzX, desplzY); |
                Cmas   : DibujaGrafico (C      , desplzX, desplzY); |
                Vbasic : DibujaGrafico (VBASIC , desplzX, desplzY); |
            END;
        ELSE
               (* por la forma de almacenar los graficos *)
               CASE fase^[fil, col].sistema OF
                   Vacio  : DibujaGrafico (VACIO  , desplzX, desplzY); |

                   Modula : IF GustaChicas THEN
                                DibujaGrafico (CHICA , desplzX, desplzY);
                            ELSE
                                DibujaGrafico (CHICO , desplzX, desplzY);
                            END;                                          |
               ELSE
                  IF OdiaChicas THEN
                       DibujaGrafico (CHICA , desplzX, desplzY);
                  ELSE
                       DibujaGrafico (CHICO , desplzX, desplzY);
                  END;
               END;
        END;

END DibujarCelda;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Dibuja todas las celdas por pantalla, se implemento el dibujar*)
(* celda por razones de velocidad ya que  es mas rpido dibujar  *)
(* una sola celda que toda la pantalla cada vez                  *)
(* ------------------------------------------------------------- *)
PROCEDURE Dibujar  (VAR fase    : Pantalla;
                        desplzX : CARDINAL;
                        desplzY : CARDINAL;
                    VAR Ok      : BOOLEAN);
    VAR
       i,j : CARDINAL;

    BEGIN
        DibujaBordes (desplzX, desplzY);
        FOR i:= 1 TO DIM DO
          FOR j:= 1 TO DIM DO
              DibujarCelda (fase , i, j, desplzX, desplzY, Ok);
          END;
        END;

END Dibujar;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Genera una pantalla con los sistemas situados al azar en el   *)
(* centro de la pantalla, 'numero' indica el n de sistemas      *)
(* a generar.                                                    *)
(* ------------------------------------------------------------- *)
PROCEDURE Generar (VAR fase   : Pantalla;
                       numero : CARDINAL;
                   VAR Ok     : BOOLEAN);
    VAR
      fil, col, i : CARDINAL;

    BEGIN

       Ok := ExisteEstruc (fase);
       IF Ok THEN
          InicializarFase (fase^);  (* Borramos la info anterior si existiese *)

          FOR i := 1 TO (numero) DO
             fil := Lib.RANDOM ( (DIM DIV 2) )+LIMFIL; (* de 5 a 15 *)
             col := Lib.RANDOM ( (DIM DIV 2) )+LIMCOL;
             fase^[fil, col].vacio   := TRUE;      (* no hemos comprobado si dos o mas estn el la misma celda.*)
             fase^[fil, col].sistema := Modula;
             fase^[fil, col].posFin  := TRUE;
          END;
       END;
END Generar;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Devuelve la info de la celda x,y en el parametro 'sistem'     *)
(* utilizado para saber si se puede instalar un entorno o ya ha  *)
(* sido instalado antes (o esa celda no permit instalacin)      *)
(* ------------------------------------------------------------- *)
PROCEDURE Obtener (VAR fase   : Pantalla;
                       x,y    : CARDINAL;
                   VAR sistem : BOOLEAN;  (* TRUE si hay un entorno en la celda *)
                   VAR instal : BOOLEAN;
                   VAR Ok     : BOOLEAN); (* instal = se puede instalar otro *)

   BEGIN
         Ok := ExisteEstruc (fase);
         IF (Ok) THEN
            sistem := (fase^[y,x].sistema = Modula);
            instal := (fase^[y,x].sistema = Modula);
         END;

END Obtener;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Instala un entorno nuevo en la celda actual, se selecciona al *)
(* azar entre las opciones posibles.                             *)
(* ------------------------------------------------------------- *)
PROCEDURE Instalar (VAR fase  : Pantalla;
                        x,y   : CARDINAL;
                    VAR Ok    : BOOLEAN);
   VAR
       i : CARDINAL;
   BEGIN
       Ok :=ExisteEstruc (fase);

       IF Ok THEN
             (* seleccionamos un entorno al azar *)
          i := Lib.RANDOM (NUMENT-2)+2; (* del 3 al 5, ya que el tipo va del 0..4 *)
          fase^[y,x].sistema := Sistema(ORD(i))
       END;

END Instalar;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
PROCEDURE FinJuego (VAR fase   : Pantalla;
                    VAR muerto : BOOLEAN;    (* = TRUE si no quedan modulas *)
                    VAR Ok     : BOOLEAN);
   VAR
     x,y      : CARDINAL;
   BEGIN
       muerto := TRUE;

       FOR y := 1 TO DIM DO
           FOR x:= 1 TO DIM DO
               IF (fase^[y,x].sistema = Modula) THEN
                  muerto := FALSE;  (* al menos hay un modula, no morimos *)
                     (* podramos implementarlo con WHILE para no recorrer todo el ARRAY *)
                     (* sino solo hasta encontrar un Modula...*)
               END;
           END;
       END;

END FinJuego;

(* ---------------------------------------------------------------------- *)
(* Inicializa las variables globales para indicar que el usuario ha elegido *)
(* la opcin de huevo de pascua y hace las preguntas necesarias           *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ActivaPascua ();
     VAR
       textCoords : Graph.TextCoords;
       ant, act   : CARDINAL;
       opcion     : CHAR;

     BEGIN
          (* Por comodidad escribe desde el modulo por pantalla. *)
          Graph.ClearScreen (0);
          textCoords := Graph.SetTextPosition (10, 10);
          ant := Graph.SetTextColor (14);  (* AMARILLO *)

          Graph.OutText (" A t que te gustan los Chicos (Y) o las Chicas (X) ? ");
          textCoords := Graph.SetTextPosition (11, 10);
          Graph.OutText (" Introduce tu opcion (Y,X): ");
          IO.RdLn;
          opcion := CAP(IO.RdKey());
          GustaChicas := (opcion = "X");

          textCoords := Graph.SetTextPosition (13, 10);
          Graph.OutText (" Y a t quienes NO te gustan los Chicos (Y) o las Chicas (X) ? ");
          textCoords := Graph.SetTextPosition (14, 10);
          Graph.OutText (" Introduce tu opcion (Y,X): ");
          IO.RdLn;
          opcion     := CAP(IO.RdKey());
          OdiaChicas := (opcion = "X");

          EsPascua :=TRUE;

END ActivaPascua;
(* ---------------------------------------------------------------------- *)

BEGIN
  Lib.RANDOMIZE;    (* Inicializar generado de n aleatorios *)
  EsPascua := FALSE;

END PANTALLA.
