IMPLEMENTATION MODULE RECORDS;
   IMPORT FIO, Str;
   FROM Storage IMPORT Available, ALLOCATE, DEALLOCATE;


   CONST
       MAXCAD = 50;

   TYPE
       Cadena  = ARRAY [1..MAXCAD] OF CHAR;

       Records = POINTER TO nodo;
       nodo    = RECORD
                    nombre : Cadena;
                    puntos : CARDINAL;
                    sig    : Records;
                 END;

(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ----------------------------------------------------------- *)
PROCEDURE ExisteEstruc (VAR fase : Records) : BOOLEAN;
   BEGIN
      RETURN (fase <> NIL);
END ExisteEstruc;
(* ----------------------------------------------------------- *)
PROCEDURE HayMem () : BOOLEAN;
   BEGIN
      RETURN ( Available(SIZE (nodo) ) );
END HayMem;
(* ----------------------------------------------------------- *)
PROCEDURE CrearNodo (VAR nodo : Records;
                     VAR Ok   : BOOLEAN);
  BEGIN
     Ok := HayMem ();     (* Esto se debe comprobar aqui o antes de entrar ??? *)
     IF Ok THEN
         NEW (nodo); (* no es cosa nuestra si ya exista y se pierde *)
         nodo^.puntos := 0;
         nodo^.nombre := "Aqu podras estar t.";
         nodo^.sig    := NIL;
     END;

 END CrearNodo;
(* ----------------------------------------------------------- *)
(* inserta ordenado por puntos de mayor a menor                *)
PROCEDURE InsertarNodo (VAR estruc : Records;
                            nodo   : Records);
  VAR
     act, ant : Records;
  BEGIN

     IF estruc = NIL THEN
         (* el primero *)
         estruc := nodo;
     ELSE
        ant := NIL;
        act := estruc;
        WHILE (act <> NIL) AND (act^.puntos >= nodo^.puntos) DO
           ant := act;       (* con dos punteros es la forma ms sencilla de insertar *)
           act := act^.sig;
        END;
        IF (ant = NIL) THEN
           (* era el primero de todas formas *)
           nodo^.sig := estruc;
           estruc    := nodo;
        ELSE
           nodo^.sig := act;
           ant^.sig  := nodo;
        END;
     END; (* IF estruc = NIL *)


END InsertarNodo;
(* ----------------------------------------------------------- *)


(* -------------------------------------------------------------- *)
PROCEDURE Crear    (VAR estruc : Records;
                    VAR Ok     : BOOLEAN);
   VAR
     cont : CARDINAL;
     nodo : Records;

   BEGIN
     (* Normalmente cuando se accede a una estruc se encuentra inicializada a NIL *)
     (* podemos poner estruc := NIL para asegurarnos si no estamos seguro de lo que hace *)
     (* el entorno al crear las vbles *)
     cont := 1;
     REPEAT
       CrearNodo (nodo, Ok);
       IF Ok THEN InsertarNodo (estruc, nodo); END;
       INC (cont);
     UNTIL (NOT Ok) OR (cont = MAXRECORDS);

END Crear;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)
PROCEDURE Destruir (VAR estruc : Records;
                    VAR Ok     : BOOLEAN);
   BEGIN
       (* Un poquito de recursividad.... *)
       Ok := TRUE;

       IF (estruc <> NIL) THEN
          Destruir (estruc^.sig, Ok);
          DISPOSE (estruc);
       END;

END Destruir;
(* -------------------------------------------------------------- *)
(* DEvuelve TRUE si es un RECORD, ya que tenemos que recorrer la  *)
(* lista el proc poda devolver el indice de la pos del nuevo recor*)
(* de todas formas habra que recorrerla de nuevo.                *)
(* -------------------------------------------------------------- *)
PROCEDURE EsRecord (    puntos : CARDINAL;
                        estruc : Records;
                    VAR Siloes : BOOLEAN;    (* Indica si es RECORD o no *)
                    VAR Ok     : BOOLEAN  );
   VAR
      ptr  : Records;
      cont : CARDINAL;
   BEGIN
      ptr  := estruc;
      cont := 1;
      WHILE (ptr <> NIL) AND (ptr^.puntos >= puntos) AND (cont <= MAXRECORDS) DO
         (* se respeta la antiguedad del RECORD *)
         ptr := ptr^.sig;
         INC (cont);
      END;

      Siloes := (cont <= MAXRECORDS);
      Ok     := TRUE; (* por qu no iba a ser Ok *)

END EsRecord;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)
PROCEDURE Anotar   (     puntos : CARDINAL;
                         nombre : ARRAY OF CHAR;
                     VAR estruc : Records;
                     VAR Ok     : BOOLEAN);
   VAR
      ptr  : Records;
      cont : CARDINAL;
      nodo : Records;

   BEGIN
      ptr  := estruc;
      cont := 1;
      CrearNodo (nodo , Ok);
      IF Ok THEN
         Str.Copy (nodo^.nombre, nombre);
         nodo^.puntos := puntos;
         InsertarNodo (estruc, nodo);
      END;

END Anotar;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)
PROCEDURE Obtener (VAR puntos : CARDINAL;
                   VAR nombre : ARRAY OF CHAR;
                       indice : CARDINAL;
                       estruc : Records;
                   VAR Ok     : BOOLEAN);
   VAR
      cont : CARDINAL;
      ptr  : Records;
   BEGIN
      ptr  := estruc;
      cont := 1;
      Ok   := ExisteEstruc (estruc);
      IF Ok THEN
          WHILE (ptr <> NIL) AND (cont < indice) DO
             ptr := ptr^.sig;
             INC (cont);
          END;
          IF (ptr <> NIL) AND (cont = indice) THEN
             puntos := ptr^.puntos;
             Str.Copy (nombre, ptr^.nombre);
          ELSE
             Ok :=FALSE; (* que no se crea lo que devuelva *)
          END;
      END;
END Obtener;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)

PROCEDURE Cargar   (    fichero : ARRAY OF CHAR;
                    VAR estruc  : Records;
                    VAR    Ok   : BOOLEAN);
   VAR
      Fich : FIO.File;
      ptr  : Records;
      cont : CARDINAL;
      nodo : Records;

   BEGIN
      Ok := ExisteFichero (fichero);
      IF Ok THEN
          Fich :=FIO.Open (fichero);
          REPEAT
            (* creamos el nodo *)
            CrearNodo (nodo, Ok);
            IF Ok THEN
                   nodo^.puntos := FIO.RdCard (Fich);
                   FIO.RdStr(Fich, nodo^.nombre);
                   InsertarNodo (estruc, nodo);
            END;
          UNTIL FIO.EOF OR (NOT Ok);
         FIO.Close (Fich);
      END;
END Cargar;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)
PROCEDURE Salvar   (   fichero  : ARRAY OF CHAR;
                       estruc   : Records;
                    VAR  Ok     : BOOLEAN);
   VAR
      ptr   : Records;
      Fich  : FIO.File;

   BEGIN
      ptr := estruc;
      Ok  := TRUE; (* ya que vamos a crear el fichero, error si no tenemos permisos de escritura*)
      IF Ok THEN
         Fich := FIO.Create (fichero);  (* Sobreescribimos la info *)
         WHILE (ptr <> NIL) DO
            FIO.WrCard (Fich, ptr^.puntos, 0);
            FIO.WrChar (Fich, " ");
            FIO.WrStr  (Fich, ptr^.nombre);
            FIO.WrLn   (Fich);
            ptr := ptr^.sig;   (* es mas elegante algo como avanzar (ptr) y nos separa ms de la implementacin.*)
         END;
         FIO.Close (Fich);
      END;
END Salvar;
(* -------------------------------------------------------------- *)
(* -------------------------------------------------------------- *)



END RECORDS.