(* ****************************************** *)
(* Laboratorio de programacin III.           *)
(* Profesor : Antonio Jos Fernndez Leiva.   *)
(* Alumno   : Rafael Rodrguez Hernndez.     *)
(* ****************************************** *)

MODULE X_MODULA;
   IMPORT FIO, Lib, IO, Graph, Str, MsMouse, Window;

   IMPORT PANTALLA, ENEMIGO, CTES, RETARDO, RECORDS, ADORNOS;

   CONST
       DESPLZX    = CTES.DESPLZX;
       DESPLZY    = CTES.DESPLZY;
       DIMGRAF    = CTES.DIMGRAF;
       DIM        = CTES.DIM;
       ANCHOSCR   = CTES.ANCHOSCR;
       ALTOSCR    = CTES.ALTOSCR;

       ANCHOCELDA = DIMGRAF; (* en nuestro caso coincide con el ancho de cada grfico *)
       ANCHOTBL   = DIM * ANCHOCELDA; (* ANcho del tablero *)

       ESCAPE    = CHR(27); (* tecla escape *)
       ENTER     = CHR(13)+CHR(10);
       MODOVIDEO = 18;   (*640*480*16 colores *)

       PAUSA     = 275;  (* Retardo base, a partir de este se establecer el retardo de cada pantalla *)
       NUMCOMP   = 50;   (* n de comprobaciones de ratn por iteracin, para tener una sensacin de respuesta ms suave *)
       MAXENEM   = 36;   (* NM maximo de enemigos en una pantalla *)
       NUMORD    = 4;    (* n de ordenadores por cada nivel       *)

       FICHRECORD = "records.txt";
       MENU      = "menu.rle";     (* Archivos con los "grficos" *)
       FONDO     = "fondo.rle";
       PRES1     = "portada.rle";
       PRES2     = "historia.rle";
       GAMEOVER  = "fin.rle";
       PASCUA    = "menupas.rle";


       MAXRECORDS = 10;  (* N maximo de RECORD que queremos *)

       NIVEL1     = 10;  (* bichos que hay que aplastar para pasar de nivel *)
       NIVEL2     = 20;
       NIVEL3     = 30;
       NIVEL4     = 50;
       NIVEL5     = 80;

   TYPE
      Banda = ARRAY [1..MAXENEM] OF ENEMIGO.Enemigo; (* salen 6 por cada nivel superado *)
      Linea = ARRAY [1..30] OF CHAR; (* linea de texto para records *)

  (* Los parametros de tipo pantalla, enemigo, records...  *)
  (* en las cabeceras de los procedimientos                *)
  (* se pasarn siempre por referencia para evitar su      *)
  (* copia completa en la pila                             *)

(* ---------------------------------------------------------------------- *)
(* Escribe una cadena de texto por pantalla cuando estamos en modo grfico*)
(* ---------------------------------------------------------------------- *)
PROCEDURE WrStr (txt   : ARRAY OF CHAR;
                 fil   : CARDINAL;   (* Coordenadas     *)
                 col   : CARDINAL;
                 color : CARDINAL);  (* Color del texto *)
   VAR
       textCoord : Graph.TextCoords;
       ant       : CARDINAL;    (* color anterior del txt *)
   BEGIN
       textCoord := Graph.SetTextPosition (fil, col);
       ant       := Graph.SetTextColor (color);
       Graph.OutText (txt);
END WrStr;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Este procedimiento es el uico que utiliza la IO para escribir          *)
(* ya que si estamos aqu entonces NO hemos entrado en el modo Grfico    *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Pausa ();
  VAR tecla : CHAR;
  BEGIN
     IO.WrStr("             Pulse una tecla para continuar.");
     IO.RdLn;
     tecla := IO.RdKey();
     IO.RdLn();  (* Borramos el buffer antes y despues para evitar 'interferencias' *)
END Pausa;
(* ---------------------------------------------------------------------- *)
PROCEDURE ActualizaPant ();
  BEGIN
     (* Se debe llamar a este PROC antes de cualquier cambio en la pantalla *)
     (* Se utiliza sobre todo antes de dibujar cambios en la zona de juego  *)
     MsMouse.UpdateScreen(DESPLZX, DESPLZY, DESPLZX+ANCHOTBL, DESPLZY+ANCHOTBL);

END ActualizaPant;
(* ---------------------------------------------------------------------- *)
PROCEDURE LeerTecla(): CHAR;
   VAR   tecla : CHAR;
   BEGIN
     IF IO.KeyPressed() THEN
           tecla :=  IO.RdKey();
           IF (tecla = CHR(0)) THEN (* Se ha pulsado un caracter extendido, leemeos cual *)
              tecla := IO.RdKey();
           END;
           IO.RdLn;
     END;
     RETURN (CAP (tecla) );
END LeerTecla;
(* ---------------------------------------------------------------------- *)
(* Realiza las acciones necesarias para mover un enemigo a una nueva pos  *)
(* y mostrarlo por pantalla.                                              *)
(* ---------------------------------------------------------------------- *)
PROCEDURE MoverUnEnemigo (VAR enemigo : ENEMIGO.Enemigo;
                          VAR fase    : PANTALLA.Pantalla);
 VAR
     i, x,y : CARDINAL;
     instal : BOOLEAN;
     Ok     : BOOLEAN;
 BEGIN
        ENEMIGO.Obtener (enemigo, x, y, instal, Ok);

        (* Dibujamos la celda que se abandona*)
        IF Ok AND NOT(instal) THEN
           ENEMIGO.Mover   (enemigo, Ok);

            (* Se dibuja primero el enemigo, as puede parecer 'mas suave' el movimiento *)
            (* al existir dos veces el dibujo durante unos instantes                     *)
           ActualizaPant ();
           ENEMIGO.Dibujar (enemigo, DESPLZX, DESPLZY, Ok);
           MsMouse.Cursor (TRUE);

           ActualizaPant ();
           PANTALLA.DibujarCelda (fase, y, x, DESPLZX, DESPLZY, Ok);
           MsMouse.Cursor(TRUE);
        ELSE
          (* Esta instalando el entorno, necesita dos turnos para hacerlo *)
          (* as que  en este turno no se mueve *)
        END;

END MoverUnEnemigo;
(* ---------------------------------------------------------------------- *)
(* MoverEnemigos se encarga de mover Todos los enemigos del juego         *)
(* Hecerlo en un proc. separado nos da la posibilidad de cambiar la       *)
(* forma de almacenar los enemigos sin tener que cambiar demasiados proce.*)
(* ---------------------------------------------------------------------- *)
PROCEDURE MoverEnemigos (VAR malos   : Banda;
                         VAR fase    : PANTALLA.Pantalla;
                             numEnem : CARDINAL);
  VAR
     Ok     : BOOLEAN;
     i      : CARDINAL;
  BEGIN
     FOR i:= 1 TO numEnem DO  (* solo los que entran en juego en este nivel *)
         MoverUnEnemigo (malos[i], fase);
     END;
END MoverEnemigos;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Comprueba si un enemigo empieza o termina de instalar el entorno        *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ComprobarPosEnemigo(VAR fase : PANTALLA.Pantalla;
                              VAR enem : ENEMIGO.Enemigo  );
   VAR
      x,y    : CARDINAL;
      instal : BOOLEAN;
      sistem : BOOLEAN;
      Ok     : BOOLEAN;
   BEGIN
        (* Obtengo sus datos                *)
        ENEMIGO.Obtener (enem, x, y, instal, Ok);

        IF  NOT (instal) THEN      (* No est instalando *)
           (* Compruebo a donde corresponde    *)
           PANTALLA.Obtener (fase, x, y, sistem, instal, Ok);

           (* Pongo a instalar si es necesario, sino lo dejo como estaba *)
           IF sistem THEN
              (* Lo ponemos a instalar y Dibujo la ficha de nuevo      *)
              ENEMIGO.Instalar    (enem, Ok);
              PANTALLA.Instalar   (fase, x, y, Ok);

              ActualizaPant();
              ENEMIGO.Dibujar     (enem, DESPLZX, DESPLZY, Ok);
              MsMouse.Cursor (TRUE);
           END;
        ELSE
              (* SI estamos aqu es porque estaba instalando, ya ha terminado y *)
              (* se lo indicamos *)
              ENEMIGO.Desinstalar (enem, Ok);
              ActualizaPant();
              ENEMIGO.Dibujar     (enem, DESPLZX, DESPLZY, Ok);
              MsMouse.Cursor (TRUE);
        END;

END ComprobarPosEnemigo;
(* ---------------------------------------------------------------------- *)
(* Igual que en moverEnemigos.                                            *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ComprobarPosEnemigos (VAR fase    : PANTALLA.Pantalla;
                                VAR malos   : Banda;
                                    numenem : CARDINAL;
                                VAR Ok      : BOOLEAN);
  VAR
     i : CARDINAL;
  BEGIN
     FOR i:= 1 TO numenem DO
        ComprobarPosEnemigo(fase, malos[i])
     END;

END ComprobarPosEnemigos;
(* ---------------------------------------------------------------------- *)
(* Muestra el n de machacados por pantalla.                              *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Marcador (machac, total : CARDINAL);
  VAR
     Ok : BOOLEAN;
  BEGIN
       (* Las posiciones de marcador son fijas *)
        ADORNOS.Marcador (machac, 185, 454, Ok); (* Mejor utilizar CTES para *)
        ADORNOS.Marcador (total , 490, 454, Ok); (* una mayor facilidad de bsqueda *)
END Marcador;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* recibe en 'f(il)' y 'c(ol)'las coordenadas del raton relativas a la    *)
(* pantalla en modo grfico y las convierte a coordenadas relativas       *)
(* a nuestra matriz en nf (nuevafila) y nc (nuevacolumna)                 *)
(* Cuidado con los cambios fil, col y las coord x,y -- fil = y, col = x   *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Traducir (      f, c   : INTEGER;
                     VAR nf, nc : CARDINAL);
  BEGIN
        nf := ( (f-DESPLZY) DIV ANCHOCELDA )+1;  (* Las filas van desde y=DESPLZ hasta *)
        nc := ( (c-DESPLZX) DIV ANCHOCELDA )+1;  (* y = ANCHOTBL + DESPLZY             *)
        (* sumamos uno ya que para nosotros no tiene sentido corrd 0 *)
END Traducir;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Comprueba si hemos 'disparado', y en caso afirmativo realiza las       *)
(* acciones necesarias P.ej. comprobar si hemos dado a un enemigo...      *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ComprobarRaton (VAR machac  : CARDINAL;   (* en esta fase *)
                          VAR totalm  : CARDINAL;   (* machacads totales *)
                          VAR malos   : Banda;
                              numenem : CARDINAL;   (* n enemigos *)
                              nivel   : CARDINAL;
                          VAR Ok      : BOOLEAN);
   VAR
      i, x, y : CARDINAL;
      tx, ty  : CARDINAL;
      instal  : BOOLEAN;
      info    : MsMouse.MsData;

   BEGIN
      MsMouse.GetStatus (info);    (* preguntamos al raton por su situacin *)
      (* traducimos las coordenadas de la pantalla a coord del tablero *)

      IF info.left_pressed OR info.right_pressed THEN

          Traducir (info.row, info.col, y, x);
          FOR i := 1 TO numenem DO

             ENEMIGO.Obtener (malos[i], tx, ty, instal, Ok);
             IF ( (tx = x) AND (ty = y) ) THEN
                    (* Hemos dado al instalador, lo eliminamos y generamos una nuva posicion *)
                    (* Mostramos el dibujo aplastado por pantalla *)
                  ENEMIGO.Aplastado (malos[i], Ok);
                  ADORNOS.Sonido(Ok);

                  ActualizaPant();
                  ENEMIGO.Dibujar    (malos[i], DESPLZX, DESPLZY, Ok);
                  MsMouse.Cursor(TRUE);
                  ENEMIGO.GenerarPos (malos[i], Ok);

                 (* Otro mas machacado *)
                 INC (machac,1);
                 Marcador  (machac, totalm+machac);
             END;
          END;
          info.left_pressed  := FALSE;
          info.right_pressed := FALSE;
      END;
END ComprobarRaton;
(* ---------------------------------------------------------------------- *)
PROCEDURE DestruirTodo (VAR banda   : Banda;
                        VAR fase    : PANTALLA.Pantalla;
                        VAR records : RECORDS.Records;
                        VAR Ok      : BOOLEAN);
     VAR
         i : CARDINAL;
     BEGIN
         PANTALLA.Destruir (fase, Ok);
         FOR i:= 1 TO MAXENEM DO
            ENEMIGO.Destruir (banda[i], Ok);
         END;
         (* ADORNOS.Destruir (); *)
         RECORDS.Destruir(records, Ok);

END DestruirTodo;
(* ---------------------------------------------------------------------- *)
(* Crea las estructuras necesarias para el juego,en caso de error las     *)
(* destruye, al no conocer las implementaciones de las Lib no sabemos que *)
(* pasara si llamamos a Destruir un Objeto no creado, por lo que no lo hacemos *)
(* Utiliza IO ya que todava no se ha entrado en modo gfico              *)
(* ---------------------------------------------------------------------- *)
PROCEDURE CrearTodo (VAR fase    : PANTALLA.Pantalla;
                     VAR malos   : Banda;
                     VAR records : RECORDS.Records;
                     VAR Ok      : BOOLEAN);
   VAR
       i : CARDINAL;
   BEGIN
       PANTALLA.Crear (fase, Ok);
       IF Ok THEN
            FOR i := 1 TO MAXENEM DO
                ENEMIGO.Crear (malos[i], Ok);
            END;
            IF NOT Ok THEN
               IO.WrStr(" No se pudo crear la estructura. Sin Memoria.");IO.WrLn;
               PANTALLA.Destruir (fase, Ok); (* ya se habia creado *)
            ELSE
               RECORDS.Crear (records, Ok);
               IF NOT Ok THEN
                  IO.WrStr(" No se pudo crear la estructura. Sin Memoria.");IO.WrLn;
                  PANTALLA.Destruir (fase, Ok); (* ya se habia creado *)
                  FOR i := 1 TO MAXENEM DO
                      ENEMIGO.Destruir (malos[i], Ok);
                  END;
               END;
             END;
       ELSE;
          (* no se pudo crear la pantalla *)
          IO.WrStr(" No se pudo crear la estructura. Sin Memoria.");IO.WrLn;
       END;

END CrearTodo;
(* ---------------------------------------------------------------------- *)
(* Realiza las acciones necesarias para empezar un nivel                  *)
(* ---------------------------------------------------------------------- *)
PROCEDURE InicializarJuego (VAR fase    : PANTALLA.Pantalla;
                            VAR malos   : Banda;
                                nivel   : CARDINAL;
                                numEnem : CARDINAL);
  VAR
      Ok : BOOLEAN;
      i  : CARDINAL;
  BEGIN
               (* en cada nivel generamos mas ordenadores *)
         PANTALLA.Generar (fase, nivel * NUMORD , Ok);

         FOR i :=1 TO numEnem DO
            ENEMIGO.GenerarPos (malos[i], Ok);
         END;
         ActualizaPant();
         PANTALLA.Dibujar (fase, DESPLZX, DESPLZY, Ok);

END InicializarJuego;
(* ---------------------------------------------------------------------- *)
(* Comprobamos la existencia de un driver de raton instalado              *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ExisteRaton () : BOOLEAN;
 VAR Ok : BOOLEAN;
 BEGIN
       Ok := MsMouse.Reset() <> MAX(CARDINAL);
       IF NOT Ok THEN
           IO.WrStr(" No se ha encontrado ningun driver para el ratn, ");
           IO.WrStr(" instale uno y vuelva a intentarlo.");IO.WrLn;
       END;
       RETURN (Ok);
END ExisteRaton;
(* ---------------------------------------------------------------------- *)
(*  Este PROC pone las cotas al ratn, estas dependen del modo en el que  *)
(* nos encontremos (texto o grafico) por lo que hay que esperar a entrar  *)
(* en modo grfico para inicializarlas                                    *)
(* ---------------------------------------------------------------------- *)
PROCEDURE InicializarRaton (rango : MsMouse.MsRange);
   BEGIN
           MsMouse.Cursor (TRUE);
           rango.min_col := DESPLZX;           rango.min_row := DESPLZY;
           rango.max_col := DESPLZX+ANCHOTBL;  rango.max_row := DESPLZY+ANCHOTBL;
           MsMouse.SetRange (rango);
END InicializarRaton;
(* ---------------------------------------------------------------------- *)
PROCEDURE CambiarDeNivel (machacados, nivel : CARDINAL): BOOLEAN;
    VAR
        salida : BOOLEAN;
    BEGIN
         CASE nivel OF
             1 :  salida := machacados >= NIVEL1;             |
             2 :  salida := machacados >= NIVEL2;             |
             3 :  salida := machacados >= NIVEL3;             |
             4 :  salida := machacados >= NIVEL4;             |
             5 :  salida := machacados >= NIVEL5;             |
         ELSE
            salida := FALSE; (* Hasta OverFlow, ya tiene que ser bueno y tener paciencia...*)
         END;

      RETURN (salida);
END CambiarDeNivel;
(* ---------------------------------------------------------------------- *)
(* Comprueba si debeos mostrar el Huevo de Pascua                         *)
(* ---------------------------------------------------------------------- *)
PROCEDURE HuevoDePascua (nivel : CARDINAL);
     VAR
        Ok    : BOOLEAN;
        color : Window.Color;
        tecla : CHAR;
     BEGIN
          IF nivel > 5 THEN
             ADORNOS.DibujaRLE (PASCUA, Ok);
             IO.RdLn;tecla := IO.RdKey();IO.RdLn;
          END;
END HuevoDePascua;
(* ---------------------------------------------------------------------- *)
PROCEDURE VerRecords (records : RECORDS.Records);
   VAR
      Fich   : FIO.File;
      nombre : Linea;
      numtxt : Linea; (* almacena los puntos en modo texto *)
      puntos : CARDINAL;
      i      : CARDINAL;
      tecla  : CHAR;
      Ok     : BOOLEAN;
   BEGIN
             Graph.ClearScreen (0);
             WrStr("Ŀ",1,8,12);
             WrStr("        TOP 10 MACHACADORES            ",2,8 ,12);
             WrStr("",3,8 ,12);

             FOR i:= 1 TO MAXRECORDS DO
                  RECORDS.Obtener (puntos, nombre, i, records, Ok);
                  Str.CardToStr(LONGCARD(puntos), numtxt, 10, Ok);
                  WrStr(numtxt  , i+5 , 18, 15); (* POSICIONES FIJAS *)
                  WrStr(nombre  , i+5 , 30, 15);
             END;

       WrStr(" Pulsa una tecla para continuar. ", 20, 8, 15);
       IO.RdLn; tecla := IO.RdKey();IO.RdLn;

END VerRecords;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Comprueba si conseguimos entrar en los records con nuestra puntuacin  *)
(* y en caso afirmativo registra nuestro nombre                           *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ComprobarRecords (VAR records : RECORDS.Records;
                                 puntos : CARDINAL);
  VAR
     Ok     : BOOLEAN;
     loes   : BOOLEAN;
     nombre : Linea;

  BEGIN
       RECORDS.EsRecord (puntos, records, loes, Ok);
       IF loes THEN
           Graph.ClearScreen (0);
           WrStr(" Introduce tu nombre jefe : ", 15, 10 , 15);
           IO.RdStr(nombre); (* RECUERDA, esto no se VE por pantalla, un proc *)
           RECORDS.Anotar (puntos, nombre, records, Ok);

           VerRecords (records); (* para que se queda ms ancho que largo *)
       END;
END ComprobarRecords;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Comprobamos el raton mediante sondeo, se realizan varias comprobaciones*)
(* por iteracin para tener una mayor sensacin de suavidad al machacar.  *)
(* ---------------------------------------------------------------------- *)
PROCEDURE RatonSuave (VAR machac  : CARDINAL;   (* en esta fase *)
                      VAR totalm  : CARDINAL;   (* machacads totales *)
                      VAR malos   : Banda;
                          numenem : CARDINAL;   (* n enemigos *)
                          nivel   : CARDINAL;
                      VAR Ok      : BOOLEAN);
  VAR
     suave : CARDINAL;
  BEGIN
      FOR suave := 1 TO NUMCOMP DO    (* comprobamos el raton mediante polling (sondeo) *)
          ComprobarRaton  (machac, totalm, malos, numenem, nivel, Ok);
          Lib.Delay (1); (*si no utilizamos este retraso puede ser bastante dificil dar al bicho*)
      END;

END RatonSuave;
(* ---------------------------------------------------------------------- *)

(* ---------------------------------------------------------------------- *)
(* Aqui es donde se desarrolla el juego. es el principal de nuestra prctica *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Jugar (VAR fase    : PANTALLA.Pantalla;
                 VAR malos   : Banda;
                 VAR records : RECORDS.Records;
                     retardo : CARDINAL);
   VAR
      suave   : CARDINAL;   machacados : CARDINAL;   numEnem  : CARDINAL;
                            totalm     : CARDINAL;   nivel    : CARDINAL;
      Ok      : BOOLEAN;    letra      : CHAR;       finjuego : BOOLEAN;
   BEGIN

       ActualizaPant();
       ADORNOS.DibujaRLE (FONDO , Ok);

       totalm    := 0; machacados := 0;
       nivel     := 1; (* Nivel inicial          *)
       numEnem   := 6; (* N inicial de enemigos *)

        InicializarJuego (fase, malos, nivel, numEnem);   (* Se hace de todo un poco *)
        REPEAT
             MsMouse.Cursor  (TRUE);

              RatonSuave          (machacados, totalm, malos, numEnem, nivel, Ok);
             ComprobarPosEnemigos (fase, malos, numEnem, Ok);
              RatonSuave          (machacados, totalm, malos, numEnem, nivel, Ok);
             MoverEnemigos        (malos, fase, numEnem);
              RatonSuave          (machacados, totalm, malos, numEnem, nivel, Ok);

             Lib.Delay (retardo);
             letra := LeerTecla();     (* por si queremos salir *)
             PANTALLA.FinJuego( fase, finjuego, Ok);

             IF (NOT finjuego) AND (CambiarDeNivel (machacados, nivel) )THEN
                 nivel      := nivel   + 1;
                 numEnem    := numEnem + 4;
                 retardo    := retardo - 25  ; (* nivel1 = 400, n2 = 350, n3 = 300, n4 = 250, n5 = 200 *)
                 InicializarJuego (fase, malos, nivel, numEnem);

                 totalm     := totalm + machacados;
                 machacados := 0;
                 Marcador   (machacados, totalm); (* actualizamos contadores *)
             END;

        UNTIL (letra = ESCAPE) OR (finjuego);

        IF finjuego THEN
             ActualizaPant();
             ADORNOS.DibujaRLE (GAMEOVER , Ok);
             ADORNOS.Musica ("muerto.mus", 1, Ok);
             Lib.Delay (1000);  (* MAL, esto depende de la velocidad de la mquina *)
        END;

        (* records y huevo de pascua, se muestran aunque se salga con escape *)
        HuevoDePascua (nivel);
        ComprobarRecords       (records, machacados + totalm);

END Jugar;
(* ---------------------------------------------------------------------- *)
(* Muestra el menu por pantalla, es caso de no encontrar el fichero       *)
(* pasa a jugar directamente.                                             *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Menu():CHAR;
   VAR
     opcion : CHAR;
     Ok     : BOOLEAN;
     tcor   : Graph.TextCoords;
 BEGIN

     ADORNOS.DibujaRLE (MENU , Ok);

     IF Ok THEN
        REPEAT
          opcion    := LeerTecla();
          IF opcion = "O" THEN opcion := CAP (IO.RdKey() ); END;

        UNTIL( (opcion=ESCAPE) OR (opcion = "J") OR (opcion = "A") OR
               (opcion = "R")  OR (opcion = "O") OR (opcion = "V"));

        IO.RdLn;
     ELSE
        (* Si no se "ve" el menu solo se puede jugar o salir *)
        opcion := "J";
     END;

     RETURN(opcion);

END Menu;
(* ---------------------------------------------------------------------- *)
(* Nos permite modificar el retardo del juego para las mquinas rpidas   *)
(* No se realiza ninguna comprobacin, por lo que un retardo demasiado    *)
(* paqueo puede generar un underflow al pasar de nivel                   *)
(* ---------------------------------------------------------------------- *)
PROCEDURE ModifRetardo (VAR retardo : CARDINAL;
                            manual  : BOOLEAN);
    VAR
        Ok   : BOOLEAN;
        cad  : Linea; (* Cad; *)
        temp : CARDINAL;
    BEGIN

        IF manual THEN
              (* Ya estamos en modo grfico *)
           Graph.ClearScreen (0);
           WrStr(" El retardo actual es de ", 10, 15, 7);
           Str.CardToStr(LONGCARD(retardo), cad, 10, Ok);
           WrStr(cad, 10, 41, 7);
           WrStr("milisegundos."+ENTER, 10, 45 , 7);

           WrStr(" Introduce el nuevo retardo (> ", 12, 10, 7);
           Str.CardToStr( PAUSA , cad, 10, Ok);
           WrStr(cad, 12, 41, 7);
           WrStr(") : ", 12, 46, 7);
           retardo := IO.RdCard();
           Str.CardToStr( LONGCARD(temp) , cad, 10, Ok);
           WrStr(cad, 12, 55, 7);

        ELSE
               (* Todava en modo texto, le hacemos creer que su equipo es una maravilla aunque no lo sea *)
            IO.WrStr(" Comprobando la velocidad de tu equipo,     ");IO.WrLn;
            IO.WrStr(" esta operacin puede tardar unos segundos. ");IO.WrLn;
            retardo := RETARDO.Ajustar (PAUSA);      (* ajustamos el retardo base *)
            IO.WrStr(" Comprobacin Finalizada.");IO.WrLn;
        END;

END ModifRetardo;
(* ---------------------------------------------------------------------- *)
(* Muestra las pantallas de presentacion etc...                           *)
(* ---------------------------------------------------------------------- *)
PROCEDURE Presentacion ();
   VAR
      tecla : CHAR;
      Ok    : BOOLEAN;
   BEGIN

      ADORNOS.DibujaRLE (PRES1 , Ok);
      IF Ok THEN
         IO.RdLn; tecla := IO.RdKey(); IO.RdLn;
         ADORNOS.DibujaRLE (PRES2, Ok);
         ADORNOS.Musica  ("barbq.mus", 0, Ok);

         IF Ok THEN
            tecla := IO.RdKey(); IO.RdLn;
         END;
      END;

END Presentacion;
(* ---------------------------------------------------------------------- *)

VAR
   fase       : PANTALLA.Pantalla;
   malos      : Banda;
   records    : RECORDS.Records;
   rango      : MsMouse.MsRange;

   opcion     : CHAR;
   Ok         : BOOLEAN;
   Ok_raton   : BOOLEAN;
   temp       : CARDINAL;
   retardo    : CARDINAL;

BEGIN

       CrearTodo (fase, malos, records, Ok);
       Ok_raton := ExisteRaton();
       ModifRetardo (retardo, FALSE);        (* Calcular Delay automtico *)

       IF (Ok) AND (Ok_raton) AND (Graph.SetVideoMode(MODOVIDEO) ) THEN
               InicializarRaton (rango);
               RECORDS.Cargar   (FICHRECORD, records, Ok);
               ActualizaPant();
               Presentacion ();

               REPEAT
                    opcion := Menu ();
                    Graph.ClearScreen (0); (* Borramos toda la pantalla *)
                    CASE opcion OF
                         "J"  : Jugar (fase, malos, records, retardo) ; |
                         "V"  : ModifRetardo(retardo, TRUE);          |
                         "R"  : VerRecords(records);                         |
                         "O"  : PANTALLA.ActivaPascua();
                                ADORNOS.Musica ("starwars.mus", 0, Ok);
                                Jugar (fase, malos, records, retardo);  |
                    END;
               UNTIL (opcion = ESCAPE);

            (* Guardamos antes de salir *)
            RECORDS.Salvar (FICHRECORD, records, Ok);

            (* Tambien destruimos los enemigos *)
            DestruirTodo(malos, fase, records, Ok);

            Ok := Graph.SetVideoMode (MAX (CARDINAL) );
       ELSE
         (* no se pudo entrar en modo video, no memoria, no raton. Ya se inform de ello *)
          Pausa();
       END;

END X_MODULA.