IMPLEMENTATION MODULE ENEMIGO;

    FROM Storage IMPORT Available, ALLOCATE, DEALLOCATE;
    IMPORT Lib, Graph, FIO, CTES;

    CONST
        DIMGRAF = CTES.DIMGRAF;
        DIM     = CTES.DIM;

        NUMMOVS = 8;     (* n de moviminetos posibles  *)
        ARRIBA  = 1;     (* para identificar los movimientos *)
        ARRDCHA = 2;
        DCHA    = 3;
        ABJDCHA = 4;
        ABAJO   = 5;
        ABJIZDA = 6;
        IZDA    = 7;
        ARRIZDA = 8;

    TYPE
        rEnemigo = RECORD
                       x, y       : CARDINAL;  (* Otra posible implementacion es *)
                       instalando : BOOLEAN;   (* con un enumerodo que indique el*)
                       aplastado  : BOOLEAN;   (* estado actual, intalando, aplastado, vivo*)
                   END;

        Enemigo  = POINTER TO rEnemigo;

        Grafico   = ARRAY [1..DIMGRAF*DIMGRAF] OF CARDINAL;

      CONST
          TIO = Grafico (
0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,0  ,
0  ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,
0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,7  ,7  ,7  ,7  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,7  ,7  ,7  ,7  ,7  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,8  ,8  ,8  ,7  ,7  ,7  ,8  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,
6  ,12 ,12 ,12 ,12 ,6  ,6  ,8  ,15 ,15 ,15 ,15 ,15 ,15 ,15 ,15 ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,12 ,6  ,6  ,7  ,15 ,15 ,15 ,15 ,7  ,15 ,15 ,15 ,7  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,15 ,15 ,0  ,15 ,7  ,15 ,0  ,15 ,7  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,15 ,15 ,15 ,15 ,15 ,15 ,15 ,15 ,7  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,15 ,15 ,15 ,7  ,8  ,7  ,15 ,15 ,7  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,7  ,15 ,7  ,8  ,7  ,8  ,15 ,7  ,8  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,
0  ,6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,8  ,7  ,7  ,7  ,7  ,7  ,6  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,7  ,7  ,7  ,7  ,7  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,
0  ,0  ,6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,6  ,8  ,7  ,8  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,0  ,
0  ,0  ,0  ,12 ,12 ,12 ,12 ,6  ,12 ,12 ,6  ,4  ,0  ,0  ,6  ,12 ,6  ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,
0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,6  ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,6  ,6  ,0  ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0
);

          INSTALL = Grafico (
0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,0  ,
0  ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,
0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,7  ,7  ,7  ,7  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,7  ,7  ,7  ,7  ,7  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,8  ,8  ,8  ,7  ,7  ,7  ,8  ,8  ,8  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,
6  ,12 ,12 ,12 ,12 ,6  ,6  ,8  ,8  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,12 ,6  ,6  ,7  ,0  ,0  ,0  ,0  ,7  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,0  ,0  ,12 ,0  ,7  ,0  ,12 ,0  ,0  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,7  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,8  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,15 ,0  ,0  ,7  ,8  ,7  ,0  ,0  ,7  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,
6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,7  ,15 ,7  ,8  ,7  ,8  ,15 ,7  ,8  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,
0  ,6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,8  ,7  ,15 ,8  ,15 ,7  ,6  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,6  ,
0  ,6  ,12 ,12 ,12 ,12 ,6  ,6  ,6  ,8  ,7  ,7  ,8  ,7  ,7  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,
0  ,0  ,6  ,12 ,12 ,12 ,6  ,6  ,6  ,6  ,6  ,8  ,7  ,8  ,6  ,6  ,6  ,6  ,12 ,12 ,12 ,12 ,6  ,0  ,
0  ,0  ,0  ,12 ,12 ,12 ,12 ,6  ,12 ,12 ,6  ,4  ,0  ,0  ,6  ,12 ,6  ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,
0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,6  ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,6  ,6  ,0  ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,6  ,6  ,6  ,6  ,6  ,6  ,6  ,0  ,0  ,0  ,0  ,0  ,0  ,0  ,0
);

          APLASTA= Grafico(
0  ,0  ,0  ,0  ,0  ,0  ,8  ,8  ,0  ,0  ,0  ,12 ,0  ,12 ,12 ,8  ,8  ,12 ,12 ,12 ,0  ,0  ,0  ,0  ,
0  ,0  ,12 ,0  ,0  ,0  ,8  ,0  ,12 ,12 ,0  ,0  ,0  ,0  ,8  ,0  ,8  ,0  ,12 ,0  ,0  ,12 ,0  ,0  ,
12 ,12 ,12 ,12 ,12 ,12 ,8  ,12 ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,12 ,12 ,0  ,0  ,12 ,12 ,12 ,0  ,
0  ,12 ,0  ,0  ,12 ,0  ,8  ,0  ,0  ,12 ,12 ,0  ,12 ,0  ,12 ,12 ,8  ,0  ,0  ,0  ,12 ,12 ,0  ,0  ,
0  ,12 ,0  ,12 ,0  ,12 ,12 ,0  ,0  ,12 ,12 ,8  ,0  ,12 ,12 ,12 ,8  ,12 ,12 ,0  ,0  ,12 ,0  ,0  ,
0  ,0  ,0  ,0  ,0  ,12 ,8  ,0  ,12 ,0  ,0  ,12 ,12 ,12 ,12 ,0  ,8  ,12 ,0  ,0  ,0  ,0  ,0  ,0  ,
8  ,8  ,8  ,8  ,8  ,12 ,8  ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,8  ,8  ,8  ,12 ,8  ,8  ,12 ,8  ,
0  ,8  ,0  ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,12 ,12 ,0  ,0  ,0  ,0  ,12 ,0  ,
0  ,0  ,8  ,0  ,12 ,0  ,12 ,12 ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,12 ,0  ,0  ,12 ,8  ,0  ,0  ,
0  ,12 ,0  ,8  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,12 ,12 ,8  ,12 ,12 ,0  ,12 ,8  ,0  ,8  ,12 ,12 ,0  ,12 ,12 ,12 ,0  ,12 ,0  ,0  ,12 ,0  ,
12 ,12 ,12 ,12 ,0  ,8  ,12 ,12 ,0  ,12 ,12 ,12 ,8  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,0  ,0  ,
0  ,12 ,12 ,0  ,8  ,12 ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,12 ,0  ,8  ,12 ,12 ,0  ,0  ,
0  ,0  ,0  ,8  ,0  ,12 ,0  ,0  ,12 ,12 ,8  ,12 ,12 ,0  ,12 ,12 ,12 ,12 ,0  ,0  ,8  ,0  ,0  ,0  ,
0  ,0  ,8  ,12 ,0  ,12 ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,12 ,0  ,0  ,0  ,0  ,8  ,0  ,0  ,
0  ,8  ,0  ,12 ,0  ,0  ,12 ,12 ,12 ,0  ,12 ,12 ,12 ,12 ,0  ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,8  ,0  ,
8  ,8  ,12 ,12 ,12 ,12 ,8  ,12 ,0  ,0  ,0  ,12 ,12 ,0  ,12 ,12 ,8  ,12 ,8  ,8  ,12 ,12 ,8  ,8  ,
0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,12 ,0  ,0  ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,12 ,0  ,0  ,
0  ,0  ,12 ,0  ,12 ,12 ,8  ,12 ,0  ,0  ,0  ,12 ,12 ,12 ,0  ,0  ,12 ,0  ,0  ,12 ,12 ,0  ,12 ,0  ,
0  ,0  ,0  ,0  ,0  ,12 ,8  ,0  ,12 ,12 ,8  ,0  ,12 ,0  ,0  ,0  ,12 ,0  ,0  ,0  ,0  ,12 ,12 ,12 ,
0  ,12 ,0  ,0  ,0  ,0  ,12 ,12 ,0  ,8  ,0  ,0  ,0  ,8  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,12 ,0  ,0  ,
12 ,12 ,12 ,0  ,12 ,12 ,12 ,12 ,8  ,0  ,12 ,0  ,0  ,12 ,8  ,0  ,8  ,0  ,0  ,12 ,0  ,12 ,0  ,12 ,
12 ,0  ,0  ,0  ,0  ,12 ,12 ,8  ,0  ,0  ,0  ,12 ,12 ,12 ,0  ,8  ,8  ,0  ,0  ,0  ,12 ,12 ,0  ,0  ,
0  ,0  ,12 ,0  ,0  ,0  ,8  ,0  ,0  ,0  ,0  ,0  ,12 ,0  ,0  ,0  ,8  ,0  ,0  ,12 ,0  ,0  ,0  ,0
  );



(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ----------------------------------------------------------- *)
PROCEDURE ExistePant (VAR ficha : Enemigo) : BOOLEAN;
   BEGIN
      RETURN (ficha <> NIL);
END ExistePant;
(* ----------------------------------------------------------- *)
PROCEDURE HayMem () : BOOLEAN;
   BEGIN
      RETURN ( Available(SIZE (rEnemigo) ) );
END HayMem;
(* ----------------------------------------------------------- *)
PROCEDURE InicializarEnemigo (VAR ficha : rEnemigo);
  VAR x,y : CARDINAL;
  BEGIN
      FOR y := 1 TO DIM DO
        FOR x := 1 TO DIM DO
              ficha.x          := 1;
              ficha.y          := 1;
              ficha.instalando := FALSE;
              ficha.aplastado  := FALSE;
        END;
     END;
END InicializarEnemigo;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
(* Genera una posicin al azar para un enemigo                 *)
(* ----------------------------------------------------------- *)
PROCEDURE GenerarPos (VAR ficha : Enemigo;
                      VAR Ok    : BOOLEAN );
    VAR
      x,y : CARDINAL;

    BEGIN
       Ok := ExistePant (ficha);
       IF Ok THEN
          (* Tiene que salir por el borde de la pantalla *)
          IF Lib.RANDOM (2) = 0 THEN (* sale por un lado *)
             IF  Lib.RANDOM (2) = 0 THEN
                 x := 1;    (* columna 1 *)
             ELSE
                 x := DIM;
             END;
             y := Lib.RANDOM (DIM)+1;   (* fila 1 ..20    *)
          ELSE
             (* sale por arriba o abajo *)
             x := Lib.RANDOM (DIM)+1;   (* columna 1 o 20 *)
             IF Lib.RANDOM (2)= 0 THEN
                y := 1;   (* fila 1 *)
             ELSE
                y := DIM;
             END;
          END;

          ficha^.x := x;
          ficha^.y := y;
          ficha^.instalando := FALSE;
          ficha^.aplastado  := FALSE;

       END;
END GenerarPos;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE Crear     (VAR fase : Enemigo;
                     VAR   Ok : BOOLEAN);
   VAR nodo : Enemigo;
   BEGIN
       Ok := HayMem (); (* es cosa del prog no pasar una VAR que ya este inicializada *)
       IF (Ok) THEN
            NEW             (nodo);
            InicializarEnemigo (nodo^);
            fase := nodo;
       END;
END Crear;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE Destruir  (VAR ficha : Enemigo;
                     VAR   Ok : BOOLEAN);
   BEGIN
      Ok := ExistePant (ficha);
      IF Ok THEN
         DISPOSE (ficha);
      END;
END Destruir;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
(* Dibuja un grafico desde nuestro modulo sin salir a FICHGRAF *)
(* ----------------------------------------------------------- *)
PROCEDURE DibujaGrafico (info   : Grafico;
                          x,y   : CARDINAL); (* posiciones de la PANTALLA *)
  VAR
      f,c,t : CARDINAL;
  BEGIN
      f := y; c:= x;

      FOR t := 1 TO DIMGRAF*DIMGRAF DO
         Graph.Plot (c,f,info[t]);
         IF (t MOD DIMGRAF = 0) THEN   (* Cambio de linea *)
             f := f+1;
             c := x;
         ELSE
             c := c+1;
         END;
      END;

END DibujaGrafico;
(* ----------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
PROCEDURE DibujarCelda (VAR ficha   : Enemigo;
                            fil     : CARDINAL;
                            col     : CARDINAL;
                            desplzX : CARDINAL;
                            desplzY : CARDINAL;
                        VAR Ok      : BOOLEAN);
    VAR
        i : CARDINAL;
    BEGIN
        desplzX := desplzX + ( (col-1) * DIMGRAF );   (* calculamos las posiciones REALES del bicho*)
        desplzY := desplzY + ( (fil-1) * DIMGRAF );   (* se resta uno para empezar en desplz a dibujar *)

        IF ficha^.aplastado THEN                          (* Son excluyentes *)
            DibujaGrafico (APLASTA , desplzX, desplzY);
        ELSIF (ficha^.instalando) THEN
            DibujaGrafico (INSTALL , desplzX, desplzY);
        ELSE
            DibujaGrafico (TIO     , desplzX, desplzY);
        END;

END DibujarCelda;

(* ------------------------------------------------------------- *)
(* ------------------------------------------------------------- *)
PROCEDURE Dibujar  (VAR ficha    : Enemigo;
                        desplzX : CARDINAL;
                        desplzY : CARDINAL;
                    VAR Ok      : BOOLEAN);
    BEGIN
        DibujarCelda (ficha, ficha^.y, ficha^.x, desplzX, desplzY, Ok);
END Dibujar;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Mueve un enemigo dentro de las posiciones vlidas             *)
(* ------------------------------------------------------------- *)
PROCEDURE Mover    (VAR ficha : Enemigo;
                    VAR Ok    : BOOLEAN);
   VAR
      x,y, nx, ny : CARDINAL;
      dir         : CARDINAL;
      valido      : BOOLEAN;  (* Nuestro mueco intentar moverse hasta llegar a una posicin valida *)
   BEGIN
       (* Como los sistemas simpre van a estar mas o menos en el centro de *)
       (* el tablero, la inteligencia de los muecos va a consistir        *)
       (* en ir al centro del tablero, de todas formas se aadirn casos   *)
       (* para que el movimiento sea ms aleatorio                         *)
       valido := FALSE;

       Ok := ExistePant (ficha);
       IF Ok THEN
           x := ficha^.x;
           y := ficha^.y;

               REPEAT
                  dir := Lib.RANDOM (NUMMOVS)+1;
                  CASE dir OF
                     ARRIBA  : IF (y > 1)               THEN DEC (ficha^.y);               valido:=TRUE; END;|
                     ARRDCHA : IF (y > 1)   AND (x<DIM) THEN DEC (ficha^.y);INC (ficha^.x);valido:=TRUE;  END;|
                     DCHA    : IF               (x<DIM) THEN                INC (ficha^.x);valido:=TRUE;  END;|
                     ABJDCHA : IF (y < DIM) AND (x<DIM) THEN INC (ficha^.y);INC (ficha^.x);valido:=TRUE;  END;|
                     ABAJO   : IF (y < DIM)             THEN INC (ficha^.y);               valido:=TRUE;  END;|
                     ABJIZDA : IF (y<DIM)   AND (x>1)   THEN INC (ficha^.y);DEC (ficha^.x);valido:=TRUE;  END;|
                     IZDA    : IF               (x>1)   THEN                DEC (ficha^.x);valido:=TRUE;  END;|
                     ARRIZDA : IF (y >1)   AND  (x>1)   THEN DEC (ficha^.y);DEC (ficha^.x);valido:=TRUE;  END;|
                  END;
               UNTIL (valido);
      END;
END Mover;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Devuelve el estado actual de la ficha                         *)
(* ------------------------------------------------------------- *)
PROCEDURE Obtener (VAR ficha  : Enemigo;
                   VAR x,y    : CARDINAL;
                   VAR instal : BOOLEAN;
                   VAR  Ok    : BOOLEAN);
    BEGIN
       Ok := ExistePant (ficha);
       IF Ok THEN
            x := ficha^.x;
            y := ficha^.y;
            instal := ficha^.instalando;
       END;
END Obtener;
(* ------------------------------------------------------------- *)

(* ------------------------------------------------------------- *)
(* Cambia el estado de la ficha a instalar=TRUE                  *)
(* ------------------------------------------------------------- *)
PROCEDURE Instalar (VAR ficha : Enemigo;
                    VAR Ok    : BOOLEAN);
    BEGIN
       Ok := ExistePant (ficha);
       IF Ok THEN
          ficha^.instalando := TRUE;
       END;
END Instalar;
(* ------------------------------------------------------------- *)
PROCEDURE Desinstalar (VAR ficha : Enemigo;
                       VAR Ok    : BOOLEAN);
    BEGIN
       Ok := ExistePant (ficha);
       IF Ok THEN
            ficha^.instalando := FALSE;
       END;
END Desinstalar;
(* ------------------------------------------------------------- *)
PROCEDURE Aplastado   (VAR ficha : Enemigo;
                       VAR Ok    : BOOLEAN);
    BEGIN
       Ok := ExistePant(ficha);
       IF Ok THEN
          ficha^.aplastado := TRUE;
       END;
END Aplastado;
(* ------------------------------------------------------------- *)

BEGIN
   Lib.RANDOMIZE;

END ENEMIGO.
