IMPLEMENTATION MODULE MUSICA;
     IMPORT FIO,Lib;
     FROM Storage IMPORT Available, ALLOCATE, DEALLOCATE;

     CONST
        (* se proporcionan las notas de la octava 4, ??? por   *)
        (* ejemplo    vemos que La4 = 440Hz y queremos un La5  *)
        (* (mas agudo) doblamos la frecuencia La5 = 880        *)
        (* el La1 = 55Hz                                       *)
        (* Un silencio es una nota de 0 Hz                     *)

         C = 262 DIV 4;  CS = 277 DIV 4; (* C = DO, D = RE *)
         D = 293 DIV 4;  DS = 311 DIV 4;
         E = 329 DIV 4;
         F = 349 DIV 4;  FS = 369 DIV 4;
         G = 392 DIV 4;  GS = 415 DIV 4;
         A = 440 DIV 4;  AS = 466 DIV 4;
         B = 493 DIV 4;
         H = 0; (* silencio*)


     TYPE
        pMusica = POINTER TO rMusica;
        rMusica = RECORD
                   nota   : CARDINAL; (* Su frecuencia en Hz *)
                   dur    : CARDINAL; (* Duracion de la nota *)
                   octava : CARDINAL; (* Aguda o grave *)
                   sig    : pMusica;
               END;

        Cancion = POINTER TO RECORD
                       tempo  : CARDINAL;
                       musica : pMusica;
                  END;

(* ----------------------------------------------------------- *)
PROCEDURE ExisteFichero (nom : ARRAY OF CHAR) : BOOLEAN;
   BEGIN
      RETURN ( FIO.Exists (nom) );
END ExisteFichero;
(* ----------------------------------------------------------- *)
PROCEDURE ExisteEstruc (VAR mus : Cancion) : BOOLEAN;
   BEGIN
      RETURN (mus <> NIL);
END ExisteEstruc;
(* ----------------------------------------------------------- *)
PROCEDURE HayMem () : BOOLEAN;
   BEGIN
      RETURN ( Available(SIZE (rMusica) ) );
END HayMem;
(* ----------------------------------------------------------- *)
PROCEDURE Crear        (VAR cancion : Cancion;
                        VAR Ok      : BOOLEAN);
    VAR
       nodo : Cancion;
    BEGIN
        Ok := HayMem ();
        IF Ok THEN
           NEW (nodo);
           nodo^.tempo  := 0;
           nodo^.musica := NIL;   (* Se crear al insertar notas. *)
           cancion      := nodo;
        END;
END Crear;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE Destruir     (VAR cancion : Cancion);
  VAR
     ptr : pMusica;
  BEGIN

     IF cancion <> NIL THEN
        WHILE (cancion^.musica <> NIL) DO
           ptr             := cancion^.musica;
           cancion^.musica := cancion^.musica^.sig;
           DISPOSE (ptr);
        END;

        DISPOSE (cancion); (* Eliminamos la memoria del registro *)
     END;

END Destruir;
(* ----------------------------------------------------------- *)

(* ----------------------------------------------------------- *)
PROCEDURE InsertarFin (VAR cancion : Cancion;
                           sonido  : rMusica);
   VAR
      tmp : pMusica;
      ptr : pMusica;
   BEGIN
        NEW (tmp);
         tmp^      := sonido;  (* Asignamos directamente, no hay ARRAY OF CHAR*)
         tmp^.sig  := NIL;

        (* Este mtodo recorre la lista cada vez... *)
        IF cancion^.musica = NIL THEN (* el primero, la llamada a Crear sabemos que existe la estruc => cancion <>NIL *)
             cancion^.musica := tmp;
        ELSE
           (* No es el primero *)
           ptr := cancion^.musica;
           WHILE ptr^.sig<>NIL DO
              ptr := ptr^.sig;
           END;
           ptr^.sig := tmp; (* enlazamos al final *)
        END;

END InsertarFin;
(* ----------------------------------------------------------- *)
PROCEDURE traducir (    d1,d2,n1,n2,octa : CHAR;
                    VAR mus              : rMusica);
  VAR
     i,j   : CARDINAL;
     oc    : CARDINAL;
  BEGIN

            i := ORD(d1) - ORD('0');    (* primero la duracion *)
            j := ORD(d2) - ORD('0');

            mus.dur    := 1000 DIV ( (i*10) + j );
            mus.octava := ORD(octa) - ORD('0');    (* octava       *)

            IF n1="_" THEN
               CASE CAP (n2) OF
                   'C' : mus.nota := 262 DIV 4; |
                   'D' : mus.nota := 293 DIV 4; |
                   'E' : mus.nota := 329 DIV 4; |
                   'F' : mus.nota := 349 DIV 4; |
                   'A' : mus.nota := 440 DIV 4; |
                   'B' : mus.nota := 493 DIV 4; |
                   'G' : mus.nota := 392 DIV 4; |
                   'H' : mus.nota := 0;|
               END;
            ELSE
                CASE CAP(n2) OF
                    'C' : mus.nota := 277 DIV 4; |(* s = DO Sostenido,RE bemol *)
                    'D' : mus.nota := 311 DIV 4; |
                    'F' : mus.nota := 369 DIV 4; |
                    'G' : mus.nota := 415 DIV 4; |
                    'A' : mus.nota := 466 DIV 4; |
                END;
            END;

END traducir;

(* ----------------------------------------------------------- *)
PROCEDURE LeerPartitura (    fichero : ARRAY OF CHAR;
                         VAR cancion : Cancion;
                         VAR Ok      : BOOLEAN);
   VAR
      tempo  : CARDINAL;
      regtmp : rMusica;
      d1,d2  : CHAR;  (* para la duracion *)
      n1,n2  : CHAR;
      octa   : CHAR;   (* en realidad solo hace falta un CHAR, se ha hecho as por claridad *)
      Fich   : FIO.File;

   BEGIN
     (* Suponemos un formato de fichero correcto *)
     Ok := ExisteFichero (fichero);

     IF Ok AND HayMem() THEN
          Fich := FIO.Open (fichero);
            (* Suponemos que la estrucutura existe, es tarea del programador que as sea *)
              cancion^.tempo := FIO.RdCard(Fich);

              (* Esto sta mal, leeremos las ultimas 5 notas, las lamacenamos y leeremos EOF y 4 cosas raras *)

              REPEAT
                   d1   := FIO.RdChar(Fich);
                   IF (d1 <> CHR(26) ) AND (d1 <> CHR (13) ) AND (d1 <> " ") THEN
                      d2   := FIO.RdChar(Fich);
                      n1   := FIO.RdChar(Fich);
                      n2   := FIO.RdChar(Fich);
                      octa := FIO.RdChar(Fich);
                      traducir (d1, d2, n1, n2, octa, regtmp);
                      InsertarFin (cancion, regtmp);
                   END;
              UNTIL FIO.EOF OR (d1= CHR(13)) OR (d1 = CHR(26)) ;

          FIO.Close(Fich);
     END;

END LeerPartitura;
(* ----------------------------------------------------------- *)
(* ----------------------------------------------------------- *)
PROCEDURE Tocar         (    cancion : Cancion;
                             repetir : CARDINAL;
                         VAR Ok      : BOOLEAN);
  VAR
     ptr : pMusica;
     i   : CARDINAL;

  BEGIN
       Ok := ExisteEstruc(cancion);
       IF Ok AND (cancion^.musica <> NIL) THEN

          FOR i:=0 TO repetir DO
              ptr := cancion^.musica;
              WHILE ptr <> NIL DO
                  Lib.Speaker (ptr^.nota * ptr^.octava , ptr^.dur);
                  Lib.Delay ( cancion^.tempo);
                  ptr := ptr^.sig;
              END; (* while  *)
          END;  (* for  *)
      END;   (* if *)
END Tocar;
(* ----------------------------------------------------------- *)


END MUSICA.