% Batch demo for varying input dimension
clear all
close all
warning off



ResultsFileName='./ResultsBatchDimensionHT.mat';

NumTrainSamples=100000;
NumTestSamples=100000;

ListDatasets={'Two','Three','Four','Five','Six'};
NumDatasets=numel(ListDatasets);


TrainingSamples=cell(1,10);
TestSamples=cell(1,10);
if exist(ResultsFileName,'file')
    load(ResultsFileName,'Results');
else
    Results=cell(1,NumDatasets);
end
for NdxDataset=1:NumDatasets
    NdxDataset
    if isempty(Results{NdxDataset}) || Results{NdxDataset}.CPUtime(10)<=0
        % Generate samples
        rand('twister',5489);

        for NdxRun=1:10
            TrainingSamples{NdxRun}=insideSphereGen(NdxDataset+1,NumTrainSamples);
            TestSamples{NdxRun}=insideSphereGen(NdxDataset+1,NumTestSamples);
        end


        % Run algorithm
        if isempty(Results{NdxDataset})
            mlp=zeros(10,1);
            mlpte=zeros(10,1);
            CPUtime=zeros(10,1);
        else
            mlp=Results{NdxDataset}.mlp;
            mlpte=Results{NdxDataset}.mlpte;
            CPUtime=Results{NdxDataset}.CPUtime;
        end
        for NdxRun=1:10
            z=TrainingSamples{NdxRun};
            zte=TestSamples{NdxRun};
            
            if CPUtime(NdxRun)<=0
                NumHistograms=50;
                tstart = tic;
                [lp,lpte,LowerMargin,UpperMargin,Result] = OptimizedDHT(z,zte,NumHistograms);
                mlp(NdxRun) = mean(lp);
                mlpte(NdxRun) = mean(lpte);
                CPUtime(NdxRun)= toc(tstart);
                Results{NdxDataset}.mlp=mlp;
                Results{NdxDataset}.mlpte=mlpte;
                Results{NdxDataset}.CPUtime=CPUtime;
                save(ResultsFileName,'Results');
            end
            
        end
        
    end
end


