% Batch demo for varying number of samples
clear all
close all
warning off



ResultsFileName='./ResultsBatchNumSamplesHT.mat';

ListNumSamples=[10000:10000:100000 200000:100000:1000000];
NumDatasets=numel(ListNumSamples);

TrainingSamples=cell(1,10);
TestSamples=cell(1,10);
if exist(ResultsFileName,'file')
    load(ResultsFileName,'Results');
else
    Results=cell(1,NumDatasets);
end
for NdxDataset=1:NumDatasets
    NdxDataset
    if isempty(Results{NdxDataset}) || Results{NdxDataset}.CPUtime(10)<=0
        % Generate samples
        rand('twister',5489);
        NumTrainSamples=ListNumSamples(NdxDataset);
        NumTestSamples=ListNumSamples(NdxDataset);

        for NdxRun=1:10
            TrainingSamples{NdxRun}=insideSphereGen(3,NumTrainSamples);
            TestSamples{NdxRun}=insideSphereGen(3,NumTestSamples);
        end


        % Run algorithm
        if isempty(Results{NdxDataset})
            mlp=zeros(10,1);
            mlpte=zeros(10,1);
            CPUtime=zeros(10,1);
            MSE=zeros(10,1);
        else
            mlp=Results{NdxDataset}.mlp;
            mlpte=Results{NdxDataset}.mlpte;
            CPUtime=Results{NdxDataset}.CPUtime;
            MSE=Results{NdxDataset}.MSE;
        end
        for NdxRun=1:10
            z=TrainingSamples{NdxRun};
            zte=TestSamples{NdxRun};
            
            if CPUtime(NdxRun)<=0
                NumHistograms=50;
                tstart = tic;
                [lp,lpte,LowerMargin,UpperMargin,Result] = OptimizedDHT(z,zte,NumHistograms);
                mlp(NdxRun) = mean(lp);
                mlpte(NdxRun) = mean(lpte);
                CPUtime(NdxRun)= toc(tstart);
                MSE(NdxRun)=mean((exp(lpte)-3/(4*pi)).^2);
                Results{NdxDataset}.mlp=mlp;
                Results{NdxDataset}.mlpte=mlpte;
                Results{NdxDataset}.CPUtime=CPUtime;
                Results{NdxDataset}.MSE=MSE;
                save(ResultsFileName,'Results');
            end
            
        end
        
    end
end


