% Batch demo for synthetic datasets
clear all
close all
addpath('./Images2D');



ResultsFileName='./ResultsBatchSyntheticHT.mat';

NumTrainSamples=100000;
NumTestSamples=100000;

ListFileNames={'Ball.jpg','ThickS.jpg','ThinS.jpg','ThreeBalls.jpg','TwoShapes.jpg','X.jpg','SmoothBall.jpg','ManyBalls.jpg',...
    'Star.jpg','Hexagon.jpg','Octagon.jpg','Ellipse.jpg'};
NumDatasets=numel(ListFileNames)+7;


TrainingSamples=cell(1,10);
TestSamples=cell(1,10);
if exist(ResultsFileName,'file')
    load(ResultsFileName,'Results');
else
    Results=cell(1,NumDatasets);
end
for NdxDataset=1:NumDatasets
    NdxDataset
    if isempty(Results{NdxDataset}) || Results{NdxDataset}.CPUtime(10)<=0
        % Generate samples
        rand('twister',5489);

        if NdxDataset<=7        
            for NdxRun=1:10
                TrainingSamples{NdxRun}=GenerateSamples3D(NdxDataset,NumTrainSamples);
                TestSamples{NdxRun}=GenerateSamples3D(NdxDataset,NumTestSamples);
            end
        else
            FileName=ListFileNames{NdxDataset-7};
            for NdxRun=1:10            
                TrainingSamples{NdxRun}=GenerateSamplesImg(FileName,NumTrainSamples);
                TestSamples{NdxRun}=GenerateSamplesImg(FileName,NumTestSamples);
            end
        end

        % Run algorithm
        if isempty(Results{NdxDataset})
            mlp=zeros(10,1);
            mlpte=zeros(10,1);
            CPUtime=zeros(10,1);
        else
            mlp=Results{NdxDataset}.mlp;
            mlpte=Results{NdxDataset}.mlpte;
            CPUtime=Results{NdxDataset}.CPUtime;
        end
        for NdxRun=1:10
            z=TrainingSamples{NdxRun};
            zte=TestSamples{NdxRun};
            
            if CPUtime(NdxRun)<=0
                NumHistograms=50;
                tstart = tic;
                [lp,lpte,LowerMargin,UpperMargin,Result] = OptimizedDHT(z,zte,NumHistograms);
                mlp(NdxRun) = mean(lp);
                mlpte(NdxRun) = mean(lpte);
                CPUtime(NdxRun)= toc(tstart);
                Results{NdxDataset}.mlp=mlp;
                Results{NdxDataset}.mlpte=mlpte;
                Results{NdxDataset}.CPUtime=CPUtime;
                save(ResultsFileName,'Results');
            end
            
        end
        
    end
end

