% Batch demo for UCI real datasets
clear all
close all
warning off

ResultsFileName='./ResultsBatchUCIHT.mat';

MaxSamples=1.0e5;
MaxDimension=3;

DatasetNames={'CorelColorHistogram','CorelColorMoments','CorelCoocTexture','CorelLayoutHistogram',...
    'CoverType'};
NumDatasets=numel(DatasetNames);


TrainingSamples=cell(1,10);
TestSamples=cell(1,10);
if exist(ResultsFileName,'file')
    load(ResultsFileName,'Results');
else
    Results=cell(1,NumDatasets);
end
for NdxDataset=1:NumDatasets
    NdxDataset
    if isempty(Results{NdxDataset}) || Results{NdxDataset}.CPUtime(10)<=0
        % Generate samples
        rand('twister',5489);
        % Load dataset
        load(sprintf('./UCI/%s.mat',DatasetNames{NdxDataset}),'Samples');
        Samples=double(Samples);
        % Reduce dimensionality by global PCA and sphere the data
        Dimension=min([MaxDimension size(Samples,1)]);
        C=cov(Samples');
        Mu=mean(Samples,2);
        Options.disp=0;
        [Uq Lambdaq]=eigs(C,Dimension,'LM',Options);
        Samples=repmat(1./sqrt(diag(Lambdaq)),[1 size(Samples,2)]).*(Uq'*(Samples-repmat(Mu,[1 size(Samples,2)])));
        % Reduce number of samples by random sampling
        if size(Samples,2)>MaxSamples
            Indices=randperm(size(Samples,2));
            Samples=Samples(:,Indices(1:MaxSamples));
        end
        NumSamples=size(Samples,2);
        Indices=ceil(10*rand(1,NumSamples));
        for NdxRun2=1:10
            TrainingSamples{NdxRun2}=Samples(:,Indices~=NdxRun2);
            TestSamples{NdxRun2}=Samples(:,Indices==NdxRun2);
        end


        % Run algorithm
        if isempty(Results{NdxDataset})
            mlp=zeros(10,1);
            mlpte=zeros(10,1);
            CPUtime=zeros(10,1);
        else
            mlp=Results{NdxDataset}.mlp;
            mlpte=Results{NdxDataset}.mlpte;
            CPUtime=Results{NdxDataset}.CPUtime;
        end
        for NdxRun=1:10
            z=TrainingSamples{NdxRun};
            zte=TestSamples{NdxRun};
            
            if CPUtime(NdxRun)<=0
                NumHistograms=50;
                tstart = tic;
                [lp,lpte,LowerMargin,UpperMargin,Result] = OptimizedDHT(z,zte,NumHistograms);
                mlp(NdxRun) = mean(lp);
                mlpte(NdxRun) = mean(lpte);
                CPUtime(NdxRun)= toc(tstart);
                Results{NdxDataset}.mlp=mlp;
                Results{NdxDataset}.mlpte=mlpte;
                Results{NdxDataset}.CPUtime=CPUtime;
                save(ResultsFileName,'Results');
            end
            
        end
        
    end
end

